/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type PoliciesEndUserType = 'individual'|'business';

/**
 * Initialize the PoliciesList
 *
 * @param version - Version of the resource
 */
declare function PoliciesList(version: V1): PoliciesListInstance;

interface PoliciesListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): PoliciesContext;
  /**
   * Streams PoliciesInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: PoliciesInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams PoliciesInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: PoliciesListInstanceEachOptions, callback?: (item: PoliciesInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a policies
   *
   * @param sid - The unique string that identifies the Policy resource
   */
  get(sid: string): PoliciesContext;
  /**
   * Retrieve a single target page of PoliciesInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: PoliciesPage) => any): Promise<PoliciesPage>;
  /**
   * Retrieve a single target page of PoliciesInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: PoliciesPage) => any): Promise<PoliciesPage>;
  /**
   * Lists PoliciesInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: PoliciesInstance[]) => any): Promise<PoliciesInstance[]>;
  /**
   * Lists PoliciesInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: PoliciesListInstanceOptions, callback?: (error: Error | null, items: PoliciesInstance[]) => any): Promise<PoliciesInstance[]>;
  /**
   * Retrieve a single page of PoliciesInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: PoliciesPage) => any): Promise<PoliciesPage>;
  /**
   * Retrieve a single page of PoliciesInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: PoliciesListInstancePageOptions, callback?: (error: Error | null, items: PoliciesPage) => any): Promise<PoliciesPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface PoliciesListInstanceEachOptions {
  callback?: (item: PoliciesInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface PoliciesListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface PoliciesListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface PoliciesPayload extends PoliciesResource, Page.TwilioResponsePayload {
}

interface PoliciesResource {
  friendly_name: string;
  requirements: object;
  sid: string;
  url: string;
}

interface PoliciesSolution {
}


declare class PoliciesContext {
  /**
   * Initialize the PoliciesContext
   *
   * @param version - Version of the resource
   * @param sid - The unique string that identifies the Policy resource
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a PoliciesInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: PoliciesInstance) => any): Promise<PoliciesInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class PoliciesInstance extends SerializableClass {
  /**
   * Initialize the PoliciesContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The unique string that identifies the Policy resource
   */
  constructor(version: V1, payload: PoliciesPayload, sid: string);

  private _proxy: PoliciesContext;
  /**
   * fetch a PoliciesInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: PoliciesInstance) => any): Promise<PoliciesInstance>;
  friendlyName: string;
  requirements: any;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class PoliciesPage extends Page<V1, PoliciesPayload, PoliciesResource, PoliciesInstance> {
  /**
   * Initialize the PoliciesPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: PoliciesSolution);

  /**
   * Build an instance of PoliciesInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: PoliciesPayload): PoliciesInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { PoliciesContext, PoliciesEndUserType, PoliciesInstance, PoliciesList, PoliciesListInstance, PoliciesListInstanceEachOptions, PoliciesListInstanceOptions, PoliciesListInstancePageOptions, PoliciesPage, PoliciesPayload, PoliciesResource, PoliciesSolution }
