/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V2 = require('../V2');
import { SerializableClass } from '../../../interfaces';

type VerificationAttemptChannels = 'sms'|'call'|'email'|'whatsapp';

type VerificationAttemptConversionStatus = 'converted'|'unconverted';

/**
 * Initialize the VerificationAttemptList
 *
 * @param version - Version of the resource
 */
declare function VerificationAttemptList(version: V2): VerificationAttemptListInstance;

interface VerificationAttemptListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): VerificationAttemptContext;
  /**
   * Streams VerificationAttemptInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: VerificationAttemptInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams VerificationAttemptInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: VerificationAttemptListInstanceEachOptions, callback?: (item: VerificationAttemptInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a verification_attempt
   *
   * @param sid - Verification Attempt Sid.
   */
  get(sid: string): VerificationAttemptContext;
  /**
   * Retrieve a single target page of VerificationAttemptInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: VerificationAttemptPage) => any): Promise<VerificationAttemptPage>;
  /**
   * Retrieve a single target page of VerificationAttemptInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: VerificationAttemptPage) => any): Promise<VerificationAttemptPage>;
  /**
   * Lists VerificationAttemptInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: VerificationAttemptInstance[]) => any): Promise<VerificationAttemptInstance[]>;
  /**
   * Lists VerificationAttemptInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: VerificationAttemptListInstanceOptions, callback?: (error: Error | null, items: VerificationAttemptInstance[]) => any): Promise<VerificationAttemptInstance[]>;
  /**
   * Retrieve a single page of VerificationAttemptInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: VerificationAttemptPage) => any): Promise<VerificationAttemptPage>;
  /**
   * Retrieve a single page of VerificationAttemptInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: VerificationAttemptListInstancePageOptions, callback?: (error: Error | null, items: VerificationAttemptPage) => any): Promise<VerificationAttemptPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property channelData.to - Destination of a verification
 * @property dateCreatedAfter - Filter verification attempts after this date
 * @property dateCreatedBefore - Filter verification attempts befor this date
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface VerificationAttemptListInstanceEachOptions {
  callback?: (item: VerificationAttemptInstance, done: (err?: Error) => void) => void;
  channelData?: {
    to?: string;
  };
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property channelData.to - Destination of a verification
 * @property dateCreatedAfter - Filter verification attempts after this date
 * @property dateCreatedBefore - Filter verification attempts befor this date
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface VerificationAttemptListInstanceOptions {
  channelData?: {
    to?: string;
  };
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property channelData.to - Destination of a verification
 * @property dateCreatedAfter - Filter verification attempts after this date
 * @property dateCreatedBefore - Filter verification attempts befor this date
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface VerificationAttemptListInstancePageOptions {
  channelData?: {
    to?: string;
  };
  dateCreatedAfter?: Date;
  dateCreatedBefore?: Date;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface VerificationAttemptPayload extends VerificationAttemptResource, Page.TwilioResponsePayload {
}

interface VerificationAttemptResource {
  account_sid: string;
  channel: VerificationAttemptChannels;
  channel_data: object;
  conversion_status: VerificationAttemptConversionStatus;
  date_created: Date;
  date_updated: Date;
  service_sid: string;
  sid: string;
  url: string;
}

interface VerificationAttemptSolution {
}


declare class VerificationAttemptContext {
  /**
   * Initialize the VerificationAttemptContext
   *
   * @param version - Version of the resource
   * @param sid - Verification Attempt Sid.
   */
  constructor(version: V2, sid: string);

  /**
   * fetch a VerificationAttemptInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: VerificationAttemptInstance) => any): Promise<VerificationAttemptInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class VerificationAttemptInstance extends SerializableClass {
  /**
   * Initialize the VerificationAttemptContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - Verification Attempt Sid.
   */
  constructor(version: V2, payload: VerificationAttemptPayload, sid: string);

  private _proxy: VerificationAttemptContext;
  accountSid: string;
  channel: VerificationAttemptChannels;
  channelData: any;
  conversionStatus: VerificationAttemptConversionStatus;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a VerificationAttemptInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: VerificationAttemptInstance) => any): Promise<VerificationAttemptInstance>;
  serviceSid: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class VerificationAttemptPage extends Page<V2, VerificationAttemptPayload, VerificationAttemptResource, VerificationAttemptInstance> {
  /**
   * Initialize the VerificationAttemptPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: VerificationAttemptSolution);

  /**
   * Build an instance of VerificationAttemptInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: VerificationAttemptPayload): VerificationAttemptInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { VerificationAttemptChannels, VerificationAttemptContext, VerificationAttemptConversionStatus, VerificationAttemptInstance, VerificationAttemptList, VerificationAttemptListInstance, VerificationAttemptListInstanceEachOptions, VerificationAttemptListInstanceOptions, VerificationAttemptListInstancePageOptions, VerificationAttemptPage, VerificationAttemptPayload, VerificationAttemptResource, VerificationAttemptSolution }
