/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { ConferenceParticipantList } from './conference/conferenceParticipant';
import { ConferenceParticipantListInstance } from './conference/conferenceParticipant';
import { SerializableClass } from '../../../interfaces';

type ConferenceConferenceEndReason = 'last_participant_left'|'conference_ended_via_api'|'participant_with_end_conference_on_exit_left'|'last_participant_kicked'|'participant_with_end_conference_on_exit_kicked';

type ConferenceConferenceStatus = 'in_progress'|'not_started'|'completed'|'summary_timeout';

type ConferenceProcessingState = 'complete'|'in_progress'|'timeout';

type ConferenceRegion = 'us1'|'au1'|'br1'|'ie1'|'jp1'|'sg1'|'de1';

type ConferenceTag = 'invalid_requested_region'|'duplicate_identity'|'start_failure'|'region_configuration_issues'|'quality_warnings'|'participant_behavior_issues'|'high_packet_loss'|'high_jitter'|'high_latency'|'low_mos'|'detected_silence';

/**
 * Initialize the ConferenceList
 *
 * @param version - Version of the resource
 */
declare function ConferenceList(version: V1): ConferenceListInstance;

interface ConferenceListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ConferenceContext;
  /**
   * Streams ConferenceInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: ConferenceInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams ConferenceInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ConferenceListInstanceEachOptions, callback?: (item: ConferenceInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a conference
   *
   * @param conferenceSid - Conference SID.
   */
  get(conferenceSid: string): ConferenceContext;
  /**
   * Retrieve a single target page of ConferenceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: ConferencePage) => any): Promise<ConferencePage>;
  /**
   * Retrieve a single target page of ConferenceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ConferencePage) => any): Promise<ConferencePage>;
  /**
   * Lists ConferenceInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: ConferenceInstance[]) => any): Promise<ConferenceInstance[]>;
  /**
   * Lists ConferenceInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ConferenceListInstanceOptions, callback?: (error: Error | null, items: ConferenceInstance[]) => any): Promise<ConferenceInstance[]>;
  /**
   * Retrieve a single page of ConferenceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: ConferencePage) => any): Promise<ConferencePage>;
  /**
   * Retrieve a single page of ConferenceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ConferenceListInstancePageOptions, callback?: (error: Error | null, items: ConferencePage) => any): Promise<ConferencePage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property conferenceSid - The SID of the conference.
 * @property createdAfter - Conferences created after timestamp.
 * @property createdBefore - Conferences created before timestamp.
 * @property detectedIssues - Potential issues detected during the conference.
 * @property done - Function to be called upon completion of streaming
 * @property endReason - Conference end reason.
 * @property friendlyName - Custom label for the conference.
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property mixerRegion - Region where the conference was mixed.
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property status - Conference status.
 * @property subaccount - Account SID for the subaccount.
 * @property tags - Tags applied by Twilio for common issues.
 */
interface ConferenceListInstanceEachOptions {
  callback?: (item: ConferenceInstance, done: (err?: Error) => void) => void;
  conferenceSid?: string;
  createdAfter?: string;
  createdBefore?: string;
  detectedIssues?: string;
  done?: Function;
  endReason?: string;
  friendlyName?: string;
  limit?: number;
  mixerRegion?: string;
  pageSize?: number;
  status?: string;
  subaccount?: string;
  tags?: string;
}

/**
 * Options to pass to list
 *
 * @property conferenceSid - The SID of the conference.
 * @property createdAfter - Conferences created after timestamp.
 * @property createdBefore - Conferences created before timestamp.
 * @property detectedIssues - Potential issues detected during the conference.
 * @property endReason - Conference end reason.
 * @property friendlyName - Custom label for the conference.
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property mixerRegion - Region where the conference was mixed.
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property status - Conference status.
 * @property subaccount - Account SID for the subaccount.
 * @property tags - Tags applied by Twilio for common issues.
 */
interface ConferenceListInstanceOptions {
  conferenceSid?: string;
  createdAfter?: string;
  createdBefore?: string;
  detectedIssues?: string;
  endReason?: string;
  friendlyName?: string;
  limit?: number;
  mixerRegion?: string;
  pageSize?: number;
  status?: string;
  subaccount?: string;
  tags?: string;
}

/**
 * Options to pass to page
 *
 * @property conferenceSid - The SID of the conference.
 * @property createdAfter - Conferences created after timestamp.
 * @property createdBefore - Conferences created before timestamp.
 * @property detectedIssues - Potential issues detected during the conference.
 * @property endReason - Conference end reason.
 * @property friendlyName - Custom label for the conference.
 * @property mixerRegion - Region where the conference was mixed.
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property status - Conference status.
 * @property subaccount - Account SID for the subaccount.
 * @property tags - Tags applied by Twilio for common issues.
 */
interface ConferenceListInstancePageOptions {
  conferenceSid?: string;
  createdAfter?: string;
  createdBefore?: string;
  detectedIssues?: string;
  endReason?: string;
  friendlyName?: string;
  mixerRegion?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  status?: string;
  subaccount?: string;
  tags?: string;
}

interface ConferencePayload extends ConferenceResource, Page.TwilioResponsePayload {
}

interface ConferenceResource {
  account_sid: string;
  conference_sid: string;
  connect_duration_seconds: number;
  create_time: Date;
  detected_issues: object;
  duration_seconds: number;
  end_reason: ConferenceConferenceEndReason;
  end_time: Date;
  ended_by: string;
  friendly_name: string;
  links: string;
  max_concurrent_participants: number;
  max_participants: number;
  mixer_region: ConferenceRegion;
  mixer_region_requested: ConferenceRegion;
  processing_state: ConferenceProcessingState;
  recording_enabled: boolean;
  start_time: Date;
  status: ConferenceConferenceStatus;
  tag_info: object;
  tags: ConferenceTag[];
  unique_participants: number;
  url: string;
}

interface ConferenceSolution {
}


declare class ConferenceContext {
  /**
   * Initialize the ConferenceContext
   *
   * @param version - Version of the resource
   * @param conferenceSid - Conference SID.
   */
  constructor(version: V1, conferenceSid: string);

  conferenceParticipants: ConferenceParticipantListInstance;
  /**
   * fetch a ConferenceInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ConferenceInstance) => any): Promise<ConferenceInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class ConferenceInstance extends SerializableClass {
  /**
   * Initialize the ConferenceContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param conferenceSid - Conference SID.
   */
  constructor(version: V1, payload: ConferencePayload, conferenceSid: string);

  private _proxy: ConferenceContext;
  accountSid: string;
  /**
   * Access the conferenceParticipants
   */
  conferenceParticipants(): ConferenceParticipantListInstance;
  conferenceSid: string;
  connectDurationSeconds: number;
  createTime: Date;
  detectedIssues: any;
  durationSeconds: number;
  endReason: ConferenceConferenceEndReason;
  endTime: Date;
  endedBy: string;
  /**
   * fetch a ConferenceInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ConferenceInstance) => any): Promise<ConferenceInstance>;
  friendlyName: string;
  links: string;
  maxConcurrentParticipants: number;
  maxParticipants: number;
  mixerRegion: ConferenceRegion;
  mixerRegionRequested: ConferenceRegion;
  processingState: ConferenceProcessingState;
  recordingEnabled: boolean;
  startTime: Date;
  status: ConferenceConferenceStatus;
  tagInfo: any;
  tags: ConferenceTag[];
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  uniqueParticipants: number;
  url: string;
}


declare class ConferencePage extends Page<V1, ConferencePayload, ConferenceResource, ConferenceInstance> {
  /**
   * Initialize the ConferencePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ConferenceSolution);

  /**
   * Build an instance of ConferenceInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ConferencePayload): ConferenceInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ConferenceConferenceEndReason, ConferenceConferenceStatus, ConferenceContext, ConferenceInstance, ConferenceList, ConferenceListInstance, ConferenceListInstanceEachOptions, ConferenceListInstanceOptions, ConferenceListInstancePageOptions, ConferencePage, ConferencePayload, ConferenceProcessingState, ConferenceRegion, ConferenceResource, ConferenceSolution, ConferenceTag }
