'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var PlaybackGrantList = require(
    './playerStreamer/playbackGrant').PlaybackGrantList;
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var PlayerStreamerList;
var PlayerStreamerPage;
var PlayerStreamerInstance;
var PlayerStreamerContext;

/* jshint ignore:start */
/**
 * Initialize the PlayerStreamerList
 *
 * @constructor Twilio.Media.V1.PlayerStreamerList
 *
 * @param {Twilio.Media.V1} version - Version of the resource
 */
/* jshint ignore:end */
PlayerStreamerList = function PlayerStreamerList(version) {
  /* jshint ignore:start */
  /**
   * @function playerStreamer
   * @memberof Twilio.Media.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Media.V1.PlayerStreamerContext}
   */
  /* jshint ignore:end */
  function PlayerStreamerListInstance(sid) {
    return PlayerStreamerListInstance.get(sid);
  }

  PlayerStreamerListInstance._version = version;
  // Path Solution
  PlayerStreamerListInstance._solution = {};
  PlayerStreamerListInstance._uri = `/PlayerStreamers`;
  /* jshint ignore:start */
  /**
   * create a PlayerStreamerInstance
   *
   * @function create
   * @memberof Twilio.Media.V1.PlayerStreamerList#
   *
   * @param {object} [opts] - Options for request
   * @param {boolean} [opts.video] -
   *          Whether the PlayerStreamer is configured to stream video
   * @param {string} [opts.statusCallback] -
   *          The URL to which Twilio will send PlayerStreamer event updates
   * @param {string} [opts.statusCallbackMethod] -
   *          The HTTP method Twilio should use to call the `status_callback` URL
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed PlayerStreamerInstance
   */
  /* jshint ignore:end */
  PlayerStreamerListInstance.create = function create(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Video': serialize.bool(_.get(opts, 'video')),
      'StatusCallback': _.get(opts, 'statusCallback'),
      'StatusCallbackMethod': _.get(opts, 'statusCallbackMethod')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new PlayerStreamerInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams PlayerStreamerInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Media.V1.PlayerStreamerList#
   *
   * @param {object} [opts] - Options for request
   * @param {player_streamer.order} [opts.order] - The sort order of the list
   * @param {player_streamer.status} [opts.status] - Status to filter by
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  PlayerStreamerListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists PlayerStreamerInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Media.V1.PlayerStreamerList#
   *
   * @param {object} [opts] - Options for request
   * @param {player_streamer.order} [opts.order] - The sort order of the list
   * @param {player_streamer.status} [opts.status] - Status to filter by
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  PlayerStreamerListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of PlayerStreamerInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Media.V1.PlayerStreamerList#
   *
   * @param {object} [opts] - Options for request
   * @param {player_streamer.order} [opts.order] - The sort order of the list
   * @param {player_streamer.status} [opts.status] - Status to filter by
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  PlayerStreamerListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Order': _.get(opts, 'order'),
      'Status': _.get(opts, 'status'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new PlayerStreamerPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of PlayerStreamerInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Media.V1.PlayerStreamerList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  PlayerStreamerListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new PlayerStreamerPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a player_streamer
   *
   * @function get
   * @memberof Twilio.Media.V1.PlayerStreamerList#
   *
   * @param {string} sid - The SID that identifies the resource to fetch
   *
   * @returns {Twilio.Media.V1.PlayerStreamerContext}
   */
  /* jshint ignore:end */
  PlayerStreamerListInstance.get = function get(sid) {
    return new PlayerStreamerContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Media.V1.PlayerStreamerList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  PlayerStreamerListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  PlayerStreamerListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return PlayerStreamerListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the PlayerStreamerPage
 *
 * @constructor Twilio.Media.V1.PlayerStreamerPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {PlayerStreamerSolution} solution - Path solution
 *
 * @returns PlayerStreamerPage
 */
/* jshint ignore:end */
PlayerStreamerPage = function PlayerStreamerPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(PlayerStreamerPage.prototype, Page.prototype);
PlayerStreamerPage.prototype.constructor = PlayerStreamerPage;

/* jshint ignore:start */
/**
 * Build an instance of PlayerStreamerInstance
 *
 * @function getInstance
 * @memberof Twilio.Media.V1.PlayerStreamerPage#
 *
 * @param {PlayerStreamerPayload} payload - Payload response from the API
 *
 * @returns PlayerStreamerInstance
 */
/* jshint ignore:end */
PlayerStreamerPage.prototype.getInstance = function getInstance(payload) {
  return new PlayerStreamerInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Media.V1.PlayerStreamerPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
PlayerStreamerPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

PlayerStreamerPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the PlayerStreamerContext
 *
 * @constructor Twilio.Media.V1.PlayerStreamerInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {boolean} video -
 *          Whether the PlayerStreamer is configured to stream video
 * @property {string} links - The URLs of related resources
 * @property {string} sid - The unique string that identifies the resource
 * @property {player_streamer.status} status - The status of the PlayerStreamer
 * @property {string} url - The absolute URL of the resource
 * @property {string} statusCallback -
 *          The URL to which Twilio will send PlayerStreamer event updates
 * @property {string} statusCallbackMethod -
 *          The HTTP method Twilio should use to call the `status_callback` URL
 * @property {player_streamer.ended_reason} endedReason -
 *          The reason why a PlayerStreamer ended
 *
 * @param {V1} version - Version of the resource
 * @param {PlayerStreamerPayload} payload - The instance payload
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
PlayerStreamerInstance = function PlayerStreamerInstance(version, payload, sid)
                                                          {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.video = payload.video; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.statusCallback = payload.status_callback; // jshint ignore:line
  this.statusCallbackMethod = payload.status_callback_method; // jshint ignore:line
  this.endedReason = payload.ended_reason; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(PlayerStreamerInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new PlayerStreamerContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a PlayerStreamerInstance
 *
 * @function fetch
 * @memberof Twilio.Media.V1.PlayerStreamerInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PlayerStreamerInstance
 */
/* jshint ignore:end */
PlayerStreamerInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a PlayerStreamerInstance
 *
 * @function update
 * @memberof Twilio.Media.V1.PlayerStreamerInstance#
 *
 * @param {object} opts - Options for request
 * @param {player_streamer.update_status} opts.status -
 *          The status the PlayerStreamer should be transitioned to
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PlayerStreamerInstance
 */
/* jshint ignore:end */
PlayerStreamerInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Access the playbackGrant
 *
 * @function playbackGrant
 * @memberof Twilio.Media.V1.PlayerStreamerInstance#
 *
 * @returns {Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantList}
 */
/* jshint ignore:end */
PlayerStreamerInstance.prototype.playbackGrant = function playbackGrant() {
  return this._proxy.playbackGrant;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Media.V1.PlayerStreamerInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
PlayerStreamerInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

PlayerStreamerInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the PlayerStreamerContext
 *
 * @constructor Twilio.Media.V1.PlayerStreamerContext
 *
 * @property {Twilio.Media.V1.PlayerStreamerContext.PlaybackGrantList} playbackGrant -
 *          playbackGrant resource
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
PlayerStreamerContext = function PlayerStreamerContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/PlayerStreamers/${sid}`;

  // Dependents
  this._playbackGrant = undefined;
};

/* jshint ignore:start */
/**
 * fetch a PlayerStreamerInstance
 *
 * @function fetch
 * @memberof Twilio.Media.V1.PlayerStreamerContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PlayerStreamerInstance
 */
/* jshint ignore:end */
PlayerStreamerContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new PlayerStreamerInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a PlayerStreamerInstance
 *
 * @function update
 * @memberof Twilio.Media.V1.PlayerStreamerContext#
 *
 * @param {object} opts - Options for request
 * @param {player_streamer.update_status} opts.status -
 *          The status the PlayerStreamer should be transitioned to
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed PlayerStreamerInstance
 */
/* jshint ignore:end */
PlayerStreamerContext.prototype.update = function update(opts, callback) {
  if (_.isUndefined(opts)) {
    throw new Error('Required parameter "opts" missing.');
  }
  if (_.isUndefined(opts['status'])) {
    throw new Error('Required parameter "opts[\'status\']" missing.');
  }

  var deferred = Q.defer();
  var data = values.of({'Status': _.get(opts, 'status')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new PlayerStreamerInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(PlayerStreamerContext.prototype,
  'playbackGrant', {
    get: function() {
      if (!this._playbackGrant) {
        this._playbackGrant = new PlaybackGrantList(this._version, this._solution.sid);
      }
      return this._playbackGrant;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Media.V1.PlayerStreamerContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
PlayerStreamerContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

PlayerStreamerContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  PlayerStreamerList: PlayerStreamerList,
  PlayerStreamerPage: PlayerStreamerPage,
  PlayerStreamerInstance: PlayerStreamerInstance,
  PlayerStreamerContext: PlayerStreamerContext
};
