/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the AuthTokenPromotionList
 *
 * @param version - Version of the resource
 */
declare function AuthTokenPromotionList(version: V1): AuthTokenPromotionListInstance;

interface AuthTokenPromotionListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): AuthTokenPromotionContext;
  /**
   * Constructs a auth_token_promotion
   */
  get(): AuthTokenPromotionContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface AuthTokenPromotionPayload extends AuthTokenPromotionResource, Page.TwilioResponsePayload {
}

interface AuthTokenPromotionResource {
  account_sid: string;
  auth_token: string;
  date_created: Date;
  date_updated: Date;
  url: string;
}

interface AuthTokenPromotionSolution {
}


declare class AuthTokenPromotionContext {
  /**
   * Initialize the AuthTokenPromotionContext
   *
   * @param version - Version of the resource
   */
  constructor(version: V1);

  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AuthTokenPromotionInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: AuthTokenPromotionInstance) => any): Promise<AuthTokenPromotionInstance>;
}


declare class AuthTokenPromotionInstance extends SerializableClass {
  /**
   * Initialize the AuthTokenPromotionContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: AuthTokenPromotionPayload);

  private _proxy: AuthTokenPromotionContext;
  accountSid: string;
  authToken: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AuthTokenPromotionInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: AuthTokenPromotionInstance) => any): Promise<AuthTokenPromotionInstance>;
  url: string;
}


declare class AuthTokenPromotionPage extends Page<V1, AuthTokenPromotionPayload, AuthTokenPromotionResource, AuthTokenPromotionInstance> {
  /**
   * Initialize the AuthTokenPromotionPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: AuthTokenPromotionSolution);

  /**
   * Build an instance of AuthTokenPromotionInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: AuthTokenPromotionPayload): AuthTokenPromotionInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { AuthTokenPromotionContext, AuthTokenPromotionInstance, AuthTokenPromotionList, AuthTokenPromotionListInstance, AuthTokenPromotionPage, AuthTokenPromotionPayload, AuthTokenPromotionResource, AuthTokenPromotionSolution }
