'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var FaxMediaList = require('./fax/faxMedia').FaxMediaList;
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var FaxList;
var FaxPage;
var FaxInstance;
var FaxContext;

/* jshint ignore:start */
/**
 * Initialize the FaxList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Fax.V1.FaxList
 *
 * @param {Twilio.Fax.V1} version - Version of the resource
 */
/* jshint ignore:end */
FaxList = function FaxList(version) {
  /* jshint ignore:start */
  /**
   * @function faxes
   * @memberof Twilio.Fax.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Fax.V1.FaxContext}
   */
  /* jshint ignore:end */
  function FaxListInstance(sid) {
    return FaxListInstance.get(sid);
  }

  FaxListInstance._version = version;
  // Path Solution
  FaxListInstance._solution = {};
  FaxListInstance._uri = `/Faxes`;
  /* jshint ignore:start */
  /**
   * Streams FaxInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Fax.V1.FaxList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.from] -
   *          Retrieve only those faxes sent from this phone number
   * @param {string} [opts.to] - Retrieve only those faxes sent to this phone number
   * @param {Date} [opts.dateCreatedOnOrBefore] -
   *          Retrieve only faxes created on or before this date
   * @param {Date} [opts.dateCreatedAfter] -
   *          Retrieve only faxes created after this date
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  FaxListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        } else {
          onComplete();
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists FaxInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Fax.V1.FaxList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.from] -
   *          Retrieve only those faxes sent from this phone number
   * @param {string} [opts.to] - Retrieve only those faxes sent to this phone number
   * @param {Date} [opts.dateCreatedOnOrBefore] -
   *          Retrieve only faxes created on or before this date
   * @param {Date} [opts.dateCreatedAfter] -
   *          Retrieve only faxes created after this date
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FaxListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of FaxInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Fax.V1.FaxList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.from] -
   *          Retrieve only those faxes sent from this phone number
   * @param {string} [opts.to] - Retrieve only those faxes sent to this phone number
   * @param {Date} [opts.dateCreatedOnOrBefore] -
   *          Retrieve only faxes created on or before this date
   * @param {Date} [opts.dateCreatedAfter] -
   *          Retrieve only faxes created after this date
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FaxListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'From': _.get(opts, 'from'),
      'To': _.get(opts, 'to'),
      'DateCreatedOnOrBefore': serialize.iso8601DateTime(_.get(opts, 'dateCreatedOnOrBefore')),
      'DateCreatedAfter': serialize.iso8601DateTime(_.get(opts, 'dateCreatedAfter')),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new FaxPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of FaxInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Fax.V1.FaxList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  FaxListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new FaxPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a fax
   *
   * @function get
   * @memberof Twilio.Fax.V1.FaxList#
   *
   * @param {string} sid - The unique string that identifies the resource
   *
   * @returns {Twilio.Fax.V1.FaxContext}
   */
  /* jshint ignore:end */
  FaxListInstance.get = function get(sid) {
    return new FaxContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Fax.V1.FaxList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  FaxListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  FaxListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return FaxListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the FaxPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Fax.V1.FaxPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {FaxSolution} solution - Path solution
 *
 * @returns FaxPage
 */
/* jshint ignore:end */
FaxPage = function FaxPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(FaxPage.prototype, Page.prototype);
FaxPage.prototype.constructor = FaxPage;

/* jshint ignore:start */
/**
 * Build an instance of FaxInstance
 *
 * @function getInstance
 * @memberof Twilio.Fax.V1.FaxPage#
 *
 * @param {FaxPayload} payload - Payload response from the API
 *
 * @returns FaxInstance
 */
/* jshint ignore:end */
FaxPage.prototype.getInstance = function getInstance(payload) {
  return new FaxInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Fax.V1.FaxPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
FaxPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FaxPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FaxContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Fax.V1.FaxInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} from - The number the fax was sent from
 * @property {string} to - The phone number that received the fax
 * @property {fax.quality} quality - The quality of the fax
 * @property {string} mediaSid -
 *          The SID of the FaxMedia resource that is associated with the Fax
 * @property {string} mediaUrl -
 *          The Twilio-hosted URL that can be used to download fax media
 * @property {number} numPages - The number of pages contained in the fax document
 * @property {number} duration - The time it took to transmit the fax
 * @property {fax.status} status - The status of the fax
 * @property {fax.direction} direction - The direction of the fax
 * @property {string} apiVersion - The API version used to transmit the fax
 * @property {number} price - The fax transmission price
 * @property {string} priceUnit - The ISO 4217 currency used for billing
 * @property {Date} dateCreated -
 *          The ISO 8601 formatted date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 formatted date and time in GMT when the resource was last updated
 * @property {string} links - The URLs of the fax's related resources
 * @property {string} url - The absolute URL of the fax resource
 *
 * @param {V1} version - Version of the resource
 * @param {FaxPayload} payload - The instance payload
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
FaxInstance = function FaxInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.from = payload.from; // jshint ignore:line
  this.to = payload.to; // jshint ignore:line
  this.quality = payload.quality; // jshint ignore:line
  this.mediaSid = payload.media_sid; // jshint ignore:line
  this.mediaUrl = payload.media_url; // jshint ignore:line
  this.numPages = deserialize.integer(payload.num_pages); // jshint ignore:line
  this.duration = deserialize.integer(payload.duration); // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.direction = payload.direction; // jshint ignore:line
  this.apiVersion = payload.api_version; // jshint ignore:line
  this.price = deserialize.decimal(payload.price); // jshint ignore:line
  this.priceUnit = payload.price_unit; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.links = payload.links; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(FaxInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new FaxContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a FaxInstance
 *
 * @function fetch
 * @memberof Twilio.Fax.V1.FaxInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FaxInstance
 */
/* jshint ignore:end */
FaxInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a FaxInstance
 *
 * @function remove
 * @memberof Twilio.Fax.V1.FaxInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FaxInstance
 */
/* jshint ignore:end */
FaxInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Access the media
 *
 * @function media
 * @memberof Twilio.Fax.V1.FaxInstance#
 *
 * @returns {Twilio.Fax.V1.FaxContext.FaxMediaList}
 */
/* jshint ignore:end */
FaxInstance.prototype.media = function media() {
  return this._proxy.media;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Fax.V1.FaxInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
FaxInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

FaxInstance.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the FaxContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Fax.V1.FaxContext
 *
 * @property {Twilio.Fax.V1.FaxContext.FaxMediaList} media - media resource
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
FaxContext = function FaxContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Faxes/${sid}`;

  // Dependents
  this._media = undefined;
};

/* jshint ignore:start */
/**
 * fetch a FaxInstance
 *
 * @function fetch
 * @memberof Twilio.Fax.V1.FaxContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FaxInstance
 */
/* jshint ignore:end */
FaxContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new FaxInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a FaxInstance
 *
 * @function remove
 * @memberof Twilio.Fax.V1.FaxContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed FaxInstance
 */
/* jshint ignore:end */
FaxContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(FaxContext.prototype,
  'media', {
    get: function() {
      if (!this._media) {
        this._media = new FaxMediaList(this._version, this._solution.sid);
      }
      return this._media;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Fax.V1.FaxContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
FaxContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

FaxContext.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  FaxList: FaxList,
  FaxPage: FaxPage,
  FaxInstance: FaxInstance,
  FaxContext: FaxContext
};
