/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V2 = require('../../../V2');
import { SerializableClass } from '../../../../../interfaces';

type BundleCopyEndUserType = 'individual'|'business';

type BundleCopyStatus = 'draft'|'pending-review'|'in-review'|'twilio-rejected'|'twilio-approved'|'provisionally-approved';

/**
 * Initialize the BundleCopyList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 * @param bundleSid - The unique string that identifies the resource.
 */
declare function BundleCopyList(version: V2, bundleSid: string): BundleCopyListInstance;

interface BundleCopyListInstance {
  /**
   * create a BundleCopyInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: BundleCopyInstance) => any): Promise<BundleCopyInstance>;
  /**
   * create a BundleCopyInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: BundleCopyListInstanceCreateOptions, callback?: (error: Error | null, item: BundleCopyInstance) => any): Promise<BundleCopyInstance>;
  /**
   * Streams BundleCopyInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: BundleCopyInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams BundleCopyInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: BundleCopyListInstanceEachOptions, callback?: (item: BundleCopyInstance, done: (err?: Error) => void) => void): void;
  /**
   * Retrieve a single target page of BundleCopyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: BundleCopyPage) => any): Promise<BundleCopyPage>;
  /**
   * Retrieve a single target page of BundleCopyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: BundleCopyPage) => any): Promise<BundleCopyPage>;
  /**
   * Lists BundleCopyInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: BundleCopyInstance[]) => any): Promise<BundleCopyInstance[]>;
  /**
   * Lists BundleCopyInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: BundleCopyListInstanceOptions, callback?: (error: Error | null, items: BundleCopyInstance[]) => any): Promise<BundleCopyInstance[]>;
  /**
   * Retrieve a single page of BundleCopyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: BundleCopyPage) => any): Promise<BundleCopyPage>;
  /**
   * Retrieve a single page of BundleCopyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: BundleCopyListInstancePageOptions, callback?: (error: Error | null, items: BundleCopyPage) => any): Promise<BundleCopyPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property friendlyName - The string that you assigned to describe the copied bundle
 */
interface BundleCopyListInstanceCreateOptions {
  friendlyName?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface BundleCopyListInstanceEachOptions {
  callback?: (item: BundleCopyInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface BundleCopyListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface BundleCopyListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface BundleCopyPayload extends BundleCopyResource, Page.TwilioResponsePayload {
}

interface BundleCopyResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  email: string;
  friendly_name: string;
  regulation_sid: string;
  sid: string;
  status: BundleCopyStatus;
  status_callback: string;
  valid_until: Date;
}

interface BundleCopySolution {
  bundleSid?: string;
}


declare class BundleCopyInstance extends SerializableClass {
  /**
   * Initialize the BundleCopyContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param bundleSid - The unique string that identifies the resource.
   */
  constructor(version: V2, payload: BundleCopyPayload, bundleSid: string);

  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  email: string;
  friendlyName: string;
  regulationSid: string;
  sid: string;
  status: BundleCopyStatus;
  statusCallback: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  validUntil: Date;
}


declare class BundleCopyPage extends Page<V2, BundleCopyPayload, BundleCopyResource, BundleCopyInstance> {
  /**
   * Initialize the BundleCopyPage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: BundleCopySolution);

  /**
   * Build an instance of BundleCopyInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: BundleCopyPayload): BundleCopyInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { BundleCopyEndUserType, BundleCopyInstance, BundleCopyList, BundleCopyListInstance, BundleCopyListInstanceCreateOptions, BundleCopyListInstanceEachOptions, BundleCopyListInstanceOptions, BundleCopyListInstancePageOptions, BundleCopyPage, BundleCopyPayload, BundleCopyResource, BundleCopySolution, BundleCopyStatus }
