'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var TaskQueueCumulativeStatisticsList;
var TaskQueueCumulativeStatisticsPage;
var TaskQueueCumulativeStatisticsInstance;
var TaskQueueCumulativeStatisticsContext;

/* jshint ignore:start */
/**
 * Initialize the TaskQueueCumulativeStatisticsList
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsList
 *
 * @param {Twilio.Taskrouter.V1} version - Version of the resource
 * @param {string} workspaceSid -
 *          The SID of the Workspace that contains the TaskQueue
 * @param {string} taskQueueSid -
 *          The SID of the TaskQueue from which these statistics were calculated
 */
/* jshint ignore:end */
TaskQueueCumulativeStatisticsList = function
    TaskQueueCumulativeStatisticsList(version, workspaceSid, taskQueueSid) {
  /* jshint ignore:start */
  /**
   * @function cumulativeStatistics
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsContext}
   */
  /* jshint ignore:end */
  function TaskQueueCumulativeStatisticsListInstance(sid) {
    return TaskQueueCumulativeStatisticsListInstance.get(sid);
  }

  TaskQueueCumulativeStatisticsListInstance._version = version;
  // Path Solution
  TaskQueueCumulativeStatisticsListInstance._solution = {
    workspaceSid: workspaceSid,
    taskQueueSid: taskQueueSid
  };
  /* jshint ignore:start */
  /**
   * Constructs a task_queue_cumulative_statistics
   *
   * @function get
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsList#
   *
   * @returns {Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsContext}
   */
  /* jshint ignore:end */
  TaskQueueCumulativeStatisticsListInstance.get = function get() {
    return new TaskQueueCumulativeStatisticsContext(
      this._version,
      this._solution.workspaceSid,
      this._solution.taskQueueSid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  TaskQueueCumulativeStatisticsListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  TaskQueueCumulativeStatisticsListInstance[util.inspect.custom] = function
      inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return TaskQueueCumulativeStatisticsListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the TaskQueueCumulativeStatisticsPage
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {TaskQueueCumulativeStatisticsSolution} solution - Path solution
 *
 * @returns TaskQueueCumulativeStatisticsPage
 */
/* jshint ignore:end */
TaskQueueCumulativeStatisticsPage = function
    TaskQueueCumulativeStatisticsPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(TaskQueueCumulativeStatisticsPage.prototype, Page.prototype);
TaskQueueCumulativeStatisticsPage.prototype.constructor = TaskQueueCumulativeStatisticsPage;

/* jshint ignore:start */
/**
 * Build an instance of TaskQueueCumulativeStatisticsInstance
 *
 * @function getInstance
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsPage#
 *
 * @param {TaskQueueCumulativeStatisticsPayload} payload -
 *          Payload response from the API
 *
 * @returns TaskQueueCumulativeStatisticsInstance
 */
/* jshint ignore:end */
TaskQueueCumulativeStatisticsPage.prototype.getInstance = function
    getInstance(payload) {
  return new TaskQueueCumulativeStatisticsInstance(
    this._version,
    payload,
    this._solution.workspaceSid,
    this._solution.taskQueueSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
TaskQueueCumulativeStatisticsPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

TaskQueueCumulativeStatisticsPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the TaskQueueCumulativeStatisticsContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {number} avgTaskAcceptanceTime -
 *          The average time in seconds between Task creation and acceptance
 * @property {Date} startTime -
 *          The beginning of the interval during which these statistics were calculated
 * @property {Date} endTime -
 *          The end of the interval during which these statistics were calculated
 * @property {number} reservationsCreated -
 *          The total number of Reservations created for Tasks in the TaskQueue
 * @property {number} reservationsAccepted -
 *          The total number of Reservations accepted for Tasks in the TaskQueue
 * @property {number} reservationsRejected -
 *          The total number of Reservations rejected for Tasks in the TaskQueue
 * @property {number} reservationsTimedOut -
 *          The total number of Reservations that timed out for Tasks in the TaskQueue
 * @property {number} reservationsCanceled -
 *          The total number of Reservations canceled for Tasks in the TaskQueue
 * @property {number} reservationsRescinded -
 *          The total number of Reservations rescinded
 * @property {object} splitByWaitTime -
 *          A list of objects that describe the Tasks canceled and reservations accepted above and below the specified thresholds
 * @property {string} taskQueueSid -
 *          The SID of the TaskQueue from which these statistics were calculated
 * @property {object} waitDurationUntilAccepted -
 *          The wait duration statistics for Tasks accepted while in the TaskQueue
 * @property {object} waitDurationUntilCanceled -
 *          The wait duration statistics for Tasks canceled while in the TaskQueue
 * @property {object} waitDurationInQueueUntilAccepted -
 *          The relative wait duration statistics for Tasks accepted while in the TaskQueue
 * @property {number} tasksCanceled -
 *          The total number of Tasks canceled in the TaskQueue
 * @property {number} tasksCompleted -
 *          The total number of Tasks completed in the TaskQueue
 * @property {number} tasksDeleted -
 *          The total number of Tasks deleted in the TaskQueue
 * @property {number} tasksEntered -
 *          The total number of Tasks entered into the TaskQueue
 * @property {number} tasksMoved -
 *          The total number of Tasks that were moved from one queue to another
 * @property {string} workspaceSid -
 *          The SID of the Workspace that contains the TaskQueue
 * @property {string} url - The absolute URL of the TaskQueue statistics resource
 *
 * @param {V1} version - Version of the resource
 * @param {TaskQueueCumulativeStatisticsPayload} payload - The instance payload
 * @param {sid} workspaceSid - The SID of the Workspace that contains the TaskQueue
 * @param {sid} taskQueueSid -
 *          The SID of the TaskQueue from which these statistics were calculated
 */
/* jshint ignore:end */
TaskQueueCumulativeStatisticsInstance = function
    TaskQueueCumulativeStatisticsInstance(version, payload, workspaceSid,
    taskQueueSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.avgTaskAcceptanceTime = deserialize.integer(payload.avg_task_acceptance_time); // jshint ignore:line
  this.startTime = deserialize.iso8601DateTime(payload.start_time); // jshint ignore:line
  this.endTime = deserialize.iso8601DateTime(payload.end_time); // jshint ignore:line
  this.reservationsCreated = deserialize.integer(payload.reservations_created); // jshint ignore:line
  this.reservationsAccepted = deserialize.integer(payload.reservations_accepted); // jshint ignore:line
  this.reservationsRejected = deserialize.integer(payload.reservations_rejected); // jshint ignore:line
  this.reservationsTimedOut = deserialize.integer(payload.reservations_timed_out); // jshint ignore:line
  this.reservationsCanceled = deserialize.integer(payload.reservations_canceled); // jshint ignore:line
  this.reservationsRescinded = deserialize.integer(payload.reservations_rescinded); // jshint ignore:line
  this.splitByWaitTime = payload.split_by_wait_time; // jshint ignore:line
  this.taskQueueSid = payload.task_queue_sid; // jshint ignore:line
  this.waitDurationUntilAccepted = payload.wait_duration_until_accepted; // jshint ignore:line
  this.waitDurationUntilCanceled = payload.wait_duration_until_canceled; // jshint ignore:line
  this.waitDurationInQueueUntilAccepted = payload.wait_duration_in_queue_until_accepted; // jshint ignore:line
  this.tasksCanceled = deserialize.integer(payload.tasks_canceled); // jshint ignore:line
  this.tasksCompleted = deserialize.integer(payload.tasks_completed); // jshint ignore:line
  this.tasksDeleted = deserialize.integer(payload.tasks_deleted); // jshint ignore:line
  this.tasksEntered = deserialize.integer(payload.tasks_entered); // jshint ignore:line
  this.tasksMoved = deserialize.integer(payload.tasks_moved); // jshint ignore:line
  this.workspaceSid = payload.workspace_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {workspaceSid: workspaceSid, taskQueueSid: taskQueueSid, };
};

Object.defineProperty(TaskQueueCumulativeStatisticsInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new TaskQueueCumulativeStatisticsContext(
          this._version,
          this._solution.workspaceSid,
          this._solution.taskQueueSid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a TaskQueueCumulativeStatisticsInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {Date} [opts.endDate] -
 *          Only calculate statistics from on or before this date
 * @param {number} [opts.minutes] -
 *          Only calculate statistics since this many minutes in the past
 * @param {Date} [opts.startDate] -
 *          Only calculate statistics from on or after this date
 * @param {string} [opts.taskChannel] -
 *          Only calculate cumulative statistics on this TaskChannel
 * @param {string} [opts.splitByWaitTime] -
 *          A comma separated list of values that describes the thresholds, in seconds, to calculate statistics on
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TaskQueueCumulativeStatisticsInstance
 */
/* jshint ignore:end */
TaskQueueCumulativeStatisticsInstance.prototype.fetch = function fetch(opts,
    callback) {
  return this._proxy.fetch(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
TaskQueueCumulativeStatisticsInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

TaskQueueCumulativeStatisticsInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the TaskQueueCumulativeStatisticsContext
 *
 * @constructor Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} workspaceSid - The SID of the Workspace with the TaskQueue to fetch
 * @param {sid} taskQueueSid -
 *          The SID of the TaskQueue for which to fetch statistics
 */
/* jshint ignore:end */
TaskQueueCumulativeStatisticsContext = function
    TaskQueueCumulativeStatisticsContext(version, workspaceSid, taskQueueSid) {
  this._version = version;

  // Path Solution
  this._solution = {workspaceSid: workspaceSid, taskQueueSid: taskQueueSid, };
  this._uri = `/Workspaces/${workspaceSid}/TaskQueues/${taskQueueSid}/CumulativeStatistics`;
};

/* jshint ignore:start */
/**
 * fetch a TaskQueueCumulativeStatisticsInstance
 *
 * @function fetch
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsContext#
 *
 * @param {object} [opts] - Options for request
 * @param {Date} [opts.endDate] -
 *          Only calculate statistics from on or before this date
 * @param {number} [opts.minutes] -
 *          Only calculate statistics since this many minutes in the past
 * @param {Date} [opts.startDate] -
 *          Only calculate statistics from on or after this date
 * @param {string} [opts.taskChannel] -
 *          Only calculate cumulative statistics on this TaskChannel
 * @param {string} [opts.splitByWaitTime] -
 *          A comma separated list of values that describes the thresholds, in seconds, to calculate statistics on
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TaskQueueCumulativeStatisticsInstance
 */
/* jshint ignore:end */
TaskQueueCumulativeStatisticsContext.prototype.fetch = function fetch(opts,
    callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'EndDate': serialize.iso8601DateTime(_.get(opts, 'endDate')),
    'Minutes': _.get(opts, 'minutes'),
    'StartDate': serialize.iso8601DateTime(_.get(opts, 'startDate')),
    'TaskChannel': _.get(opts, 'taskChannel'),
    'SplitByWaitTime': _.get(opts, 'splitByWaitTime')
  });

  var promise = this._version.fetch({uri: this._uri, method: 'GET', params: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new TaskQueueCumulativeStatisticsInstance(
      this._version,
      payload,
      this._solution.workspaceSid,
      this._solution.taskQueueSid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Taskrouter.V1.WorkspaceContext.TaskQueueContext.TaskQueueCumulativeStatisticsContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
TaskQueueCumulativeStatisticsContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

TaskQueueCumulativeStatisticsContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  TaskQueueCumulativeStatisticsList: TaskQueueCumulativeStatisticsList,
  TaskQueueCumulativeStatisticsPage: TaskQueueCumulativeStatisticsPage,
  TaskQueueCumulativeStatisticsInstance: TaskQueueCumulativeStatisticsInstance,
  TaskQueueCumulativeStatisticsContext: TaskQueueCumulativeStatisticsContext
};
