/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

type CustomerProfilesEvaluationsStatus = 'compliant'|'noncompliant';

/**
 * Initialize the CustomerProfilesEvaluationsList
 *
 * @param version - Version of the resource
 * @param customerProfileSid - The unique string that identifies the resource
 */
declare function CustomerProfilesEvaluationsList(version: V1, customerProfileSid: string): CustomerProfilesEvaluationsListInstance;

interface CustomerProfilesEvaluationsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): CustomerProfilesEvaluationsContext;
  /**
   * create a CustomerProfilesEvaluationsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: CustomerProfilesEvaluationsListInstanceCreateOptions, callback?: (error: Error | null, item: CustomerProfilesEvaluationsInstance) => any): Promise<CustomerProfilesEvaluationsInstance>;
  /**
   * Streams CustomerProfilesEvaluationsInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: CustomerProfilesEvaluationsInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams CustomerProfilesEvaluationsInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: CustomerProfilesEvaluationsListInstanceEachOptions, callback?: (item: CustomerProfilesEvaluationsInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a customer_profiles_evaluations
   *
   * @param sid - The unique string that identifies the Evaluation resource
   */
  get(sid: string): CustomerProfilesEvaluationsContext;
  /**
   * Retrieve a single target page of CustomerProfilesEvaluationsInstance records
   * from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: CustomerProfilesEvaluationsPage) => any): Promise<CustomerProfilesEvaluationsPage>;
  /**
   * Retrieve a single target page of CustomerProfilesEvaluationsInstance records
   * from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: CustomerProfilesEvaluationsPage) => any): Promise<CustomerProfilesEvaluationsPage>;
  /**
   * Lists CustomerProfilesEvaluationsInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: CustomerProfilesEvaluationsInstance[]) => any): Promise<CustomerProfilesEvaluationsInstance[]>;
  /**
   * Lists CustomerProfilesEvaluationsInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: CustomerProfilesEvaluationsListInstanceOptions, callback?: (error: Error | null, items: CustomerProfilesEvaluationsInstance[]) => any): Promise<CustomerProfilesEvaluationsInstance[]>;
  /**
   * Retrieve a single page of CustomerProfilesEvaluationsInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: CustomerProfilesEvaluationsPage) => any): Promise<CustomerProfilesEvaluationsPage>;
  /**
   * Retrieve a single page of CustomerProfilesEvaluationsInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: CustomerProfilesEvaluationsListInstancePageOptions, callback?: (error: Error | null, items: CustomerProfilesEvaluationsPage) => any): Promise<CustomerProfilesEvaluationsPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property policySid - The unique string of a policy
 */
interface CustomerProfilesEvaluationsListInstanceCreateOptions {
  policySid: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface CustomerProfilesEvaluationsListInstanceEachOptions {
  callback?: (item: CustomerProfilesEvaluationsInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface CustomerProfilesEvaluationsListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface CustomerProfilesEvaluationsListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface CustomerProfilesEvaluationsPayload extends CustomerProfilesEvaluationsResource, Page.TwilioResponsePayload {
}

interface CustomerProfilesEvaluationsResource {
  account_sid: string;
  customer_profile_sid: string;
  date_created: Date;
  policy_sid: string;
  results: object[];
  sid: string;
  status: CustomerProfilesEvaluationsStatus;
  url: string;
}

interface CustomerProfilesEvaluationsSolution {
  customerProfileSid?: string;
}


declare class CustomerProfilesEvaluationsContext {
  /**
   * Initialize the CustomerProfilesEvaluationsContext
   *
   * @param version - Version of the resource
   * @param customerProfileSid - The unique string that identifies the resource
   * @param sid - The unique string that identifies the Evaluation resource
   */
  constructor(version: V1, customerProfileSid: string, sid: string);

  /**
   * fetch a CustomerProfilesEvaluationsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CustomerProfilesEvaluationsInstance) => any): Promise<CustomerProfilesEvaluationsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class CustomerProfilesEvaluationsInstance extends SerializableClass {
  /**
   * Initialize the CustomerProfilesEvaluationsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param customerProfileSid - The unique string that identifies the resource
   * @param sid - The unique string that identifies the Evaluation resource
   */
  constructor(version: V1, payload: CustomerProfilesEvaluationsPayload, customerProfileSid: string, sid: string);

  private _proxy: CustomerProfilesEvaluationsContext;
  accountSid: string;
  customerProfileSid: string;
  dateCreated: Date;
  /**
   * fetch a CustomerProfilesEvaluationsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CustomerProfilesEvaluationsInstance) => any): Promise<CustomerProfilesEvaluationsInstance>;
  policySid: string;
  results: object[];
  sid: string;
  status: CustomerProfilesEvaluationsStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class CustomerProfilesEvaluationsPage extends Page<V1, CustomerProfilesEvaluationsPayload, CustomerProfilesEvaluationsResource, CustomerProfilesEvaluationsInstance> {
  /**
   * Initialize the CustomerProfilesEvaluationsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: CustomerProfilesEvaluationsSolution);

  /**
   * Build an instance of CustomerProfilesEvaluationsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: CustomerProfilesEvaluationsPayload): CustomerProfilesEvaluationsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { CustomerProfilesEvaluationsContext, CustomerProfilesEvaluationsInstance, CustomerProfilesEvaluationsList, CustomerProfilesEvaluationsListInstance, CustomerProfilesEvaluationsListInstanceCreateOptions, CustomerProfilesEvaluationsListInstanceEachOptions, CustomerProfilesEvaluationsListInstanceOptions, CustomerProfilesEvaluationsListInstancePageOptions, CustomerProfilesEvaluationsPage, CustomerProfilesEvaluationsPayload, CustomerProfilesEvaluationsResource, CustomerProfilesEvaluationsSolution, CustomerProfilesEvaluationsStatus }
