/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the ConnectionPolicyTargetList
 *
 * @param version - Version of the resource
 * @param connectionPolicySid - The SID of the Connection Policy that owns the Target
 */
declare function ConnectionPolicyTargetList(version: V1, connectionPolicySid: string): ConnectionPolicyTargetListInstance;

/**
 * Options to pass to update
 *
 * @property enabled - Whether the Target is enabled
 * @property friendlyName - A string to describe the resource
 * @property priority - The relative importance of the target
 * @property target - The SIP address you want Twilio to route your calls to
 * @property weight - The value that determines the relative load the Target should receive compared to others with the same priority
 */
interface ConnectionPolicyTargetInstanceUpdateOptions {
  enabled?: boolean;
  friendlyName?: string;
  priority?: number;
  target?: string;
  weight?: number;
}

interface ConnectionPolicyTargetListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ConnectionPolicyTargetContext;
  /**
   * create a ConnectionPolicyTargetInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: ConnectionPolicyTargetListInstanceCreateOptions, callback?: (error: Error | null, item: ConnectionPolicyTargetInstance) => any): Promise<ConnectionPolicyTargetInstance>;
  /**
   * Streams ConnectionPolicyTargetInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: ConnectionPolicyTargetInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams ConnectionPolicyTargetInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ConnectionPolicyTargetListInstanceEachOptions, callback?: (item: ConnectionPolicyTargetInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a connection_policy_target
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): ConnectionPolicyTargetContext;
  /**
   * Retrieve a single target page of ConnectionPolicyTargetInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: ConnectionPolicyTargetPage) => any): Promise<ConnectionPolicyTargetPage>;
  /**
   * Retrieve a single target page of ConnectionPolicyTargetInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ConnectionPolicyTargetPage) => any): Promise<ConnectionPolicyTargetPage>;
  /**
   * Lists ConnectionPolicyTargetInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: ConnectionPolicyTargetInstance[]) => any): Promise<ConnectionPolicyTargetInstance[]>;
  /**
   * Lists ConnectionPolicyTargetInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ConnectionPolicyTargetListInstanceOptions, callback?: (error: Error | null, items: ConnectionPolicyTargetInstance[]) => any): Promise<ConnectionPolicyTargetInstance[]>;
  /**
   * Retrieve a single page of ConnectionPolicyTargetInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: ConnectionPolicyTargetPage) => any): Promise<ConnectionPolicyTargetPage>;
  /**
   * Retrieve a single page of ConnectionPolicyTargetInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ConnectionPolicyTargetListInstancePageOptions, callback?: (error: Error | null, items: ConnectionPolicyTargetPage) => any): Promise<ConnectionPolicyTargetPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property enabled - Whether the Target is enabled
 * @property friendlyName - A string to describe the resource
 * @property priority - The relative importance of the target
 * @property target - The SIP address you want Twilio to route your calls to
 * @property weight - The value that determines the relative load the Target should receive compared to others with the same priority
 */
interface ConnectionPolicyTargetListInstanceCreateOptions {
  enabled?: boolean;
  friendlyName?: string;
  priority?: number;
  target: string;
  weight?: number;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface ConnectionPolicyTargetListInstanceEachOptions {
  callback?: (item: ConnectionPolicyTargetInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface ConnectionPolicyTargetListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface ConnectionPolicyTargetListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface ConnectionPolicyTargetPayload extends ConnectionPolicyTargetResource, Page.TwilioResponsePayload {
}

interface ConnectionPolicyTargetResource {
  account_sid: string;
  connection_policy_sid: string;
  date_created: Date;
  date_updated: Date;
  enabled: boolean;
  friendly_name: string;
  priority: number;
  sid: string;
  target: string;
  url: string;
  weight: number;
}

interface ConnectionPolicyTargetSolution {
  connectionPolicySid?: string;
}


declare class ConnectionPolicyTargetContext {
  /**
   * Initialize the ConnectionPolicyTargetContext
   *
   * @param version - Version of the resource
   * @param connectionPolicySid - The SID of the Connection Policy that owns the Target
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, connectionPolicySid: string, sid: string);

  /**
   * fetch a ConnectionPolicyTargetInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ConnectionPolicyTargetInstance) => any): Promise<ConnectionPolicyTargetInstance>;
  /**
   * remove a ConnectionPolicyTargetInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ConnectionPolicyTargetInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ConnectionPolicyTargetInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ConnectionPolicyTargetInstance) => any): Promise<ConnectionPolicyTargetInstance>;
  /**
   * update a ConnectionPolicyTargetInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ConnectionPolicyTargetInstanceUpdateOptions, callback?: (error: Error | null, items: ConnectionPolicyTargetInstance) => any): Promise<ConnectionPolicyTargetInstance>;
}


declare class ConnectionPolicyTargetInstance extends SerializableClass {
  /**
   * Initialize the ConnectionPolicyTargetContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param connectionPolicySid - The SID of the Connection Policy that owns the Target
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: ConnectionPolicyTargetPayload, connectionPolicySid: string, sid: string);

  private _proxy: ConnectionPolicyTargetContext;
  accountSid: string;
  connectionPolicySid: string;
  dateCreated: Date;
  dateUpdated: Date;
  enabled: boolean;
  /**
   * fetch a ConnectionPolicyTargetInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ConnectionPolicyTargetInstance) => any): Promise<ConnectionPolicyTargetInstance>;
  friendlyName: string;
  priority: number;
  /**
   * remove a ConnectionPolicyTargetInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ConnectionPolicyTargetInstance) => any): Promise<boolean>;
  sid: string;
  target: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ConnectionPolicyTargetInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ConnectionPolicyTargetInstance) => any): Promise<ConnectionPolicyTargetInstance>;
  /**
   * update a ConnectionPolicyTargetInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ConnectionPolicyTargetInstanceUpdateOptions, callback?: (error: Error | null, items: ConnectionPolicyTargetInstance) => any): Promise<ConnectionPolicyTargetInstance>;
  url: string;
  weight: number;
}


declare class ConnectionPolicyTargetPage extends Page<V1, ConnectionPolicyTargetPayload, ConnectionPolicyTargetResource, ConnectionPolicyTargetInstance> {
  /**
   * Initialize the ConnectionPolicyTargetPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ConnectionPolicyTargetSolution);

  /**
   * Build an instance of ConnectionPolicyTargetInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ConnectionPolicyTargetPayload): ConnectionPolicyTargetInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ConnectionPolicyTargetContext, ConnectionPolicyTargetInstance, ConnectionPolicyTargetInstanceUpdateOptions, ConnectionPolicyTargetList, ConnectionPolicyTargetListInstance, ConnectionPolicyTargetListInstanceCreateOptions, ConnectionPolicyTargetListInstanceEachOptions, ConnectionPolicyTargetListInstanceOptions, ConnectionPolicyTargetListInstancePageOptions, ConnectionPolicyTargetPage, ConnectionPolicyTargetPayload, ConnectionPolicyTargetResource, ConnectionPolicyTargetSolution }
