/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { InteractionChannelList } from './interaction/interactionChannel';
import { InteractionChannelListInstance } from './interaction/interactionChannel';
import { SerializableClass } from '../../../interfaces';

type InteractionStatus = 'close'|'closed'|'wrapup';

/**
 * Initialize the InteractionList
 *
 * @param version - Version of the resource
 */
declare function InteractionList(version: V1): InteractionListInstance;

interface InteractionListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): InteractionContext;
  /**
   * create a InteractionInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: InteractionListInstanceCreateOptions, callback?: (error: Error | null, item: InteractionInstance) => any): Promise<InteractionInstance>;
  /**
   * Constructs a interaction
   *
   * @param sid - The SID that identifies the resource to fetch
   */
  get(sid: string): InteractionContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property channel - The Interaction's channel
 * @property routing - The Interaction's routing logic
 */
interface InteractionListInstanceCreateOptions {
  channel: object;
  routing: object;
}

interface InteractionPayload extends InteractionResource, Page.TwilioResponsePayload {
}

interface InteractionResource {
  channel: object;
  links: string;
  routing: object;
  sid: string;
  url: string;
}

interface InteractionSolution {
}


declare class InteractionContext {
  /**
   * Initialize the InteractionContext
   *
   * @param version - Version of the resource
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, sid: string);

  channels: InteractionChannelListInstance;
  /**
   * fetch a InteractionInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: InteractionInstance) => any): Promise<InteractionInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class InteractionInstance extends SerializableClass {
  /**
   * Initialize the InteractionContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, payload: InteractionPayload, sid: string);

  private _proxy: InteractionContext;
  channel: any;
  /**
   * Access the channels
   */
  channels(): InteractionChannelListInstance;
  /**
   * fetch a InteractionInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: InteractionInstance) => any): Promise<InteractionInstance>;
  links: string;
  routing: any;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class InteractionPage extends Page<V1, InteractionPayload, InteractionResource, InteractionInstance> {
  /**
   * Initialize the InteractionPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: InteractionSolution);

  /**
   * Build an instance of InteractionInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: InteractionPayload): InteractionInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { InteractionContext, InteractionInstance, InteractionList, InteractionListInstance, InteractionListInstanceCreateOptions, InteractionPage, InteractionPayload, InteractionResource, InteractionSolution, InteractionStatus }
