'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var VerificationList;
var VerificationPage;
var VerificationInstance;
var VerificationContext;

/* jshint ignore:start */
/**
 * Initialize the VerificationList
 *
 * @constructor Twilio.Verify.V2.ServiceContext.VerificationList
 *
 * @param {Twilio.Verify.V2} version - Version of the resource
 * @param {string} serviceSid -
 *          The SID of the Service that the resource is associated with
 */
/* jshint ignore:end */
VerificationList = function VerificationList(version, serviceSid) {
  /* jshint ignore:start */
  /**
   * @function verifications
   * @memberof Twilio.Verify.V2.ServiceContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Verify.V2.ServiceContext.VerificationContext}
   */
  /* jshint ignore:end */
  function VerificationListInstance(sid) {
    return VerificationListInstance.get(sid);
  }

  VerificationListInstance._version = version;
  // Path Solution
  VerificationListInstance._solution = {serviceSid: serviceSid};
  VerificationListInstance._uri = `/Services/${serviceSid}/Verifications`;
  /* jshint ignore:start */
  /**
   * create a VerificationInstance
   *
   * @function create
   * @memberof Twilio.Verify.V2.ServiceContext.VerificationList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.to - The phone number or email to verify
   * @param {string} opts.channel - The verification method to use
   * @param {string} [opts.customFriendlyName] - A custom user defined friendly name
   * @param {string} [opts.customMessage] -
   *          The text of a custom message to use for the verification
   * @param {string} [opts.sendDigits] -
   *          The digits to send after a phone call is answered
   * @param {string} [opts.locale] -
   *          The locale to use for the verification SMS, WhatsApp or call
   * @param {string} [opts.customCode] - A pre-generated code
   * @param {string} [opts.amount] -
   *          The amount of the associated PSD2 compliant transaction.
   * @param {string} [opts.payee] -
   *          The payee of the associated PSD2 compliant transaction
   * @param {object} [opts.rateLimits] -
   *          The custom key-value pairs of Programmable Rate Limits.
   * @param {object} [opts.channelConfiguration] -
   *          Channel specific configuration in json format.
   * @param {string} [opts.appHash] -
   *          Your App Hash to be appended at the end of an SMS.
   * @param {string} [opts.templateSid] - The verification template SMS messages.
   * @param {string} [opts.templateCustomSubstitutions] -
   *          The values of the special variables declared on the message template.
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed VerificationInstance
   */
  /* jshint ignore:end */
  VerificationListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts['to'])) {
      throw new Error('Required parameter "opts[\'to\']" missing.');
    }
    if (_.isUndefined(opts['channel'])) {
      throw new Error('Required parameter "opts[\'channel\']" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'To': _.get(opts, 'to'),
      'Channel': _.get(opts, 'channel'),
      'CustomFriendlyName': _.get(opts, 'customFriendlyName'),
      'CustomMessage': _.get(opts, 'customMessage'),
      'SendDigits': _.get(opts, 'sendDigits'),
      'Locale': _.get(opts, 'locale'),
      'CustomCode': _.get(opts, 'customCode'),
      'Amount': _.get(opts, 'amount'),
      'Payee': _.get(opts, 'payee'),
      'RateLimits': serialize.object(_.get(opts, 'rateLimits')),
      'ChannelConfiguration': serialize.object(_.get(opts, 'channelConfiguration')),
      'AppHash': _.get(opts, 'appHash'),
      'TemplateSid': _.get(opts, 'templateSid'),
      'TemplateCustomSubstitutions': _.get(opts, 'templateCustomSubstitutions')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new VerificationInstance(
        this._version,
        payload,
        this._solution.serviceSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a verification
   *
   * @function get
   * @memberof Twilio.Verify.V2.ServiceContext.VerificationList#
   *
   * @param {string} sid - The unique string that identifies the resource
   *
   * @returns {Twilio.Verify.V2.ServiceContext.VerificationContext}
   */
  /* jshint ignore:end */
  VerificationListInstance.get = function get(sid) {
    return new VerificationContext(this._version, this._solution.serviceSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Verify.V2.ServiceContext.VerificationList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  VerificationListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  VerificationListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return VerificationListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the VerificationPage
 *
 * @constructor Twilio.Verify.V2.ServiceContext.VerificationPage
 *
 * @param {V2} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {VerificationSolution} solution - Path solution
 *
 * @returns VerificationPage
 */
/* jshint ignore:end */
VerificationPage = function VerificationPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(VerificationPage.prototype, Page.prototype);
VerificationPage.prototype.constructor = VerificationPage;

/* jshint ignore:start */
/**
 * Build an instance of VerificationInstance
 *
 * @function getInstance
 * @memberof Twilio.Verify.V2.ServiceContext.VerificationPage#
 *
 * @param {VerificationPayload} payload - Payload response from the API
 *
 * @returns VerificationInstance
 */
/* jshint ignore:end */
VerificationPage.prototype.getInstance = function getInstance(payload) {
  return new VerificationInstance(this._version, payload, this._solution.serviceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.VerificationPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
VerificationPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

VerificationPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the VerificationContext
 *
 * @constructor Twilio.Verify.V2.ServiceContext.VerificationInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} to - The phone number or email being verified
 * @property {verification.channel} channel - The verification method used.
 * @property {string} status - The status of the verification resource
 * @property {boolean} valid - Whether the verification was successful
 * @property {object} lookup - Information about the phone number being verified
 * @property {string} amount -
 *          The amount of the associated PSD2 compliant transaction.
 * @property {string} payee -
 *          The payee of the associated PSD2 compliant transaction
 * @property {object} sendCodeAttempts - An array of verification attempt objects.
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT when the resource was last updated
 * @property {string} url - The absolute URL of the Verification resource
 *
 * @param {V2} version - Version of the resource
 * @param {VerificationPayload} payload - The instance payload
 * @param {sid} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @param {string} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
VerificationInstance = function VerificationInstance(version, payload,
                                                      serviceSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.to = payload.to; // jshint ignore:line
  this.channel = payload.channel; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.valid = payload.valid; // jshint ignore:line
  this.lookup = payload.lookup; // jshint ignore:line
  this.amount = payload.amount; // jshint ignore:line
  this.payee = payload.payee; // jshint ignore:line
  this.sendCodeAttempts = payload.send_code_attempts; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {serviceSid: serviceSid, sid: sid || this.sid, };
};

Object.defineProperty(VerificationInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new VerificationContext(
          this._version,
          this._solution.serviceSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * update a VerificationInstance
 *
 * @function update
 * @memberof Twilio.Verify.V2.ServiceContext.VerificationInstance#
 *
 * @param {object} opts - Options for request
 * @param {verification.status} opts.status - The new status of the resource
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed VerificationInstance
 */
/* jshint ignore:end */
VerificationInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * fetch a VerificationInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.ServiceContext.VerificationInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed VerificationInstance
 */
/* jshint ignore:end */
VerificationInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.VerificationInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
VerificationInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

VerificationInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the VerificationContext
 *
 * @constructor Twilio.Verify.V2.ServiceContext.VerificationContext
 *
 * @param {V2} version - Version of the resource
 * @param {sid} serviceSid -
 *          The SID of the verification Service to fetch the resource from
 * @param {string} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
VerificationContext = function VerificationContext(version, serviceSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {serviceSid: serviceSid, sid: sid, };
  this._uri = `/Services/${serviceSid}/Verifications/${sid}`;
};

/* jshint ignore:start */
/**
 * update a VerificationInstance
 *
 * @function update
 * @memberof Twilio.Verify.V2.ServiceContext.VerificationContext#
 *
 * @param {object} opts - Options for request
 * @param {verification.status} opts.status - The new status of the resource
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed VerificationInstance
 */
/* jshint ignore:end */
VerificationContext.prototype.update = function update(opts, callback) {
  if (_.isUndefined(opts)) {
    throw new Error('Required parameter "opts" missing.');
  }
  if (_.isUndefined(opts['status'])) {
    throw new Error('Required parameter "opts[\'status\']" missing.');
  }

  var deferred = Q.defer();
  var data = values.of({'Status': _.get(opts, 'status')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new VerificationInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a VerificationInstance
 *
 * @function fetch
 * @memberof Twilio.Verify.V2.ServiceContext.VerificationContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed VerificationInstance
 */
/* jshint ignore:end */
VerificationContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new VerificationInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Verify.V2.ServiceContext.VerificationContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
VerificationContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

VerificationContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  VerificationList: VerificationList,
  VerificationPage: VerificationPage,
  VerificationInstance: VerificationInstance,
  VerificationContext: VerificationContext
};
