/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { InteractionChannelInviteList } from './interactionChannel/interactionChannelInvite';
import { InteractionChannelInviteListInstance } from './interactionChannel/interactionChannelInvite';
import { InteractionChannelParticipantList } from './interactionChannel/interactionChannelParticipant';
import { InteractionChannelParticipantListInstance } from './interactionChannel/interactionChannelParticipant';
import { SerializableClass } from '../../../../interfaces';

type InteractionChannelChannelStatus = 'setup'|'active'|'failed'|'closed';

type InteractionChannelStatus = 'close'|'closed'|'wrapup';

type InteractionChannelType = 'voice'|'sms'|'email'|'web'|'whatsapp'|'chat'|'messenger'|'gbm';

/**
 * Initialize the InteractionChannelList
 *
 * @param version - Version of the resource
 * @param interactionSid - The unique string that identifies the resource.
 */
declare function InteractionChannelList(version: V1, interactionSid: string): InteractionChannelListInstance;

/**
 * Options to pass to update
 *
 * @property routing - Optional. The state of associated tasks.
 * @property status - Required. The Interaction channels's status
 */
interface InteractionChannelInstanceUpdateOptions {
  routing?: object;
  status: InteractionChannelStatus;
}

interface InteractionChannelListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): InteractionChannelContext;
  /**
   * Streams InteractionChannelInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: InteractionChannelInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams InteractionChannelInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: InteractionChannelListInstanceEachOptions, callback?: (item: InteractionChannelInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a interaction_channel
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): InteractionChannelContext;
  /**
   * Retrieve a single target page of InteractionChannelInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: InteractionChannelPage) => any): Promise<InteractionChannelPage>;
  /**
   * Retrieve a single target page of InteractionChannelInstance records from the
   * API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: InteractionChannelPage) => any): Promise<InteractionChannelPage>;
  /**
   * Lists InteractionChannelInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: InteractionChannelInstance[]) => any): Promise<InteractionChannelInstance[]>;
  /**
   * Lists InteractionChannelInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: InteractionChannelListInstanceOptions, callback?: (error: Error | null, items: InteractionChannelInstance[]) => any): Promise<InteractionChannelInstance[]>;
  /**
   * Retrieve a single page of InteractionChannelInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: InteractionChannelPage) => any): Promise<InteractionChannelPage>;
  /**
   * Retrieve a single page of InteractionChannelInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: InteractionChannelListInstancePageOptions, callback?: (error: Error | null, items: InteractionChannelPage) => any): Promise<InteractionChannelPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface InteractionChannelListInstanceEachOptions {
  callback?: (item: InteractionChannelInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface InteractionChannelListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface InteractionChannelListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface InteractionChannelPayload extends InteractionChannelResource, Page.TwilioResponsePayload {
}

interface InteractionChannelResource {
  error_code: number;
  error_message: string;
  interaction_sid: string;
  links: string;
  sid: string;
  status: InteractionChannelChannelStatus;
  type: InteractionChannelType;
  url: string;
}

interface InteractionChannelSolution {
  interactionSid?: string;
}


declare class InteractionChannelContext {
  /**
   * Initialize the InteractionChannelContext
   *
   * @param version - Version of the resource
   * @param interactionSid - The unique string that identifies the resource
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, interactionSid: string, sid: string);

  /**
   * fetch a InteractionChannelInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: InteractionChannelInstance) => any): Promise<InteractionChannelInstance>;
  invites: InteractionChannelInviteListInstance;
  participants: InteractionChannelParticipantListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a InteractionChannelInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: InteractionChannelInstanceUpdateOptions, callback?: (error: Error | null, items: InteractionChannelInstance) => any): Promise<InteractionChannelInstance>;
}


declare class InteractionChannelInstance extends SerializableClass {
  /**
   * Initialize the InteractionChannelContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param interactionSid - The unique string that identifies the resource.
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: InteractionChannelPayload, interactionSid: string, sid: string);

  private _proxy: InteractionChannelContext;
  errorCode: number;
  errorMessage: string;
  /**
   * fetch a InteractionChannelInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: InteractionChannelInstance) => any): Promise<InteractionChannelInstance>;
  interactionSid: string;
  /**
   * Access the invites
   */
  invites(): InteractionChannelInviteListInstance;
  links: string;
  /**
   * Access the participants
   */
  participants(): InteractionChannelParticipantListInstance;
  sid: string;
  status: InteractionChannelChannelStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  type: InteractionChannelType;
  /**
   * update a InteractionChannelInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: InteractionChannelInstanceUpdateOptions, callback?: (error: Error | null, items: InteractionChannelInstance) => any): Promise<InteractionChannelInstance>;
  url: string;
}


declare class InteractionChannelPage extends Page<V1, InteractionChannelPayload, InteractionChannelResource, InteractionChannelInstance> {
  /**
   * Initialize the InteractionChannelPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: InteractionChannelSolution);

  /**
   * Build an instance of InteractionChannelInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: InteractionChannelPayload): InteractionChannelInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { InteractionChannelChannelStatus, InteractionChannelContext, InteractionChannelInstance, InteractionChannelInstanceUpdateOptions, InteractionChannelList, InteractionChannelListInstance, InteractionChannelListInstanceEachOptions, InteractionChannelListInstanceOptions, InteractionChannelListInstancePageOptions, InteractionChannelPage, InteractionChannelPayload, InteractionChannelResource, InteractionChannelSolution, InteractionChannelStatus, InteractionChannelType }
