/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the IpRecordList
 *
 * @param version - Version of the resource
 */
declare function IpRecordList(version: V1): IpRecordListInstance;

/**
 * Options to pass to update
 *
 * @property friendlyName - A string to describe the resource
 */
interface IpRecordInstanceUpdateOptions {
  friendlyName?: string;
}

interface IpRecordListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): IpRecordContext;
  /**
   * create a IpRecordInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: IpRecordListInstanceCreateOptions, callback?: (error: Error | null, item: IpRecordInstance) => any): Promise<IpRecordInstance>;
  /**
   * Streams IpRecordInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: IpRecordInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams IpRecordInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: IpRecordListInstanceEachOptions, callback?: (item: IpRecordInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a ip_record
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): IpRecordContext;
  /**
   * Retrieve a single target page of IpRecordInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: IpRecordPage) => any): Promise<IpRecordPage>;
  /**
   * Retrieve a single target page of IpRecordInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: IpRecordPage) => any): Promise<IpRecordPage>;
  /**
   * Lists IpRecordInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: IpRecordInstance[]) => any): Promise<IpRecordInstance[]>;
  /**
   * Lists IpRecordInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: IpRecordListInstanceOptions, callback?: (error: Error | null, items: IpRecordInstance[]) => any): Promise<IpRecordInstance[]>;
  /**
   * Retrieve a single page of IpRecordInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: IpRecordPage) => any): Promise<IpRecordPage>;
  /**
   * Retrieve a single page of IpRecordInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: IpRecordListInstancePageOptions, callback?: (error: Error | null, items: IpRecordPage) => any): Promise<IpRecordPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property cidrPrefixLength - An integer representing the length of the {@link https://tools.ietf.org/html/rfc4632|CIDR} prefix to use with this IP address. By default the entire IP address is used, which for IPv4 is value 32.
 * @property friendlyName - A string to describe the resource
 * @property ipAddress - An IP address in dotted decimal notation, IPv4 only.
 */
interface IpRecordListInstanceCreateOptions {
  cidrPrefixLength?: number;
  friendlyName?: string;
  ipAddress: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface IpRecordListInstanceEachOptions {
  callback?: (item: IpRecordInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface IpRecordListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface IpRecordListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface IpRecordPayload extends IpRecordResource, Page.TwilioResponsePayload {
}

interface IpRecordResource {
  account_sid: string;
  cidr_prefix_length: number;
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  ip_address: string;
  sid: string;
  url: string;
}

interface IpRecordSolution {
}


declare class IpRecordContext {
  /**
   * Initialize the IpRecordContext
   *
   * @param version - Version of the resource
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a IpRecordInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: IpRecordInstance) => any): Promise<IpRecordInstance>;
  /**
   * remove a IpRecordInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: IpRecordInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a IpRecordInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: IpRecordInstance) => any): Promise<IpRecordInstance>;
  /**
   * update a IpRecordInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: IpRecordInstanceUpdateOptions, callback?: (error: Error | null, items: IpRecordInstance) => any): Promise<IpRecordInstance>;
}


declare class IpRecordInstance extends SerializableClass {
  /**
   * Initialize the IpRecordContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: IpRecordPayload, sid: string);

  private _proxy: IpRecordContext;
  accountSid: string;
  cidrPrefixLength: number;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a IpRecordInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: IpRecordInstance) => any): Promise<IpRecordInstance>;
  friendlyName: string;
  ipAddress: string;
  /**
   * remove a IpRecordInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: IpRecordInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a IpRecordInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: IpRecordInstance) => any): Promise<IpRecordInstance>;
  /**
   * update a IpRecordInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: IpRecordInstanceUpdateOptions, callback?: (error: Error | null, items: IpRecordInstance) => any): Promise<IpRecordInstance>;
  url: string;
}


declare class IpRecordPage extends Page<V1, IpRecordPayload, IpRecordResource, IpRecordInstance> {
  /**
   * Initialize the IpRecordPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: IpRecordSolution);

  /**
   * Build an instance of IpRecordInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: IpRecordPayload): IpRecordInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { IpRecordContext, IpRecordInstance, IpRecordInstanceUpdateOptions, IpRecordList, IpRecordListInstance, IpRecordListInstanceCreateOptions, IpRecordListInstanceEachOptions, IpRecordListInstanceOptions, IpRecordListInstancePageOptions, IpRecordPage, IpRecordPayload, IpRecordResource, IpRecordSolution }
