/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */


declare class VoiceResponse {
  /**
   * <Response> TwiML for Voice
   */
  constructor();

  /**
   * <Connect> TwiML Verb
   *
   * @param attributes - TwiML attributes
   */
  connect(attributes?: VoiceResponse.ConnectAttributes): VoiceResponse.Connect;
  /**
   * <Dial> TwiML Verb
   *
   * @param number - Phone number to dial
   */
  dial(number?: string): VoiceResponse.Dial;
  /**
   * <Dial> TwiML Verb
   *
   * @param attributes - TwiML attributes
   * @param number - Phone number to dial
   */
  dial(attributes?: VoiceResponse.DialAttributes, number?: string): VoiceResponse.Dial;
  /**
   * <Echo> TwiML Verb
   *
   * @param attributes - TwiML attributes
   */
  echo(attributes?: object): void;
  /**
   * <Enqueue> TwiML Noun
   *
   * @param name - Friendly name
   */
  enqueue(name?: string): VoiceResponse.Enqueue;
  /**
   * <Enqueue> TwiML Noun
   *
   * @param attributes - TwiML attributes
   * @param name - Friendly name
   */
  enqueue(attributes?: VoiceResponse.EnqueueAttributes, name?: string): VoiceResponse.Enqueue;
  /**
   * <Gather> TwiML Verb
   *
   * @param attributes - TwiML attributes
   */
  gather(attributes?: VoiceResponse.GatherAttributes): VoiceResponse.Gather;
  /**
   * <Hangup> TwiML Verb
   *
   * @param attributes - TwiML attributes
   */
  hangup(attributes?: object): void;
  /**
   * <Leave> TwiML Verb
   *
   * @param attributes - TwiML attributes
   */
  leave(attributes?: object): void;
  /**
   * <Pause> TwiML Verb
   *
   * @param attributes - TwiML attributes
   */
  pause(attributes?: VoiceResponse.PauseAttributes): void;
  /**
   * <Pay> Twiml Verb
   *
   * @param attributes - TwiML attributes
   */
  pay(attributes?: VoiceResponse.PayAttributes): VoiceResponse.Pay;
  /**
   * <Play> TwiML Verb
   *
   * @param url - Media URL
   */
  play(url?: string): void;
  /**
   * <Play> TwiML Verb
   *
   * @param attributes - TwiML attributes
   * @param url - Media URL
   */
  play(attributes?: VoiceResponse.PlayAttributes, url?: string): void;
  /**
   * <Prompt> Twiml Verb
   *
   * @param attributes - TwiML attributes
   */
  prompt(attributes?: VoiceResponse.PromptAttributes): VoiceResponse.Prompt;
  /**
   * <Queue> TwiML Noun
   *
   * @param name - Queue name
   */
  queue(name: string): void;
  /**
   * <Queue> TwiML Noun
   *
   * @param attributes - TwiML attributes
   * @param name - Queue name
   */
  queue(attributes: VoiceResponse.QueueAttributes, name: string): void;
  /**
   * <Record> TwiML Verb
   *
   * @param attributes - TwiML attributes
   */
  record(attributes?: VoiceResponse.RecordAttributes): void;
  /**
   * <Redirect> TwiML Verb
   *
   * @param url - Redirect URL
   */
  redirect(url: string): void;
  /**
   * <Redirect> TwiML Verb
   *
   * @param attributes - TwiML attributes
   * @param url - Redirect URL
   */
  redirect(attributes: VoiceResponse.RedirectAttributes, url: string): void;
  /**
   * <Refer> TwiML Verb
   *
   * @param attributes - TwiML attributes
   */
  refer(attributes?: VoiceResponse.ReferAttributes): VoiceResponse.Refer;
  /**
   * <Reject> TwiML Verb
   *
   * @param attributes - TwiML attributes
   */
  reject(attributes?: VoiceResponse.RejectAttributes): void;
  /**
   * <Say> TwiML Verb
   *
   * @param message - Message to say
   */
  say(message: string): VoiceResponse.Say;
  /**
   * <Say> TwiML Verb
   *
   * @param attributes - TwiML attributes
   * @param message - Message to say
   */
  say(attributes: VoiceResponse.SayAttributes, message: string): VoiceResponse.Say;
  /**
   * <Sms> TwiML Noun
   *
   * @param message - Message body
   */
  sms(message: string): void;
  /**
   * <Sms> TwiML Noun
   *
   * @param attributes - TwiML attributes
   * @param message - Message body
   */
  sms(attributes: VoiceResponse.SmsAttributes, message: string): void;
  /**
   * <Start> TwiML Verb
   *
   * @param attributes - TwiML attributes
   */
  start(attributes?: VoiceResponse.StartAttributes): VoiceResponse.Start;
  /**
   * <Stop> TwiML Verb
   *
   * @param attributes - TwiML attributes
   */
  stop(attributes?: object): VoiceResponse.Stop;
  /**
   * Convert to XML
   */
  toString(): string;
}

declare namespace VoiceResponse {

  type ClientEvent = 'initiated'|'ringing'|'answered'|'completed';

  type ConferenceBeep = 'true'|'false'|'onEnter'|'onExit';

  type ConferenceEvent = 'start'|'end'|'join'|'leave'|'mute'|'hold'|'modify'|'speaker'|'announcement';

  type ConferenceJitterBufferSize = 'large'|'medium'|'small'|'off';

  type ConferenceRecord = 'do-not-record'|'record-from-start';

  type ConferenceRecordingEvent = 'in-progress'|'completed'|'absent';

  type ConferenceRegion = 'us1'|'ie1'|'sg1'|'br1'|'au1'|'jp1'|'de1';

  type ConferenceTrim = 'trim-silence'|'do-not-trim';

  type ConversationEvent = 'call-initiated'|'call-ringing'|'call-answered'|'call-completed';

  type ConversationRecord = 'do-not-record'|'record-from-answer'|'record-from-ringing'|'record-from-answer-dual'|'record-from-ringing-dual'|'true'|'false';

  type ConversationRecordingEvent = 'in-progress'|'completed'|'absent';

  type ConversationTrim = 'trim-silence'|'do-not-trim';

  type DialRecord = 'do-not-record'|'record-from-answer'|'record-from-ringing'|'record-from-answer-dual'|'record-from-ringing-dual';

  type DialRecordingEvent = 'in-progress'|'completed'|'absent';

  type DialRecordingTrack = 'both'|'inbound'|'outbound';

  type DialRingTone = 'at'|'au'|'bg'|'br'|'be'|'ch'|'cl'|'cn'|'cz'|'de'|'dk'|'ee'|'es'|'fi'|'fr'|'gr'|'hu'|'il'|'in'|'it'|'lt'|'jp'|'mx'|'my'|'nl'|'no'|'nz'|'ph'|'pl'|'pt'|'ru'|'se'|'sg'|'th'|'uk'|'us'|'us-old'|'tw'|'ve'|'za';

  type DialTrim = 'trim-silence'|'do-not-trim';

  type GatherInput = 'dtmf'|'speech';

  type GatherLanguage = 'af-ZA'|'am-ET'|'ar-AE'|'ar-BH'|'ar-DZ'|'ar-EG'|'ar-IL'|'ar-IQ'|'ar-JO'|'ar-KW'|'ar-LB'|'ar-MA'|'ar-OM'|'ar-PS'|'ar-QA'|'ar-SA'|'ar-TN'|'az-AZ'|'bg-BG'|'bn-BD'|'bn-IN'|'ca-ES'|'cs-CZ'|'da-DK'|'de-DE'|'el-GR'|'en-AU'|'en-CA'|'en-GB'|'en-GH'|'en-IE'|'en-IN'|'en-KE'|'en-NG'|'en-NZ'|'en-PH'|'en-SG'|'en-TZ'|'en-US'|'en-ZA'|'es-AR'|'es-BO'|'es-CL'|'es-CO'|'es-CR'|'es-DO'|'es-EC'|'es-ES'|'es-GT'|'es-HN'|'es-MX'|'es-NI'|'es-PA'|'es-PE'|'es-PR'|'es-PY'|'es-SV'|'es-US'|'es-UY'|'es-VE'|'et-EE'|'eu-ES'|'fa-IR'|'fi-FI'|'fil-PH'|'fr-CA'|'fr-FR'|'gl-ES'|'gu-IN'|'he-IL'|'hi-IN'|'hr-HR'|'hu-HU'|'hy-AM'|'id-ID'|'is-IS'|'it-IT'|'ja-JP'|'jv-ID'|'ka-GE'|'km-KH'|'kn-IN'|'ko-KR'|'lo-LA'|'lt-LT'|'lv-LV'|'mk-MK'|'ml-IN'|'mn-MN'|'mr-IN'|'ms-MY'|'my-MM'|'nar-IQ'|'nb-NO'|'ne-NP'|'nl-BE'|'nl-NL'|'pa-guru-IN'|'pl-PL'|'pt-BR'|'pt-PT'|'ro-RO'|'ru-RU'|'si-LK'|'sk-SK'|'sl-SI'|'sq-AL'|'sr-RS'|'su-ID'|'sv-SE'|'sw-KE'|'sw-TZ'|'ta-IN'|'ta-LK'|'ta-MY'|'ta-SG'|'te-IN'|'th-TH'|'tr-TR'|'uk-UA'|'ur-IN'|'ur-PK'|'uz-UZ'|'vi-VN'|'yue-Hant-HK'|'zh'|'cmn-Hans-CN'|'zh-TW'|'cmn-Hant-TW'|'zu-ZA';

  type GatherSpeechModel = 'default'|'numbers_and_commands'|'phone_call';

  type NumberEvent = 'initiated'|'ringing'|'answered'|'completed';

  type PayBankAccountType = 'consumer-checking'|'consumer-savings'|'commercial-checking'|'commercial-savings';

  type PayInput = 'dtmf';

  type PayLanguage = 'de-DE'|'en-AU'|'en-CA'|'en-GB'|'en-IN'|'en-IE'|'en-NZ'|'en-PH'|'en-ZA'|'en-US'|'es-ES'|'es-US'|'fr-CA'|'fr-FR'|'it-IT';

  type PayPaymentMethod = 'ach-debit'|'credit-card';

  type PayStatusCallbackMethod = 'GET'|'POST';

  type PayTokenType = 'one-time'|'reusable';

  type PayValidCardTypes = 'visa'|'mastercard'|'amex'|'maestro'|'discover'|'optima'|'jcb'|'diners-club'|'enroute';

  type PromptCardType = 'visa'|'mastercard'|'amex'|'maestro'|'discover'|'optima'|'jcb'|'diners-club'|'enroute';

  type PromptErrorType = 'timeout'|'invalid-card-number'|'invalid-card-type'|'invalid-date'|'invalid-security-code'|'internal-error';

  type PromptFor = 'payment-card-number'|'expiration-date'|'security-code'|'postal-code'|'payment-processing'|'bank-account-number'|'bank-routing-number';

  type RecordRecordingEvent = 'in-progress'|'completed'|'absent';

  type RecordTrim = 'trim-silence'|'do-not-trim';

  type RejectReason = 'rejected'|'busy';

  type SayLanguage = 'arb'|'ca-ES'|'cy-GB'|'da-DK'|'de-DE'|'de-AT'|'en-AU'|'en-CA'|'en-GB'|'en-GB-WLS'|'en-IN'|'en-NZ'|'en-ZA'|'en-US'|'es-ES'|'es-MX'|'es-US'|'fi-FI'|'fr-CA'|'fr-FR'|'hi-IN'|'is-IS'|'it-IT'|'ja-JP'|'ko-KR'|'nb-NO'|'nl-NL'|'pl-PL'|'pt-BR'|'pt-PT'|'ro-RO'|'ru-RU'|'sv-SE'|'tr-TR'|'zh-CN'|'zh-HK'|'zh-TW';

  type SayVoice = 'man'|'woman'|'alice'|'Polly.Aditi'|'Polly.Amy'|'Polly.Astrid'|'Polly.Bianca'|'Polly.Brian'|'Polly.Camila'|'Polly.Carla'|'Polly.Carmen'|'Polly.Celine'|'Polly.Chantal'|'Polly.Conchita'|'Polly.Cristiano'|'Polly.Dora'|'Polly.Emma'|'Polly.Enrique'|'Polly.Ewa'|'Polly.Filiz'|'Polly.Geraint'|'Polly.Giorgio'|'Polly.Gwyneth'|'Polly.Hans'|'Polly.Ines'|'Polly.Ivy'|'Polly.Jacek'|'Polly.Jan'|'Polly.Joanna'|'Polly.Joey'|'Polly.Justin'|'Polly.Karl'|'Polly.Kendra'|'Polly.Kimberly'|'Polly.Lea'|'Polly.Liv'|'Polly.Lotte'|'Polly.Lucia'|'Polly.Lupe'|'Polly.Mads'|'Polly.Maja'|'Polly.Marlene'|'Polly.Mathieu'|'Polly.Matthew'|'Polly.Maxim'|'Polly.Mia'|'Polly.Miguel'|'Polly.Mizuki'|'Polly.Naja'|'Polly.Nicole'|'Polly.Penelope'|'Polly.Raveena'|'Polly.Ricardo'|'Polly.Ruben'|'Polly.Russell'|'Polly.Salli'|'Polly.Seoyeon'|'Polly.Takumi'|'Polly.Tatyana'|'Polly.Vicki'|'Polly.Vitoria'|'Polly.Zeina'|'Polly.Zhiyu'|'Polly.Amy-Neural'|'Polly.Aria-Neural'|'Polly.Arlet-Neural'|'Polly.Arthur-Neural'|'Polly.Ayanda-Neural'|'Polly.Bianca-Neural'|'Polly.Brian-Neural'|'Polly.Camila-Neural'|'Polly.Daniel-Neural'|'Polly.Emma-Neural'|'Polly.Gabrielle-Neural'|'Polly.Hannah-Neural'|'Polly.Ines-Neural'|'Polly.Ivy-Neural'|'Polly.Joanna-Neural'|'Polly.Joey-Neural'|'Polly.Justin-Neural'|'Polly.Kajal-Neural'|'Polly.Kendra-Neural'|'Polly.Kevin-Neural'|'Polly.Kimberly-Neural'|'Polly.Lea-Neural'|'Polly.Liam-Neural'|'Polly.Lucia-Neural'|'Polly.Lupe-Neural'|'Polly.Matthew-Neural'|'Polly.Mia-Neural'|'Polly.Olivia-Neural'|'Polly.Pedro-Neural'|'Polly.Salli-Neural'|'Polly.Seoyeon-Neural'|'Polly.Takumi-Neural'|'Polly.Vicki-Neural'|'Polly.Vitoria-Neural';

  type SipEvent = 'initiated'|'ringing'|'answered'|'completed';

  type SiprecTrack = 'inbound_track'|'outbound_track'|'both_tracks';

  type SsmlBreakStrength = 'none'|'x-weak'|'weak'|'medium'|'strong'|'x-strong';

  type SsmlEmphasisLevel = 'strong'|'moderate'|'reduced';

  type SsmlLangXmlLang = 'arb'|'ca-ES'|'cmn-CN'|'cy-GB'|'da-DK'|'de-DE'|'de-AT'|'en-AU'|'en-GB'|'en-GB-WLS'|'en-IN'|'en-NZ'|'en-US'|'en-ZA'|'es-ES'|'es-MX'|'es-US'|'fr-CA'|'fr-FR'|'hi-IN'|'is-IS'|'it-IT'|'ja-JP'|'ko-KR'|'nb-NO'|'nl-NL'|'pl-PL'|'pt-BR'|'pt-PT'|'ro-RO'|'ru-RU'|'sv-SE'|'tr-TR';

  type SsmlPhonemeAlphabet = 'ipa'|'x-sampa';

  type SsmlSayAsInterpretAs = 'character'|'spell-out'|'cardinal'|'number'|'ordinal'|'digits'|'fraction'|'unit'|'date'|'time'|'address'|'expletive'|'telephone';

  type SsmlSayAsRole = 'mdy'|'dmy'|'ymd'|'md'|'dm'|'ym'|'my'|'d'|'m'|'y'|'yyyymmdd';

  type StreamStatusCallbackMethod = 'GET'|'POST';

  type StreamTrack = 'inbound_track'|'outbound_track'|'both_tracks';

  /**
   * Options to pass to client
   *
   * @property method - Client URL Method
   * @property statusCallback - Status Callback URL
   * @property statusCallbackEvent - Events to trigger status callback
   * @property statusCallbackMethod - Status Callback URL Method
   * @property url - Client URL
   */
  export interface ClientAttributes {
    method?: string;
    statusCallback?: string;
    statusCallbackEvent?: ClientEvent[];
    statusCallbackMethod?: string;
    url?: string;
  }

  /**
   * Options to pass to conference
   *
   * @property beep - Play beep when joining
   * @property coach - Call coach
   * @property endConferenceOnExit - End the conferenceon exit
   * @property eventCallbackUrl - Event callback URL
   * @property jitterBufferSize - Size of jitter buffer for participant
   * @property maxParticipants - Maximum number of participants
   * @property muted - Join the conference muted
   * @property participantLabel - A label for participant
   * @property record - Record the conference
   * @property recordingStatusCallback - Recording status callback URL
   * @property recordingStatusCallbackEvent - Recording status callback events
   * @property recordingStatusCallbackMethod - Recording status callback URL method
   * @property region - Conference region
   * @property startConferenceOnEnter - Start the conference on enter
   * @property statusCallback - Status callback URL
   * @property statusCallbackEvent - Events to call status callback URL
   * @property statusCallbackMethod - Status callback URL method
   * @property trim - Trim the conference recording
   * @property waitMethod - Wait URL method
   * @property waitUrl - Wait URL
   */
  export interface ConferenceAttributes {
    beep?: ConferenceBeep;
    coach?: string;
    endConferenceOnExit?: boolean;
    eventCallbackUrl?: string;
    jitterBufferSize?: ConferenceJitterBufferSize;
    maxParticipants?: number;
    muted?: boolean;
    participantLabel?: string;
    record?: ConferenceRecord;
    recordingStatusCallback?: string;
    recordingStatusCallbackEvent?: ConferenceRecordingEvent[];
    recordingStatusCallbackMethod?: string;
    region?: ConferenceRegion;
    startConferenceOnEnter?: boolean;
    statusCallback?: string;
    statusCallbackEvent?: ConferenceEvent[];
    statusCallbackMethod?: string;
    trim?: ConferenceTrim;
    waitMethod?: string;
    waitUrl?: string;
  }

  /**
   * Options to pass to config
   *
   * @property name - The name of the custom config
   * @property value - The value of the custom config
   */
  export interface ConfigAttributes {
    name?: string;
    value?: string;
  }

  /**
   * Options to pass to connect
   *
   * @property action - Action URL
   * @property method - Action URL method
   */
  export interface ConnectAttributes {
    action?: string;
    method?: string;
  }

  /**
   * Options to pass to conversation
   *
   * @property inboundAutocreation - Inbound autocreation
   * @property inboundTimeout - Inbound timeout
   * @property record - Record
   * @property recordingStatusCallback - Recording status callback URL
   * @property recordingStatusCallbackEvent - Recording status callback events
   * @property recordingStatusCallbackMethod - Recording status callback URL method
   * @property routingAssignmentTimeout - Routing assignment timeout
   * @property serviceInstanceSid - Service instance Sid
   * @property statusCallback - Status callback URL
   * @property statusCallbackEvent - Events to call status callback URL
   * @property statusCallbackMethod - Status callback URL method
   * @property trim - Trim
   */
  export interface ConversationAttributes {
    inboundAutocreation?: boolean;
    inboundTimeout?: number;
    record?: ConversationRecord;
    recordingStatusCallback?: string;
    recordingStatusCallbackEvent?: ConversationRecordingEvent[];
    recordingStatusCallbackMethod?: string;
    routingAssignmentTimeout?: number;
    serviceInstanceSid?: string;
    statusCallback?: string;
    statusCallbackEvent?: ConversationEvent[];
    statusCallbackMethod?: string;
    trim?: ConversationTrim;
  }

  /**
   * Options to pass to dial
   *
   * @property action - Action URL
   * @property answerOnBridge - Preserve the ringing behavior of the inbound call until the Dialed call picks up
   * @property callerId - Caller ID to display
   * @property hangupOnStar - Hangup call on star press
   * @property method - Action URL method
   * @property record - Record the call
   * @property recordingStatusCallback - Recording status callback URL
   * @property recordingStatusCallbackEvent - Recording status callback events
   * @property recordingStatusCallbackMethod - Recording status callback URL method
   * @property recordingTrack - To indicate which audio track should be recorded
   * @property referMethod - The HTTP method to use for the refer Webhook
   * @property referUrl - Webhook that will receive future SIP REFER requests
   * @property ringTone - Ringtone allows you to override the ringback tone that Twilio will play back to the caller while executing the Dial
   * @property sequential - Used to determine if child TwiML nouns should be dialed in order, one after the other (sequential) or dial all at once (parallel). Default is false, parallel
   * @property timeLimit - Max time length
   * @property timeout - Time to wait for answer
   * @property trim - Trim the recording
   */
  export interface DialAttributes {
    action?: string;
    answerOnBridge?: boolean;
    callerId?: string;
    hangupOnStar?: boolean;
    method?: string;
    record?: DialRecord;
    recordingStatusCallback?: string;
    recordingStatusCallbackEvent?: DialRecordingEvent[];
    recordingStatusCallbackMethod?: string;
    recordingTrack?: DialRecordingTrack;
    referMethod?: string;
    referUrl?: string;
    ringTone?: DialRingTone;
    sequential?: boolean;
    timeLimit?: number;
    timeout?: number;
    trim?: DialTrim;
  }

  /**
   * Options to pass to enqueue
   *
   * @property action - Action URL
   * @property maxQueueSize - Maximum size of queue
   * @property method - Action URL method
   * @property waitUrl - Wait URL
   * @property waitUrlMethod - Wait URL method
   * @property workflowSid - TaskRouter Workflow SID
   */
  export interface EnqueueAttributes {
    action?: string;
    maxQueueSize?: number;
    method?: string;
    waitUrl?: string;
    waitUrlMethod?: string;
    workflowSid?: string;
  }

  /**
   * Options to pass to gather
   *
   * @property action - Action URL
   * @property actionOnEmptyResult - Force webhook to the action URL event if there is no input
   * @property bargeIn - Stop playing media upon speech
   * @property debug - Allow debug for gather
   * @property enhanced - Use enhanced speech model
   * @property finishOnKey - Finish gather on key
   * @property hints - Speech recognition hints
   * @property input - Input type Twilio should accept
   * @property language - Language to use
   * @property maxSpeechTime - Max allowed time for speech input
   * @property method - Action URL method
   * @property numDigits - Number of digits to collect
   * @property partialResultCallback - Partial result callback URL
   * @property partialResultCallbackMethod - Partial result callback URL method
   * @property profanityFilter - Profanity Filter on speech
   * @property speechModel - Specify the model that is best suited for your use case
   * @property speechTimeout - Time to wait to gather speech input and it should be either auto or a positive integer.
   * @property timeout - Time to wait to gather input
   */
  export interface GatherAttributes {
    action?: string;
    actionOnEmptyResult?: boolean;
    bargeIn?: boolean;
    debug?: boolean;
    enhanced?: boolean;
    finishOnKey?: string;
    hints?: string;
    input?: GatherInput[];
    language?: GatherLanguage;
    maxSpeechTime?: number;
    method?: string;
    numDigits?: number;
    partialResultCallback?: string;
    partialResultCallbackMethod?: string;
    profanityFilter?: boolean;
    speechModel?: GatherSpeechModel;
    speechTimeout?: string;
    timeout?: number;
  }

  /**
   * Options to pass to number
   *
   * @property byoc - BYOC trunk SID (Beta)
   * @property method - TwiML URL method
   * @property sendDigits - DTMF tones to play when the call is answered
   * @property statusCallback - Status callback URL
   * @property statusCallbackEvent - Events to call status callback
   * @property statusCallbackMethod - Status callback URL method
   * @property url - TwiML URL
   */
  export interface NumberAttributes {
    byoc?: string;
    method?: string;
    sendDigits?: string;
    statusCallback?: string;
    statusCallbackEvent?: NumberEvent[];
    statusCallbackMethod?: string;
    url?: string;
  }

  /**
   * Options to pass to parameter
   *
   * @property name - The name of the custom parameter
   * @property value - The value of the custom parameter
   */
  export interface ParameterAttributes {
    name?: string;
    value?: string;
  }

  /**
   * Options to pass to pause
   *
   * @property length - Length in seconds to pause
   */
  export interface PauseAttributes {
    length?: number;
  }

  /**
   * Options to pass to pay
   *
   * @property action - Action URL
   * @property bankAccountType - Bank account type for ach transactions. If set, payment method attribute must be provided and value should be set to ach-debit. defaults to consumer-checking
   * @property chargeAmount - Amount to process. If value is greater than 0 then make the payment else create a payment token
   * @property currency - Currency of the amount attribute
   * @property description - Details regarding the payment
   * @property input - Input type Twilio should accept
   * @property language - Language to use
   * @property maxAttempts - Maximum number of allowed retries when gathering input
   * @property minPostalCodeLength - Prompt for minimum postal code length
   * @property paymentConnector - Unique name for payment connector
   * @property paymentMethod - Payment method to be used. defaults to credit-card
   * @property postalCode - Prompt for postal code and it should be true/false or default postal code
   * @property securityCode - Prompt for security code
   * @property statusCallback - Status callback URL
   * @property statusCallbackMethod - Status callback method
   * @property timeout - Time to wait to gather input
   * @property tokenType - Type of token
   * @property validCardTypes - Comma separated accepted card types
   */
  export interface PayAttributes {
    action?: string;
    bankAccountType?: PayBankAccountType;
    chargeAmount?: string;
    currency?: string;
    description?: string;
    input?: PayInput;
    language?: PayLanguage;
    maxAttempts?: number;
    minPostalCodeLength?: number;
    paymentConnector?: string;
    paymentMethod?: PayPaymentMethod;
    postalCode?: string;
    securityCode?: boolean;
    statusCallback?: string;
    statusCallbackMethod?: PayStatusCallbackMethod;
    timeout?: number;
    tokenType?: PayTokenType;
    validCardTypes?: PayValidCardTypes[];
  }

  /**
   * Options to pass to play
   *
   * @property digits - Play DTMF tones for digits
   * @property loop - Times to loop media
   */
  export interface PlayAttributes {
    digits?: string;
    loop?: number;
  }

  /**
   * Options to pass to prompt
   *
   * @property attempt - Current attempt count
   * @property cardType - Type of the credit card
   * @property errorType - Type of error
   * @property for_ - Name of the payment source data element
   */
  export interface PromptAttributes {
    attempt?: number[];
    cardType?: PromptCardType[];
    errorType?: PromptErrorType[];
    for_?: PromptFor;
  }

  /**
   * Options to pass to queue
   *
   * @property method - Action URL method
   * @property postWorkActivitySid - TaskRouter Activity SID
   * @property reservationSid - TaskRouter Reservation SID
   * @property url - Action URL
   */
  export interface QueueAttributes {
    method?: string;
    postWorkActivitySid?: string;
    reservationSid?: string;
    url?: string;
  }

  /**
   * Options to pass to record
   *
   * @property action - Action URL
   * @property finishOnKey - Finish recording on key
   * @property maxLength - Max time to record in seconds
   * @property method - Action URL method
   * @property playBeep - Play beep
   * @property recordingStatusCallback - Status callback URL
   * @property recordingStatusCallbackEvent - Recording status callback events
   * @property recordingStatusCallbackMethod - Status callback URL method
   * @property timeout - Timeout to begin recording
   * @property transcribe - Transcribe the recording
   * @property transcribeCallback - Transcribe callback URL
   * @property trim - Trim the recording
   */
  export interface RecordAttributes {
    action?: string;
    finishOnKey?: string;
    maxLength?: number;
    method?: string;
    playBeep?: boolean;
    recordingStatusCallback?: string;
    recordingStatusCallbackEvent?: RecordRecordingEvent[];
    recordingStatusCallbackMethod?: string;
    timeout?: number;
    transcribe?: boolean;
    transcribeCallback?: string;
    trim?: RecordTrim;
  }

  /**
   * Options to pass to redirect
   *
   * @property method - Redirect URL method
   */
  export interface RedirectAttributes {
    method?: string;
  }

  /**
   * Options to pass to refer
   *
   * @property action - Action URL
   * @property method - Action URL method
   */
  export interface ReferAttributes {
    action?: string;
    method?: string;
  }

  /**
   * Options to pass to reject
   *
   * @property reason - Rejection reason
   */
  export interface RejectAttributes {
    reason?: RejectReason;
  }

  /**
   * Options to pass to room
   *
   * @property participantIdentity - Participant identity when connecting to the Room
   */
  export interface RoomAttributes {
    participantIdentity?: string;
  }

  /**
   * Options to pass to say
   *
   * @property language - Message language
   * @property loop - Times to loop message
   * @property voice - Voice to use
   */
  export interface SayAttributes {
    language?: SayLanguage;
    loop?: number;
    voice?: SayVoice;
  }

  /**
   * Options to pass to sip
   *
   * @property method - Action URL method
   * @property password - SIP Password
   * @property statusCallback - Status callback URL
   * @property statusCallbackEvent - Status callback events
   * @property statusCallbackMethod - Status callback URL method
   * @property url - Action URL
   * @property username - SIP Username
   */
  export interface SipAttributes {
    method?: string;
    password?: string;
    statusCallback?: string;
    statusCallbackEvent?: SipEvent[];
    statusCallbackMethod?: string;
    url?: string;
    username?: string;
  }

  /**
   * Options to pass to siprec
   *
   * @property connectorName - Unique name for Connector
   * @property name - Friendly name given to SIPREC
   * @property track - Track to be streamed to remote service
   */
  export interface SiprecAttributes {
    connectorName?: string;
    name?: string;
    track?: SiprecTrack;
  }

  /**
   * Options to pass to sms
   *
   * @property action - Action URL
   * @property from - Number to send message from
   * @property method - Action URL method
   * @property statusCallback - Status callback URL
   * @property to - Number to send message to
   */
  export interface SmsAttributes {
    action?: string;
    from?: string;
    method?: string;
    statusCallback?: string;
    to?: string;
  }

  /**
   * Options to pass to break_
   *
   * @property strength - Set a pause based on strength
   * @property time - Set a pause to a specific length of time in seconds or milliseconds, available values: [number]s, [number]ms
   */
  export interface SsmlBreakAttributes {
    strength?: SsmlBreakStrength;
    time?: string;
  }

  /**
   * Options to pass to emphasis
   *
   * @property level - Specify the degree of emphasis
   */
  export interface SsmlEmphasisAttributes {
    level?: SsmlEmphasisLevel;
  }

  /**
   * Options to pass to lang
   *
   * @property xml:lang - Specify the language
   */
  export interface SsmlLangAttributes {
    "xml:lang"?: SsmlLangXmlLang;
  }

  /**
   * Options to pass to phoneme
   *
   * @property alphabet - Specify the phonetic alphabet
   * @property ph - Specifiy the phonetic symbols for pronunciation
   */
  export interface SsmlPhonemeAttributes {
    alphabet?: SsmlPhonemeAlphabet;
    ph?: string;
  }

  /**
   * Options to pass to prosody
   *
   * @property pitch - Specify the pitch, available values: default, x-low, low, medium, high, x-high, +n%, -n%
   * @property rate - Specify the rate, available values: x-slow, slow, medium, fast, x-fast, n%
   * @property volume - Specify the volume, available values: default, silent, x-soft, soft, medium, loud, x-loud, +ndB, -ndB
   */
  export interface SsmlProsodyAttributes {
    pitch?: string;
    rate?: string;
    volume?: string;
  }

  /**
   * Options to pass to sayAs
   *
   * @property interpret-as - Specify the type of words are spoken
   * @property role - Specify the format of the date when interpret-as is set to date
   */
  export interface SsmlSayAsAttributes {
    "interpret-as"?: SsmlSayAsInterpretAs;
    role?: SsmlSayAsRole;
  }

  /**
   * Options to pass to sub
   *
   * @property alias - Substitute a different word (or pronunciation) for selected text such as an acronym or abbreviation
   */
  export interface SsmlSubAttributes {
    alias?: string;
  }

  /**
   * Options to pass to w
   *
   * @property role - Customize the pronunciation of words by specifying the word’s part of speech or alternate meaning
   */
  export interface SsmlWAttributes {
    role?: string;
  }

  /**
   * Options to pass to start
   *
   * @property action - Action URL
   * @property method - Action URL method
   */
  export interface StartAttributes {
    action?: string;
    method?: string;
  }

  /**
   * Options to pass to stream
   *
   * @property connectorName - Unique name for Stream Connector
   * @property name - Friendly name given to the Stream
   * @property statusCallback - Status Callback URL
   * @property statusCallbackMethod - Status Callback URL method
   * @property track - Track to be streamed to remote service
   * @property url - URL of the remote service where the Stream is routed
   */
  export interface StreamAttributes {
    connectorName?: string;
    name?: string;
    statusCallback?: string;
    statusCallbackMethod?: StreamStatusCallbackMethod;
    track?: StreamTrack;
    url?: string;
  }

  /**
   * Options to pass to task
   *
   * @property priority - Task priority
   * @property timeout - Timeout associated with task
   */
  export interface TaskAttributes {
    priority?: number;
    timeout?: number;
  }

  /**
   * Options to pass to virtualAgent
   *
   * @property connectorName - Defines the conversation profile Dialogflow needs to use
   * @property language - Language to be used by Dialogflow to transcribe speech
   * @property sentimentAnalysis - Whether sentiment analysis needs to be enabled or not
   * @property statusCallback - URL to post status callbacks from Twilio
   * @property statusCallbackMethod - HTTP method to use when requesting the status callback URL
   */
  export interface VirtualAgentAttributes {
    connectorName?: string;
    language?: string;
    sentimentAnalysis?: boolean;
    statusCallback?: string;
    statusCallbackMethod?: string;
  }


  class Client {

    /**
     * <Identity> TwiML Noun
     *
     * @param clientIdentity - Identity of the client to dial
     */
    identity(clientIdentity: string): void;
    /**
     * <Identity> TwiML Noun
     *
     * @param attributes - TwiML attributes
     * @param clientIdentity - Identity of the client to dial
     */
    identity(attributes: object, clientIdentity: string): void;
    /**
     * <Parameter> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    parameter(attributes?: VoiceResponse.ParameterAttributes): void;
  }


  class Connect {

    /**
     * <Autopilot> TwiML Noun
     *
     * @param name - Autopilot assistant sid or unique name
     */
    autopilot(name: string): void;
    /**
     * <Autopilot> TwiML Noun
     *
     * @param attributes - TwiML attributes
     * @param name - Autopilot assistant sid or unique name
     */
    autopilot(attributes: object, name: string): void;
    /**
     * <Conversation> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    conversation(attributes?: VoiceResponse.ConversationAttributes): void;
    /**
     * <Room> TwiML Noun
     *
     * @param name - Room name
     */
    room(name: string): void;
    /**
     * <Room> TwiML Noun
     *
     * @param attributes - TwiML attributes
     * @param name - Room name
     */
    room(attributes: VoiceResponse.RoomAttributes, name: string): void;
    /**
     * <Stream> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    stream(attributes?: VoiceResponse.StreamAttributes): VoiceResponse.Stream;
    /**
     * <VirtualAgent> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    virtualAgent(attributes?: VoiceResponse.VirtualAgentAttributes): VoiceResponse.VirtualAgent;
  }


  class Dial {

    /**
     * <Client> TwiML Noun
     *
     * @param identity - Client identity
     */
    client(identity?: string): VoiceResponse.Client;
    /**
     * <Client> TwiML Noun
     *
     * @param attributes - TwiML attributes
     * @param identity - Client identity
     */
    client(attributes?: VoiceResponse.ClientAttributes, identity?: string): VoiceResponse.Client;
    /**
     * <Conference> TwiML Noun
     *
     * @param name - Conference name
     */
    conference(name: string): void;
    /**
     * <Conference> TwiML Noun
     *
     * @param attributes - TwiML attributes
     * @param name - Conference name
     */
    conference(attributes: VoiceResponse.ConferenceAttributes, name: string): void;
    /**
     * <Number> TwiML Noun
     *
     * @param phoneNumber - Phone Number to dial
     */
    number(phoneNumber: string): void;
    /**
     * <Number> TwiML Noun
     *
     * @param attributes - TwiML attributes
     * @param phoneNumber - Phone Number to dial
     */
    number(attributes: VoiceResponse.NumberAttributes, phoneNumber: string): void;
    /**
     * <Queue> TwiML Noun
     *
     * @param name - Queue name
     */
    queue(name: string): void;
    /**
     * <Queue> TwiML Noun
     *
     * @param attributes - TwiML attributes
     * @param name - Queue name
     */
    queue(attributes: VoiceResponse.QueueAttributes, name: string): void;
    /**
     * <Sim> TwiML Noun
     *
     * @param simSid - SIM SID
     */
    sim(simSid: string): void;
    /**
     * <Sim> TwiML Noun
     *
     * @param attributes - TwiML attributes
     * @param simSid - SIM SID
     */
    sim(attributes: object, simSid: string): void;
    /**
     * <Sip> TwiML Noun
     *
     * @param sipUrl - SIP URL
     */
    sip(sipUrl: string): void;
    /**
     * <Sip> TwiML Noun
     *
     * @param attributes - TwiML attributes
     * @param sipUrl - SIP URL
     */
    sip(attributes: VoiceResponse.SipAttributes, sipUrl: string): void;
  }


  class Enqueue {

    /**
     * <Task> TwiML Noun
     *
     * @param body - TaskRouter task attributes
     */
    task(body: string): void;
    /**
     * <Task> TwiML Noun
     *
     * @param attributes - TwiML attributes
     * @param body - TaskRouter task attributes
     */
    task(attributes: VoiceResponse.TaskAttributes, body: string): void;
  }


  class Gather {

    /**
     * <Pause> TwiML Verb
     *
     * @param attributes - TwiML attributes
     */
    pause(attributes?: VoiceResponse.PauseAttributes): void;
    /**
     * <Play> TwiML Verb
     *
     * @param url - Media URL
     */
    play(url?: string): void;
    /**
     * <Play> TwiML Verb
     *
     * @param attributes - TwiML attributes
     * @param url - Media URL
     */
    play(attributes?: VoiceResponse.PlayAttributes, url?: string): void;
    /**
     * <Say> TwiML Verb
     *
     * @param message - Message to say
     */
    say(message: string): VoiceResponse.Say;
    /**
     * <Say> TwiML Verb
     *
     * @param attributes - TwiML attributes
     * @param message - Message to say
     */
    say(attributes: VoiceResponse.SayAttributes, message: string): VoiceResponse.Say;
  }


  class Pay {

    /**
     * <Parameter> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    parameter(attributes?: VoiceResponse.ParameterAttributes): void;
    /**
     * <Prompt> Twiml Verb
     *
     * @param attributes - TwiML attributes
     */
    prompt(attributes?: VoiceResponse.PromptAttributes): VoiceResponse.Prompt;
  }


  class Prompt {

    /**
     * <Pause> TwiML Verb
     *
     * @param attributes - TwiML attributes
     */
    pause(attributes?: VoiceResponse.PauseAttributes): void;
    /**
     * <Play> TwiML Verb
     *
     * @param url - Media URL
     */
    play(url?: string): void;
    /**
     * <Play> TwiML Verb
     *
     * @param attributes - TwiML attributes
     * @param url - Media URL
     */
    play(attributes?: VoiceResponse.PlayAttributes, url?: string): void;
    /**
     * <Say> TwiML Verb
     *
     * @param message - Message to say
     */
    say(message: string): VoiceResponse.Say;
    /**
     * <Say> TwiML Verb
     *
     * @param attributes - TwiML attributes
     * @param message - Message to say
     */
    say(attributes: VoiceResponse.SayAttributes, message: string): VoiceResponse.Say;
  }


  class Refer {

    /**
     * <Sip> TwiML Noun used in <Refer>
     *
     * @param sipUrl - SIP URL
     */
    referSip(sipUrl: string): void;
    /**
     * <Sip> TwiML Noun used in <Refer>
     *
     * @param attributes - TwiML attributes
     * @param sipUrl - SIP URL
     */
    referSip(attributes: object, sipUrl: string): void;
    /**
     * <Sip> TwiML Noun used in <Refer>
     *
     * @param sipUrl - SIP URL
     */
    sip(sipUrl: string): void;
    /**
     * <Sip> TwiML Noun used in <Refer>
     *
     * @param attributes - TwiML attributes
     * @param sipUrl - SIP URL
     */
    sip(attributes: object, sipUrl: string): void;
  }


  class Say {

    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    break_(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    emphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    emphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param words - Words to speak
     */
    lang(words: string): VoiceResponse.SsmlLang;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    lang(attributes: VoiceResponse.SsmlLangAttributes, words: string): VoiceResponse.SsmlLang;
    /**
     * Adding a Pause Between Paragraphs in <Say>
     *
     * @param words - Words to speak
     */
    p(words: string): VoiceResponse.SsmlP;
    /**
     * Adding a Pause Between Paragraphs in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    p(attributes: object, words: string): VoiceResponse.SsmlP;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    phoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    phoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    prosody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    prosody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param words - Words to speak
     */
    s(words: string): VoiceResponse.SsmlS;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    s(attributes: object, words: string): VoiceResponse.SsmlS;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    sayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    sayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    ssmlBreak(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    ssmlEmphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    ssmlEmphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param words - Words to speak
     */
    ssmlLang(words: string): VoiceResponse.SsmlLang;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlLang(attributes: VoiceResponse.SsmlLangAttributes, words: string): VoiceResponse.SsmlLang;
    /**
     * Adding a Pause Between Paragraphs in <Say>
     *
     * @param words - Words to speak
     */
    ssmlP(words: string): VoiceResponse.SsmlP;
    /**
     * Adding a Pause Between Paragraphs in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlP(attributes: object, words: string): VoiceResponse.SsmlP;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    ssmlPhoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlPhoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    ssmlProsody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlProsody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param words - Words to speak
     */
    ssmlS(words: string): VoiceResponse.SsmlS;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlS(attributes: object, words: string): VoiceResponse.SsmlS;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    ssmlSayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    ssmlSayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    ssmlSub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    ssmlSub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param words - Words to speak
     */
    ssmlW(words: string): VoiceResponse.SsmlW;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlW(attributes: VoiceResponse.SsmlWAttributes, words: string): VoiceResponse.SsmlW;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    sub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    sub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param words - Words to speak
     */
    w(words: string): VoiceResponse.SsmlW;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    w(attributes: VoiceResponse.SsmlWAttributes, words: string): VoiceResponse.SsmlW;
  }


  class Siprec {

    /**
     * <Parameter> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    parameter(attributes?: VoiceResponse.ParameterAttributes): void;
  }


  class SsmlEmphasis {

    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    break_(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    emphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    emphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param words - Words to speak
     */
    lang(words: string): VoiceResponse.SsmlLang;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    lang(attributes: VoiceResponse.SsmlLangAttributes, words: string): VoiceResponse.SsmlLang;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    phoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    phoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    prosody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    prosody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    sayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    sayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    ssmlBreak(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    ssmlEmphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    ssmlEmphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param words - Words to speak
     */
    ssmlLang(words: string): VoiceResponse.SsmlLang;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlLang(attributes: VoiceResponse.SsmlLangAttributes, words: string): VoiceResponse.SsmlLang;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    ssmlPhoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlPhoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    ssmlProsody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlProsody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    ssmlSayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    ssmlSayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    ssmlSub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    ssmlSub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param words - Words to speak
     */
    ssmlW(words: string): VoiceResponse.SsmlW;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlW(attributes: VoiceResponse.SsmlWAttributes, words: string): VoiceResponse.SsmlW;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    sub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    sub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param words - Words to speak
     */
    w(words: string): VoiceResponse.SsmlW;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    w(attributes: VoiceResponse.SsmlWAttributes, words: string): VoiceResponse.SsmlW;
  }


  class SsmlLang {

    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    break_(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    emphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    emphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param words - Words to speak
     */
    lang(words: string): VoiceResponse.SsmlLang;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    lang(attributes: VoiceResponse.SsmlLangAttributes, words: string): VoiceResponse.SsmlLang;
    /**
     * Adding a Pause Between Paragraphs in <Say>
     *
     * @param words - Words to speak
     */
    p(words: string): VoiceResponse.SsmlP;
    /**
     * Adding a Pause Between Paragraphs in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    p(attributes: object, words: string): VoiceResponse.SsmlP;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    phoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    phoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    prosody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    prosody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param words - Words to speak
     */
    s(words: string): VoiceResponse.SsmlS;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    s(attributes: object, words: string): VoiceResponse.SsmlS;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    sayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    sayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    ssmlBreak(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    ssmlEmphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    ssmlEmphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param words - Words to speak
     */
    ssmlLang(words: string): VoiceResponse.SsmlLang;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlLang(attributes: VoiceResponse.SsmlLangAttributes, words: string): VoiceResponse.SsmlLang;
    /**
     * Adding a Pause Between Paragraphs in <Say>
     *
     * @param words - Words to speak
     */
    ssmlP(words: string): VoiceResponse.SsmlP;
    /**
     * Adding a Pause Between Paragraphs in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlP(attributes: object, words: string): VoiceResponse.SsmlP;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    ssmlPhoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlPhoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    ssmlProsody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlProsody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param words - Words to speak
     */
    ssmlS(words: string): VoiceResponse.SsmlS;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlS(attributes: object, words: string): VoiceResponse.SsmlS;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    ssmlSayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    ssmlSayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    ssmlSub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    ssmlSub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param words - Words to speak
     */
    ssmlW(words: string): VoiceResponse.SsmlW;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlW(attributes: VoiceResponse.SsmlWAttributes, words: string): VoiceResponse.SsmlW;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    sub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    sub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param words - Words to speak
     */
    w(words: string): VoiceResponse.SsmlW;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    w(attributes: VoiceResponse.SsmlWAttributes, words: string): VoiceResponse.SsmlW;
  }


  class SsmlP {

    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    break_(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    emphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    emphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param words - Words to speak
     */
    lang(words: string): VoiceResponse.SsmlLang;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    lang(attributes: VoiceResponse.SsmlLangAttributes, words: string): VoiceResponse.SsmlLang;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    phoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    phoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    prosody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    prosody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param words - Words to speak
     */
    s(words: string): VoiceResponse.SsmlS;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    s(attributes: object, words: string): VoiceResponse.SsmlS;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    sayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    sayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    ssmlBreak(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    ssmlEmphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    ssmlEmphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param words - Words to speak
     */
    ssmlLang(words: string): VoiceResponse.SsmlLang;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlLang(attributes: VoiceResponse.SsmlLangAttributes, words: string): VoiceResponse.SsmlLang;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    ssmlPhoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlPhoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    ssmlProsody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlProsody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param words - Words to speak
     */
    ssmlS(words: string): VoiceResponse.SsmlS;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlS(attributes: object, words: string): VoiceResponse.SsmlS;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    ssmlSayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    ssmlSayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    ssmlSub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    ssmlSub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param words - Words to speak
     */
    ssmlW(words: string): VoiceResponse.SsmlW;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlW(attributes: VoiceResponse.SsmlWAttributes, words: string): VoiceResponse.SsmlW;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    sub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    sub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param words - Words to speak
     */
    w(words: string): VoiceResponse.SsmlW;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    w(attributes: VoiceResponse.SsmlWAttributes, words: string): VoiceResponse.SsmlW;
  }


  class SsmlProsody {

    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    break_(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    emphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    emphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param words - Words to speak
     */
    lang(words: string): VoiceResponse.SsmlLang;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    lang(attributes: VoiceResponse.SsmlLangAttributes, words: string): VoiceResponse.SsmlLang;
    /**
     * Adding a Pause Between Paragraphs in <Say>
     *
     * @param words - Words to speak
     */
    p(words: string): VoiceResponse.SsmlP;
    /**
     * Adding a Pause Between Paragraphs in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    p(attributes: object, words: string): VoiceResponse.SsmlP;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    phoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    phoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    prosody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    prosody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param words - Words to speak
     */
    s(words: string): VoiceResponse.SsmlS;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    s(attributes: object, words: string): VoiceResponse.SsmlS;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    sayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    sayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    ssmlBreak(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    ssmlEmphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    ssmlEmphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param words - Words to speak
     */
    ssmlLang(words: string): VoiceResponse.SsmlLang;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlLang(attributes: VoiceResponse.SsmlLangAttributes, words: string): VoiceResponse.SsmlLang;
    /**
     * Adding a Pause Between Paragraphs in <Say>
     *
     * @param words - Words to speak
     */
    ssmlP(words: string): VoiceResponse.SsmlP;
    /**
     * Adding a Pause Between Paragraphs in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlP(attributes: object, words: string): VoiceResponse.SsmlP;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    ssmlPhoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlPhoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    ssmlProsody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlProsody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param words - Words to speak
     */
    ssmlS(words: string): VoiceResponse.SsmlS;
    /**
     * Adding A Pause Between Sentences in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlS(attributes: object, words: string): VoiceResponse.SsmlS;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    ssmlSayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    ssmlSayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    ssmlSub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    ssmlSub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param words - Words to speak
     */
    ssmlW(words: string): VoiceResponse.SsmlW;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlW(attributes: VoiceResponse.SsmlWAttributes, words: string): VoiceResponse.SsmlW;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    sub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    sub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param words - Words to speak
     */
    w(words: string): VoiceResponse.SsmlW;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    w(attributes: VoiceResponse.SsmlWAttributes, words: string): VoiceResponse.SsmlW;
  }


  class SsmlS {

    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    break_(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    emphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    emphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param words - Words to speak
     */
    lang(words: string): VoiceResponse.SsmlLang;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    lang(attributes: VoiceResponse.SsmlLangAttributes, words: string): VoiceResponse.SsmlLang;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    phoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    phoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    prosody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    prosody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    sayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    sayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    ssmlBreak(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    ssmlEmphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    ssmlEmphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param words - Words to speak
     */
    ssmlLang(words: string): VoiceResponse.SsmlLang;
    /**
     * Specifying Another Language for Specific Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlLang(attributes: VoiceResponse.SsmlLangAttributes, words: string): VoiceResponse.SsmlLang;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    ssmlPhoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlPhoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    ssmlProsody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlProsody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    ssmlSayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    ssmlSayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    ssmlSub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    ssmlSub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param words - Words to speak
     */
    ssmlW(words: string): VoiceResponse.SsmlW;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlW(attributes: VoiceResponse.SsmlWAttributes, words: string): VoiceResponse.SsmlW;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    sub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    sub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param words - Words to speak
     */
    w(words: string): VoiceResponse.SsmlW;
    /**
     * Improving Pronunciation by Specifying Parts of Speech in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    w(attributes: VoiceResponse.SsmlWAttributes, words: string): VoiceResponse.SsmlW;
  }


  class SsmlW {

    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    break_(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    emphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    emphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    phoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    phoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    prosody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    prosody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    sayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    sayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Adding a Pause in <Say>
     *
     * @param attributes - TwiML attributes
     */
    ssmlBreak(attributes?: VoiceResponse.SsmlBreakAttributes): void;
    /**
     * Emphasizing Words in <Say>
     *
     * @param words - Words to emphasize
     */
    ssmlEmphasis(words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Emphasizing Words in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to emphasize
     */
    ssmlEmphasis(attributes: VoiceResponse.SsmlEmphasisAttributes, words: string): VoiceResponse.SsmlEmphasis;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param words - Words to speak
     */
    ssmlPhoneme(words: string): void;
    /**
     * Using Phonetic Pronunciation in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlPhoneme(attributes: VoiceResponse.SsmlPhonemeAttributes, words: string): void;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param words - Words to speak
     */
    ssmlProsody(words: string): VoiceResponse.SsmlProsody;
    /**
     * Controling Volume, Speaking Rate, and Pitch in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to speak
     */
    ssmlProsody(attributes: VoiceResponse.SsmlProsodyAttributes, words: string): VoiceResponse.SsmlProsody;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param words - Words to be interpreted
     */
    ssmlSayAs(words: string): void;
    /**
     * Controlling How Special Types of Words Are Spoken in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be interpreted
     */
    ssmlSayAs(attributes: VoiceResponse.SsmlSayAsAttributes, words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    ssmlSub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    ssmlSub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param words - Words to be substituted
     */
    sub(words: string): void;
    /**
     * Pronouncing Acronyms and Abbreviations in <Say>
     *
     * @param attributes - TwiML attributes
     * @param words - Words to be substituted
     */
    sub(attributes: VoiceResponse.SsmlSubAttributes, words: string): void;
  }


  class Start {

    /**
     * <Siprec> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    siprec(attributes?: VoiceResponse.SiprecAttributes): VoiceResponse.Siprec;
    /**
     * <Stream> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    stream(attributes?: VoiceResponse.StreamAttributes): VoiceResponse.Stream;
  }


  class Stop {

    /**
     * <Siprec> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    siprec(attributes?: VoiceResponse.SiprecAttributes): VoiceResponse.Siprec;
    /**
     * <Stream> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    stream(attributes?: VoiceResponse.StreamAttributes): VoiceResponse.Stream;
  }


  class Stream {

    /**
     * <Parameter> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    parameter(attributes?: VoiceResponse.ParameterAttributes): void;
  }


  class VirtualAgent {

    /**
     * <Config> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    config(attributes?: VoiceResponse.ConfigAttributes): void;
    /**
     * <Parameter> TwiML Noun
     *
     * @param attributes - TwiML attributes
     */
    parameter(attributes?: VoiceResponse.ParameterAttributes): void;
  }
}

export = VoiceResponse;
