/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the TrustProductsChannelEndpointAssignmentList
 *
 * @param version - Version of the resource
 * @param trustProductSid - The unique string that identifies the CustomerProfile resource.
 */
declare function TrustProductsChannelEndpointAssignmentList(version: V1, trustProductSid: string): TrustProductsChannelEndpointAssignmentListInstance;

interface TrustProductsChannelEndpointAssignmentListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): TrustProductsChannelEndpointAssignmentContext;
  /**
   * create a TrustProductsChannelEndpointAssignmentInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: TrustProductsChannelEndpointAssignmentListInstanceCreateOptions, callback?: (error: Error | null, item: TrustProductsChannelEndpointAssignmentInstance) => any): Promise<TrustProductsChannelEndpointAssignmentInstance>;
  /**
   * Streams TrustProductsChannelEndpointAssignmentInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: TrustProductsChannelEndpointAssignmentInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams TrustProductsChannelEndpointAssignmentInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: TrustProductsChannelEndpointAssignmentListInstanceEachOptions, callback?: (item: TrustProductsChannelEndpointAssignmentInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a trust_products_channel_endpoint_assignment
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): TrustProductsChannelEndpointAssignmentContext;
  /**
   * Retrieve a single target page of TrustProductsChannelEndpointAssignmentInstance
   * records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: TrustProductsChannelEndpointAssignmentPage) => any): Promise<TrustProductsChannelEndpointAssignmentPage>;
  /**
   * Retrieve a single target page of TrustProductsChannelEndpointAssignmentInstance
   * records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: TrustProductsChannelEndpointAssignmentPage) => any): Promise<TrustProductsChannelEndpointAssignmentPage>;
  /**
   * Lists TrustProductsChannelEndpointAssignmentInstance records from the API as a
   * list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: TrustProductsChannelEndpointAssignmentInstance[]) => any): Promise<TrustProductsChannelEndpointAssignmentInstance[]>;
  /**
   * Lists TrustProductsChannelEndpointAssignmentInstance records from the API as a
   * list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: TrustProductsChannelEndpointAssignmentListInstanceOptions, callback?: (error: Error | null, items: TrustProductsChannelEndpointAssignmentInstance[]) => any): Promise<TrustProductsChannelEndpointAssignmentInstance[]>;
  /**
   * Retrieve a single page of TrustProductsChannelEndpointAssignmentInstance records
   * from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: TrustProductsChannelEndpointAssignmentPage) => any): Promise<TrustProductsChannelEndpointAssignmentPage>;
  /**
   * Retrieve a single page of TrustProductsChannelEndpointAssignmentInstance records
   * from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: TrustProductsChannelEndpointAssignmentListInstancePageOptions, callback?: (error: Error | null, items: TrustProductsChannelEndpointAssignmentPage) => any): Promise<TrustProductsChannelEndpointAssignmentPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property channelEndpointSid - The sid of an channel endpoint
 * @property channelEndpointType - The type of channel endpoint
 */
interface TrustProductsChannelEndpointAssignmentListInstanceCreateOptions {
  channelEndpointSid: string;
  channelEndpointType: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property channelEndpointSid - The sid of an channel endpoint
 * @property channelEndpointSids - comma separated list of channel endpoint sids
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface TrustProductsChannelEndpointAssignmentListInstanceEachOptions {
  callback?: (item: TrustProductsChannelEndpointAssignmentInstance, done: (err?: Error) => void) => void;
  channelEndpointSid?: string;
  channelEndpointSids?: string;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property channelEndpointSid - The sid of an channel endpoint
 * @property channelEndpointSids - comma separated list of channel endpoint sids
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface TrustProductsChannelEndpointAssignmentListInstanceOptions {
  channelEndpointSid?: string;
  channelEndpointSids?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property channelEndpointSid - The sid of an channel endpoint
 * @property channelEndpointSids - comma separated list of channel endpoint sids
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface TrustProductsChannelEndpointAssignmentListInstancePageOptions {
  channelEndpointSid?: string;
  channelEndpointSids?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface TrustProductsChannelEndpointAssignmentPayload extends TrustProductsChannelEndpointAssignmentResource, Page.TwilioResponsePayload {
}

interface TrustProductsChannelEndpointAssignmentResource {
  account_sid: string;
  channel_endpoint_sid: string;
  channel_endpoint_type: string;
  date_created: Date;
  sid: string;
  trust_product_sid: string;
  url: string;
}

interface TrustProductsChannelEndpointAssignmentSolution {
  trustProductSid?: string;
}


declare class TrustProductsChannelEndpointAssignmentContext {
  /**
   * Initialize the TrustProductsChannelEndpointAssignmentContext
   *
   * @param version - Version of the resource
   * @param trustProductSid - The unique string that identifies the resource.
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, trustProductSid: string, sid: string);

  /**
   * fetch a TrustProductsChannelEndpointAssignmentInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TrustProductsChannelEndpointAssignmentInstance) => any): Promise<TrustProductsChannelEndpointAssignmentInstance>;
  /**
   * remove a TrustProductsChannelEndpointAssignmentInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: TrustProductsChannelEndpointAssignmentInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class TrustProductsChannelEndpointAssignmentInstance extends SerializableClass {
  /**
   * Initialize the TrustProductsChannelEndpointAssignmentContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param trustProductSid - The unique string that identifies the CustomerProfile resource.
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: TrustProductsChannelEndpointAssignmentPayload, trustProductSid: string, sid: string);

  private _proxy: TrustProductsChannelEndpointAssignmentContext;
  accountSid: string;
  channelEndpointSid: string;
  channelEndpointType: string;
  dateCreated: Date;
  /**
   * fetch a TrustProductsChannelEndpointAssignmentInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: TrustProductsChannelEndpointAssignmentInstance) => any): Promise<TrustProductsChannelEndpointAssignmentInstance>;
  /**
   * remove a TrustProductsChannelEndpointAssignmentInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: TrustProductsChannelEndpointAssignmentInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  trustProductSid: string;
  url: string;
}


declare class TrustProductsChannelEndpointAssignmentPage extends Page<V1, TrustProductsChannelEndpointAssignmentPayload, TrustProductsChannelEndpointAssignmentResource, TrustProductsChannelEndpointAssignmentInstance> {
  /**
   * Initialize the TrustProductsChannelEndpointAssignmentPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: TrustProductsChannelEndpointAssignmentSolution);

  /**
   * Build an instance of TrustProductsChannelEndpointAssignmentInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: TrustProductsChannelEndpointAssignmentPayload): TrustProductsChannelEndpointAssignmentInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { TrustProductsChannelEndpointAssignmentContext, TrustProductsChannelEndpointAssignmentInstance, TrustProductsChannelEndpointAssignmentList, TrustProductsChannelEndpointAssignmentListInstance, TrustProductsChannelEndpointAssignmentListInstanceCreateOptions, TrustProductsChannelEndpointAssignmentListInstanceEachOptions, TrustProductsChannelEndpointAssignmentListInstanceOptions, TrustProductsChannelEndpointAssignmentListInstancePageOptions, TrustProductsChannelEndpointAssignmentPage, TrustProductsChannelEndpointAssignmentPayload, TrustProductsChannelEndpointAssignmentResource, TrustProductsChannelEndpointAssignmentSolution }
