"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.InsightsQuestionnairesCategoryListInstance = exports.InsightsQuestionnairesCategoryInstance = exports.InsightsQuestionnairesCategoryContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
class InsightsQuestionnairesCategoryContextImpl {
    constructor(_version, categoryId) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(categoryId)) {
            throw new Error("Parameter 'categoryId' is not valid.");
        }
        this._solution = { categoryId };
        this._uri = `/Insights/QM/Categories/${categoryId}`;
    }
    remove(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        const headers = {};
        if (params["token"] !== undefined)
            headers["Token"] = params["token"];
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
            params: data,
            headers,
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    update(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["name"] === null || params["name"] === undefined) {
            throw new Error("Required parameter \"params['name']\" missing.");
        }
        let data = {};
        data["Name"] = params["name"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        if (params["token"] !== undefined)
            headers["Token"] = params["token"];
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new InsightsQuestionnairesCategoryInstance(operationVersion, payload, instance._solution.categoryId));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.InsightsQuestionnairesCategoryContextImpl = InsightsQuestionnairesCategoryContextImpl;
class InsightsQuestionnairesCategoryInstance {
    constructor(_version, payload, categoryId) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.categoryId = payload.category_id;
        this.name = payload.name;
        this.url = payload.url;
        this._solution = { categoryId: categoryId || this.categoryId };
    }
    get _proxy() {
        this._context =
            this._context ||
                new InsightsQuestionnairesCategoryContextImpl(this._version, this._solution.categoryId);
        return this._context;
    }
    remove(params, callback) {
        return this._proxy.remove(params, callback);
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            categoryId: this.categoryId,
            name: this.name,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.InsightsQuestionnairesCategoryInstance = InsightsQuestionnairesCategoryInstance;
function InsightsQuestionnairesCategoryListInstance(version) {
    const instance = ((categoryId) => instance.get(categoryId));
    instance.get = function get(categoryId) {
        return new InsightsQuestionnairesCategoryContextImpl(version, categoryId);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = `/Insights/QM/Categories`;
    instance.create = function create(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["name"] === null || params["name"] === undefined) {
            throw new Error("Required parameter \"params['name']\" missing.");
        }
        let data = {};
        data["Name"] = params["name"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        if (params["token"] !== undefined)
            headers["Token"] = params["token"];
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new InsightsQuestionnairesCategoryInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.InsightsQuestionnairesCategoryListInstance = InsightsQuestionnairesCategoryListInstance;
