"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.InsightsQuestionnairesQuestionListInstance = exports.InsightsQuestionnairesQuestionInstance = exports.InsightsQuestionnairesQuestionContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
class InsightsQuestionnairesQuestionContextImpl {
    constructor(_version, questionId) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(questionId)) {
            throw new Error("Parameter 'questionId' is not valid.");
        }
        this._solution = { questionId };
        this._uri = `/Insights/QM/Questions/${questionId}`;
    }
    remove(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        const headers = {};
        if (params["token"] !== undefined)
            headers["Token"] = params["token"];
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
            params: data,
            headers,
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    update(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["question"] === null || params["question"] === undefined) {
            throw new Error("Required parameter \"params['question']\" missing.");
        }
        if (params["description"] === null || params["description"] === undefined) {
            throw new Error("Required parameter \"params['description']\" missing.");
        }
        if (params["answerSetId"] === null || params["answerSetId"] === undefined) {
            throw new Error("Required parameter \"params['answerSetId']\" missing.");
        }
        if (params["allowNa"] === null || params["allowNa"] === undefined) {
            throw new Error("Required parameter \"params['allowNa']\" missing.");
        }
        let data = {};
        data["Question"] = params["question"];
        data["Description"] = params["description"];
        data["AnswerSetId"] = params["answerSetId"];
        data["AllowNa"] = serialize.bool(params["allowNa"]);
        if (params["categoryId"] !== undefined)
            data["CategoryId"] = params["categoryId"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        if (params["token"] !== undefined)
            headers["Token"] = params["token"];
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new InsightsQuestionnairesQuestionInstance(operationVersion, payload, instance._solution.questionId));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.InsightsQuestionnairesQuestionContextImpl = InsightsQuestionnairesQuestionContextImpl;
class InsightsQuestionnairesQuestionInstance {
    constructor(_version, payload, questionId) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.questionId = payload.question_id;
        this.question = payload.question;
        this.description = payload.description;
        this.category = payload.category;
        this.answerSetId = payload.answer_set_id;
        this.allowNa = payload.allow_na;
        this.url = payload.url;
        this._solution = { questionId: questionId || this.questionId };
    }
    get _proxy() {
        this._context =
            this._context ||
                new InsightsQuestionnairesQuestionContextImpl(this._version, this._solution.questionId);
        return this._context;
    }
    remove(params, callback) {
        return this._proxy.remove(params, callback);
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            questionId: this.questionId,
            question: this.question,
            description: this.description,
            category: this.category,
            answerSetId: this.answerSetId,
            allowNa: this.allowNa,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.InsightsQuestionnairesQuestionInstance = InsightsQuestionnairesQuestionInstance;
function InsightsQuestionnairesQuestionListInstance(version) {
    const instance = ((questionId) => instance.get(questionId));
    instance.get = function get(questionId) {
        return new InsightsQuestionnairesQuestionContextImpl(version, questionId);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = `/Insights/QM/Questions`;
    instance.create = function create(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["categoryId"] === null || params["categoryId"] === undefined) {
            throw new Error("Required parameter \"params['categoryId']\" missing.");
        }
        if (params["question"] === null || params["question"] === undefined) {
            throw new Error("Required parameter \"params['question']\" missing.");
        }
        if (params["description"] === null || params["description"] === undefined) {
            throw new Error("Required parameter \"params['description']\" missing.");
        }
        if (params["answerSetId"] === null || params["answerSetId"] === undefined) {
            throw new Error("Required parameter \"params['answerSetId']\" missing.");
        }
        if (params["allowNa"] === null || params["allowNa"] === undefined) {
            throw new Error("Required parameter \"params['allowNa']\" missing.");
        }
        let data = {};
        data["CategoryId"] = params["categoryId"];
        data["Question"] = params["question"];
        data["Description"] = params["description"];
        data["AnswerSetId"] = params["answerSetId"];
        data["AllowNa"] = serialize.bool(params["allowNa"]);
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        if (params["token"] !== undefined)
            headers["Token"] = params["token"];
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new InsightsQuestionnairesQuestionInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.InsightsQuestionnairesQuestionListInstance = InsightsQuestionnairesQuestionListInstance;
