"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Preview
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.StyleSheetListInstance = exports.StyleSheetInstance = exports.StyleSheetContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../../base/deserialize");
const serialize = require("../../../../base/serialize");
const utility_1 = require("../../../../base/utility");
class StyleSheetContextImpl {
    constructor(_version, assistantSid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(assistantSid)) {
            throw new Error("Parameter 'assistantSid' is not valid.");
        }
        this._solution = { assistantSid };
        this._uri = `/Assistants/${assistantSid}/StyleSheet`;
    }
    fetch(callback) {
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
        });
        operationPromise = operationPromise.then((payload) => new StyleSheetInstance(operationVersion, payload, instance._solution.assistantSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    update(params, callback) {
        if (params instanceof Function) {
            callback = params;
            params = {};
        }
        else {
            params = params || {};
        }
        let data = {};
        if (params["styleSheet"] !== undefined)
            data["StyleSheet"] = serialize.object(params["styleSheet"]);
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new StyleSheetInstance(operationVersion, payload, instance._solution.assistantSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.StyleSheetContextImpl = StyleSheetContextImpl;
class StyleSheetInstance {
    constructor(_version, payload, assistantSid) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.assistantSid = payload.assistant_sid;
        this.url = payload.url;
        this.data = payload.data;
        this._solution = { assistantSid };
    }
    get _proxy() {
        this._context =
            this._context ||
                new StyleSheetContextImpl(this._version, this._solution.assistantSid);
        return this._context;
    }
    /**
     * Fetch a StyleSheetInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed StyleSheetInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            assistantSid: this.assistantSid,
            url: this.url,
            data: this.data,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.StyleSheetInstance = StyleSheetInstance;
function StyleSheetListInstance(version, assistantSid) {
    if (!(0, utility_1.isValidPathParam)(assistantSid)) {
        throw new Error("Parameter 'assistantSid' is not valid.");
    }
    const instance = (() => instance.get());
    instance.get = function get() {
        return new StyleSheetContextImpl(version, assistantSid);
    };
    instance._version = version;
    instance._solution = { assistantSid };
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.StyleSheetListInstance = StyleSheetListInstance;
