/// <reference types="node" />
import { inspect, InspectOptions } from "util";
import V1 from "../V1";
/**
 * Options to pass to fetch a InsightsSegmentsInstance
 */
export interface InsightsSegmentsContextFetchOptions {
    /** The Token HTTP request header */
    token?: string;
}
export interface InsightsSegmentsContext {
    /**
     * Fetch a InsightsSegmentsInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed InsightsSegmentsInstance
     */
    fetch(callback?: (error: Error | null, item?: InsightsSegmentsInstance) => any): Promise<InsightsSegmentsInstance>;
    /**
     * Fetch a InsightsSegmentsInstance
     *
     * @param params - Parameter for request
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed InsightsSegmentsInstance
     */
    fetch(params: InsightsSegmentsContextFetchOptions, callback?: (error: Error | null, item?: InsightsSegmentsInstance) => any): Promise<InsightsSegmentsInstance>;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export interface InsightsSegmentsContextSolution {
    segmentId: string;
}
export declare class InsightsSegmentsContextImpl implements InsightsSegmentsContext {
    protected _version: V1;
    protected _solution: InsightsSegmentsContextSolution;
    protected _uri: string;
    constructor(_version: V1, segmentId: string);
    fetch(params?: InsightsSegmentsContextFetchOptions | ((error: Error | null, item?: InsightsSegmentsInstance) => any), callback?: (error: Error | null, item?: InsightsSegmentsInstance) => any): Promise<InsightsSegmentsInstance>;
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON(): InsightsSegmentsContextSolution;
    [inspect.custom](_depth: any, options: InspectOptions): string;
}
interface InsightsSegmentsResource {
    segment_id: string;
    external_id: string;
    queue: string;
    external_contact: string;
    external_segment_link_id: string;
    date: string;
    account_id: string;
    external_segment_link: string;
    agent_id: string;
    agent_phone: string;
    agent_name: string;
    agent_team_name: string;
    agent_team_name_in_hierarchy: string;
    agent_link: string;
    customer_phone: string;
    customer_name: string;
    customer_link: string;
    segment_recording_offset: string;
    media: string;
    assessment_type: any;
    assessment_percentage: any;
    url: string;
}
export declare class InsightsSegmentsInstance {
    protected _version: V1;
    protected _solution: InsightsSegmentsContextSolution;
    protected _context?: InsightsSegmentsContext;
    constructor(_version: V1, payload: InsightsSegmentsResource, segmentId?: string);
    /**
     * To unique id of the segment
     */
    segmentId: string;
    /**
     * The unique id for the conversation.
     */
    externalId: string;
    queue: string;
    externalContact: string;
    /**
     * The uuid for the external_segment_link.
     */
    externalSegmentLinkId: string;
    /**
     * The date of the conversation.
     */
    date: string;
    /**
     * The unique id for the account.
     */
    accountId: string;
    /**
     * The hyperlink to recording of the task event.
     */
    externalSegmentLink: string;
    /**
     * The unique id for the agent.
     */
    agentId: string;
    /**
     * The phone number of the agent.
     */
    agentPhone: string;
    /**
     * The name of the agent.
     */
    agentName: string;
    /**
     * The team name to which agent belongs.
     */
    agentTeamName: string;
    /**
     * he team name to which agent belongs.
     */
    agentTeamNameInHierarchy: string;
    /**
     * The link to the agent conversation.
     */
    agentLink: string;
    /**
     * The phone number of the customer.
     */
    customerPhone: string;
    /**
     * The name of the customer.
     */
    customerName: string;
    /**
     * The link to the customer conversation.
     */
    customerLink: string;
    /**
     * The offset value for the recording.
     */
    segmentRecordingOffset: string;
    /**
     * The link for the conversation.
     */
    media: string;
    /**
     * The type of the assessment.
     */
    assessmentType: any;
    /**
     * The percentage scored on the Assessments.
     */
    assessmentPercentage: any;
    url: string;
    private get _proxy();
    /**
     * Fetch a InsightsSegmentsInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed InsightsSegmentsInstance
     */
    fetch(callback?: (error: Error | null, item?: InsightsSegmentsInstance) => any): Promise<InsightsSegmentsInstance>;
    /**
     * Fetch a InsightsSegmentsInstance
     *
     * @param params - Parameter for request
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed InsightsSegmentsInstance
     */
    fetch(params: InsightsSegmentsContextFetchOptions, callback?: (error: Error | null, item?: InsightsSegmentsInstance) => any): Promise<InsightsSegmentsInstance>;
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON(): {
        segmentId: string;
        externalId: string;
        queue: string;
        externalContact: string;
        externalSegmentLinkId: string;
        date: string;
        accountId: string;
        externalSegmentLink: string;
        agentId: string;
        agentPhone: string;
        agentName: string;
        agentTeamName: string;
        agentTeamNameInHierarchy: string;
        agentLink: string;
        customerPhone: string;
        customerName: string;
        customerLink: string;
        segmentRecordingOffset: string;
        media: string;
        assessmentType: any;
        assessmentPercentage: any;
        url: string;
    };
    [inspect.custom](_depth: any, options: InspectOptions): string;
}
export interface InsightsSegmentsSolution {
}
export interface InsightsSegmentsListInstance {
    _version: V1;
    _solution: InsightsSegmentsSolution;
    _uri: string;
    (segmentId: string): InsightsSegmentsContext;
    get(segmentId: string): InsightsSegmentsContext;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export declare function InsightsSegmentsListInstance(version: V1): InsightsSegmentsListInstance;
export {};
