"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssessmentsListInstance = exports.AssessmentsInstance = exports.AssessmentsContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
class AssessmentsContextImpl {
    constructor(_version, assessmentId) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(assessmentId)) {
            throw new Error("Parameter 'assessmentId' is not valid.");
        }
        this._solution = { assessmentId };
        this._uri = `/Insights/QM/Assessments/${assessmentId}`;
    }
    update(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["offset"] === null || params["offset"] === undefined) {
            throw new Error("Required parameter \"params['offset']\" missing.");
        }
        if (params["answerText"] === null || params["answerText"] === undefined) {
            throw new Error("Required parameter \"params['answerText']\" missing.");
        }
        if (params["answerId"] === null || params["answerId"] === undefined) {
            throw new Error("Required parameter \"params['answerId']\" missing.");
        }
        let data = {};
        data["Offset"] = params["offset"];
        data["AnswerText"] = params["answerText"];
        data["AnswerId"] = params["answerId"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        if (params["token"] !== undefined)
            headers["Token"] = params["token"];
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.update({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new AssessmentsInstance(operationVersion, payload, instance._solution.assessmentId));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssessmentsContextImpl = AssessmentsContextImpl;
class AssessmentsInstance {
    constructor(_version, payload, assessmentId) {
        this._version = _version;
        this.accountSid = payload.account_sid;
        this.assessmentId = payload.assessment_id;
        this.offset = payload.offset;
        this.report = payload.report;
        this.weight = payload.weight;
        this.agentId = payload.agent_id;
        this.segmentId = payload.segment_id;
        this.userName = payload.user_name;
        this.userEmail = payload.user_email;
        this.answerText = payload.answer_text;
        this.answerId = payload.answer_id;
        this.assessment = payload.assessment;
        this.timestamp = payload.timestamp;
        this.url = payload.url;
        this._solution = { assessmentId: assessmentId || this.assessmentId };
    }
    get _proxy() {
        this._context =
            this._context ||
                new AssessmentsContextImpl(this._version, this._solution.assessmentId);
        return this._context;
    }
    update(params, callback) {
        return this._proxy.update(params, callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            accountSid: this.accountSid,
            assessmentId: this.assessmentId,
            offset: this.offset,
            report: this.report,
            weight: this.weight,
            agentId: this.agentId,
            segmentId: this.segmentId,
            userName: this.userName,
            userEmail: this.userEmail,
            answerText: this.answerText,
            answerId: this.answerId,
            assessment: this.assessment,
            timestamp: this.timestamp,
            url: this.url,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.AssessmentsInstance = AssessmentsInstance;
function AssessmentsListInstance(version) {
    const instance = ((assessmentId) => instance.get(assessmentId));
    instance.get = function get(assessmentId) {
        return new AssessmentsContextImpl(version, assessmentId);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = `/Insights/QM/Assessments`;
    instance.create = function create(params, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        if (params["categoryId"] === null || params["categoryId"] === undefined) {
            throw new Error("Required parameter \"params['categoryId']\" missing.");
        }
        if (params["categoryName"] === null ||
            params["categoryName"] === undefined) {
            throw new Error("Required parameter \"params['categoryName']\" missing.");
        }
        if (params["segmentId"] === null || params["segmentId"] === undefined) {
            throw new Error("Required parameter \"params['segmentId']\" missing.");
        }
        if (params["userName"] === null || params["userName"] === undefined) {
            throw new Error("Required parameter \"params['userName']\" missing.");
        }
        if (params["userEmail"] === null || params["userEmail"] === undefined) {
            throw new Error("Required parameter \"params['userEmail']\" missing.");
        }
        if (params["agentId"] === null || params["agentId"] === undefined) {
            throw new Error("Required parameter \"params['agentId']\" missing.");
        }
        if (params["offset"] === null || params["offset"] === undefined) {
            throw new Error("Required parameter \"params['offset']\" missing.");
        }
        if (params["metricId"] === null || params["metricId"] === undefined) {
            throw new Error("Required parameter \"params['metricId']\" missing.");
        }
        if (params["metricName"] === null || params["metricName"] === undefined) {
            throw new Error("Required parameter \"params['metricName']\" missing.");
        }
        if (params["answerText"] === null || params["answerText"] === undefined) {
            throw new Error("Required parameter \"params['answerText']\" missing.");
        }
        if (params["answerId"] === null || params["answerId"] === undefined) {
            throw new Error("Required parameter \"params['answerId']\" missing.");
        }
        if (params["questionnaireId"] === null ||
            params["questionnaireId"] === undefined) {
            throw new Error("Required parameter \"params['questionnaireId']\" missing.");
        }
        let data = {};
        data["CategoryId"] = params["categoryId"];
        data["CategoryName"] = params["categoryName"];
        data["SegmentId"] = params["segmentId"];
        data["UserName"] = params["userName"];
        data["UserEmail"] = params["userEmail"];
        data["AgentId"] = params["agentId"];
        data["Offset"] = params["offset"];
        data["MetricId"] = params["metricId"];
        data["MetricName"] = params["metricName"];
        data["AnswerText"] = params["answerText"];
        data["AnswerId"] = params["answerId"];
        data["QuestionnaireId"] = params["questionnaireId"];
        const headers = {};
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        if (params["token"] !== undefined)
            headers["Token"] = params["token"];
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new AssessmentsInstance(operationVersion, payload));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.AssessmentsListInstance = AssessmentsListInstance;
