"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var events_1 = require("events");
var device_1 = require("./device");
var usb = require("./bindings");
if (usb.INIT_ERROR) {
    /* eslint-disable no-console */
    console.warn('Failed to initialize libusb.');
}
Object.setPrototypeOf(usb, events_1.EventEmitter.prototype);
Object.getOwnPropertyNames(device_1.ExtendedDevice.prototype).forEach(function (name) {
    Object.defineProperty(usb.Device.prototype, name, Object.getOwnPropertyDescriptor(device_1.ExtendedDevice.prototype, name) || Object.create(null));
});
// Hotplug support
var hotplugSupported = usb._supportedHotplugEvents();
// Devices delta support for non-libusb hotplug events
// This methd needs to be used for attach/detach IDs (hotplugSupportType === 2) rather than a lookup because vid/pid are not unique
var hotPlugDevices = new Set();
var emitHotplugEvents = function () {
    var e_1, _a, e_2, _b;
    // Collect current devices
    var devices = new Set(usb.getDeviceList());
    try {
        // Find attached devices
        for (var devices_1 = __values(devices), devices_1_1 = devices_1.next(); !devices_1_1.done; devices_1_1 = devices_1.next()) {
            var device = devices_1_1.value;
            if (!hotPlugDevices.has(device)) {
                usb.emit('attach', device);
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (devices_1_1 && !devices_1_1.done && (_a = devices_1.return)) _a.call(devices_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    try {
        // Find detached devices
        for (var hotPlugDevices_1 = __values(hotPlugDevices), hotPlugDevices_1_1 = hotPlugDevices_1.next(); !hotPlugDevices_1_1.done; hotPlugDevices_1_1 = hotPlugDevices_1.next()) {
            var device = hotPlugDevices_1_1.value;
            if (!devices.has(device)) {
                usb.emit('detach', device);
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (hotPlugDevices_1_1 && !hotPlugDevices_1_1.done && (_b = hotPlugDevices_1.return)) _b.call(hotPlugDevices_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    hotPlugDevices = devices;
};
// Polling mechanism for checking device changes where hotplug detection is not available
var pollingHotplug = false;
var pollHotplug = function (start) {
    if (start === void 0) { start = false; }
    if (start) {
        pollingHotplug = true;
    }
    else if (!pollingHotplug) {
        return;
    }
    else {
        emitHotplugEvents();
    }
    setTimeout(function () { return pollHotplug(); }, 500);
};
// Hotplug control
var startHotplug = function () {
    if (hotplugSupported !== 1) {
        // Collect initial devices when not using libusb
        hotPlugDevices = new Set(usb.getDeviceList());
    }
    if (hotplugSupported) {
        // Use hotplug event emitters
        usb._enableHotplugEvents();
        if (hotplugSupported === 2) {
            // Use hotplug ID events to trigger a change check
            usb.on('attachIds', emitHotplugEvents);
            usb.on('detachIds', emitHotplugEvents);
        }
    }
    else {
        // Fallback to using polling to check for changes
        pollHotplug(true);
    }
};
var stopHotplug = function () {
    if (hotplugSupported) {
        // Disable hotplug events
        usb._disableHotplugEvents();
        if (hotplugSupported === 2) {
            // Remove hotplug ID event listeners
            usb.off('attachIds', emitHotplugEvents);
            usb.off('detachIds', emitHotplugEvents);
        }
    }
    else {
        // Stop polling
        pollingHotplug = false;
    }
};
usb.on('newListener', function (event) {
    if (event !== 'attach' && event !== 'detach') {
        return;
    }
    var listenerCount = usb.listenerCount('attach') + usb.listenerCount('detach');
    if (listenerCount === 0) {
        startHotplug();
    }
});
usb.on('removeListener', function (event) {
    if (event !== 'attach' && event !== 'detach') {
        return;
    }
    var listenerCount = usb.listenerCount('attach') + usb.listenerCount('detach');
    if (listenerCount === 0) {
        stopHotplug();
    }
});
module.exports = usb;
//# sourceMappingURL=index.js.map