"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.behaviors = void 0;
const cc_1 = require("@zwave-js/cc");
const EnergyProductionCC_1 = require("@zwave-js/cc/EnergyProductionCC");
const safe_1 = require("@zwave-js/core/safe");
const shared_1 = require("@zwave-js/shared");
const testing_1 = require("@zwave-js/testing");
const defaultCapabilities = {
    values: {
        Power: {
            value: 0,
            scale: 0,
        },
        "Production Total": {
            value: 0,
            scale: 0,
        },
        "Production Today": {
            value: 0,
            scale: 0,
        },
        "Total Time": {
            value: 0,
            scale: 0,
        },
    },
};
const respondToEnergyProductionGet = {
    async onControllerFrame(controller, self, frame) {
        if (frame.type === testing_1.MockZWaveFrameType.Request &&
            frame.payload instanceof EnergyProductionCC_1.EnergyProductionCCGet) {
            const capabilities = {
                ...defaultCapabilities,
                ...self.getCCCapabilities(safe_1.CommandClasses["Energy Production"], frame.payload.endpointIndex),
            };
            const result = capabilities.values[(0, shared_1.getEnumMemberName)(cc_1.EnergyProductionParameter, frame.payload.parameter)];
            const cc = new EnergyProductionCC_1.EnergyProductionCCReport(self.host, {
                nodeId: controller.host.ownNodeId,
                parameter: frame.payload.parameter,
                value: result?.value ?? 0,
                scale: (0, cc_1.getEnergyProductionScale)(frame.payload.parameter, result?.scale ?? 0),
            });
            await self.sendToController((0, testing_1.createMockZWaveRequestFrame)(cc, {
                ackRequested: false,
            }));
            return true;
        }
        return false;
    },
};
exports.behaviors = [respondToEnergyProductionGet];
//# sourceMappingURL=EnergyProduction.js.map