import { Interpreter, StateMachine } from "xstate";
export interface TransportServiceRXStateSchema {
    states: {
        waitingForSegment: {};
        segmentTimeout: {};
        waitingForRequestedSegment: {};
        segmentsComplete: {};
        success: {};
        failure: {};
    };
}
export interface TransportServiceRXContext {
    receivedSegments: boolean[];
}
export declare type TransportServiceRXEvent = {
    type: "segment";
    index: number;
};
export declare type TransportServiceRXMachine = StateMachine<TransportServiceRXContext, TransportServiceRXStateSchema, TransportServiceRXEvent, any, any, any, any>;
export declare type TransportServiceRXInterpreter = Interpreter<TransportServiceRXContext, TransportServiceRXStateSchema, TransportServiceRXEvent>;
export declare type TransportServiceRXMachineParams = {
    numSegments: number;
    missingSegmentTimeout: number;
};
export interface TransportServiceRXServiceImplementations {
    requestMissingSegment(index: number): Promise<void>;
    sendSegmentsComplete(): Promise<void>;
}
export declare function createTransportServiceRXMachine(implementations: TransportServiceRXServiceImplementations, params: TransportServiceRXMachineParams): TransportServiceRXMachine;
//# sourceMappingURL=TransportServiceMachine.d.ts.map