import type { ZWaveError } from "@zwave-js/core";
import type { Message } from "@zwave-js/serial";
import { Interpreter, StateMachine } from "xstate";
import type { CommandQueueEvent } from "./CommandQueueMachine";
import { ServiceImplementations } from "./StateMachineShared";
import type { Transaction } from "./Transaction";
export interface TransactionMachineContext {
    transaction: Transaction;
    sendDataAttempts: number;
    result?: Message;
    error?: ZWaveError;
}
export declare type TransactionMachineEvent = (CommandQueueEvent & {
    type: "command_success";
}) | (CommandQueueEvent & {
    type: "command_failure";
}) | (CommandQueueEvent & {
    type: "command_error";
}) | {
    type: "NIF";
    nodeId: number;
} | {
    type: "resend";
} | {
    type: "stop";
};
export declare type TransactionMachine = StateMachine<TransactionMachineContext, any, TransactionMachineEvent, any, any, any, any>;
export declare type TransactionMachineInterpreter = Interpreter<TransactionMachineContext, any, TransactionMachineEvent>;
export declare function createTransactionMachine(id: string, transaction: Transaction, implementations: ServiceImplementations): TransactionMachine;
//# sourceMappingURL=TransactionMachine.d.ts.map