"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.behaviors = void 0;
const NotificationCC_1 = require("@zwave-js/cc/NotificationCC");
const core_1 = require("@zwave-js/core");
const testing_1 = require("@zwave-js/testing");
const defaultCapabilities = {
    supportsV1Alarm: false,
    notificationTypesAndEvents: {}, // none
};
const respondToNotificationSupportedGet = {
    async onControllerFrame(controller, self, frame) {
        if (frame.type === testing_1.MockZWaveFrameType.Request &&
            frame.payload instanceof NotificationCC_1.NotificationCCSupportedGet) {
            const capabilities = {
                ...defaultCapabilities,
                ...self.getCCCapabilities(core_1.CommandClasses.Notification, frame.payload.endpointIndex),
            };
            const cc = new NotificationCC_1.NotificationCCSupportedReport(self.host, {
                nodeId: controller.host.ownNodeId,
                supportsV1Alarm: capabilities.supportsV1Alarm,
                supportedNotificationTypes: Object.keys(capabilities.notificationTypesAndEvents).map((t) => parseInt(t)),
            });
            await self.sendToController((0, testing_1.createMockZWaveRequestFrame)(cc, {
                ackRequested: false,
            }));
            return true;
        }
        return false;
    },
};
const respondToNotificationEventSupportedGet = {
    async onControllerFrame(controller, self, frame) {
        if (frame.type === testing_1.MockZWaveFrameType.Request &&
            frame.payload instanceof NotificationCC_1.NotificationCCEventSupportedGet) {
            const capabilities = {
                ...defaultCapabilities,
                ...self.getCCCapabilities(core_1.CommandClasses.Notification, frame.payload.endpointIndex),
            };
            if (frame.payload.notificationType in
                capabilities.notificationTypesAndEvents) {
                const cc = new NotificationCC_1.NotificationCCEventSupportedReport(self.host, {
                    nodeId: controller.host.ownNodeId,
                    notificationType: frame.payload.notificationType,
                    supportedEvents: capabilities.notificationTypesAndEvents[frame.payload.notificationType],
                });
                await self.sendToController((0, testing_1.createMockZWaveRequestFrame)(cc, {
                    ackRequested: false,
                }));
                return true;
            }
        }
        return false;
    },
};
exports.behaviors = [
    respondToNotificationSupportedGet,
    respondToNotificationEventSupportedGet,
];
//# sourceMappingURL=Notification.js.map