/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet;

import de.jave.io.CodeBaseTool;
import de.jave.util.Toolbox;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class FIGFileManager {
    protected static final String BASE_DIR = CodeBaseTool.getCodeBase() + "/fonts/";
    protected static final String CATEGORY_FILE = "categories.txt";
    protected static final String FONT_DEFAULT = "standard";
    protected static final String CATEGORY_DEFAULT = "Outline";
    protected static String[] fontNames;
    protected static String defaultFontName;
    protected static String defaultCategoryName;
    protected static String[] controlNames;
    protected static String[] categoryNames;
    protected static Hashtable tableCategories;
    protected static final String ALL_CATEGORY_NAME = "All fonts";
    protected static final String NEW_CATEGORY_NAME = "New fonts";
    protected static boolean initialized;
    public static final int OK = 0;
    public static final int NO_BASE_DIR = 1;
    public static final int NOT_READABLE = 2;
    public static final int NO_FONTS_INSTALLED = 3;
    public static final int NO_CATEGORY_FILE = 4;
    public static final int CATEGORY_FILE_INVALID = 5;

    private FIGFileManager() {
    }

    public static File getBaseDir() {
        return new File(BASE_DIR);
    }

    public static File getCategoryFile() {
        return new File(BASE_DIR + CATEGORY_FILE);
    }

    public static int init() {
        String string;
        fontNames = new String[0];
        controlNames = new String[0];
        categoryNames = new String[0];
        initialized = true;
        tableCategories = new Hashtable();
        File file = FIGFileManager.getBaseDir();
        if (!file.exists()) {
            return 1;
        }
        if (!file.canRead()) {
            return 2;
        }
        String[] stringArray = file.list();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].endsWith(".flf")) {
                ++n;
            } else if (stringArray[n3].endsWith(".flc")) {
                ++n2;
            }
            ++n3;
        }
        if (n == 0) {
            return 3;
        }
        fontNames = new String[n];
        controlNames = new String[n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < stringArray.length) {
            if (stringArray[n6].endsWith(".flf")) {
                FIGFileManager.fontNames[n4] = stringArray[n6].substring(0, stringArray[n6].length() - 4);
                if (n4 == 0 || fontNames[n4].equals(FONT_DEFAULT)) {
                    defaultFontName = fontNames[n4];
                }
                ++n4;
            } else if (stringArray[n6].endsWith(".flc")) {
                FIGFileManager.controlNames[n5++] = stringArray[n6].substring(0, stringArray[n6].length() - 4);
            }
            ++n6;
        }
        Toolbox.quickSort(fontNames);
        Toolbox.quickSort(controlNames);
        Hashtable<String, Number> hashtable = new Hashtable<String, Number>(fontNames.length * 2 + 1);
        int n7 = 0;
        while (n7 < fontNames.length) {
            hashtable.put(fontNames[n7], new Integer(0));
            ++n7;
        }
        File file2 = FIGFileManager.getCategoryFile();
        if (!file2.exists() || !file2.canRead()) {
            String string2 = "All fonts (" + fontNames.length + ")";
            categoryNames = new String[]{string2};
            tableCategories.put(string2, fontNames);
            defaultCategoryName = string2;
            return 4;
        }
        Vector vector = new Vector(30);
        Vector<Object> vector2 = null;
        try {
            Object object;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() < 1 || string.charAt(0) == '#') continue;
                if (string.charAt(0) == '[') {
                    if (vector2 != null && vector2.size() > 1) {
                        vector.addElement(vector2);
                    }
                    vector2 = new Vector(100);
                    object = string.substring(1, string.length() - 1);
                    vector2.addElement(object);
                    if (defaultCategoryName != null && !((String)object).equals(CATEGORY_DEFAULT)) continue;
                    defaultCategoryName = object;
                    continue;
                }
                if (!hashtable.containsKey(string)) continue;
                hashtable.remove(string);
                hashtable.put(string, new Short(0));
                vector2.addElement(string);
            }
            if (vector2 != null && vector2.size() > 1) {
                vector.addElement(vector2);
            }
            vector2 = new Vector<Object>(100);
            vector2.addElement(NEW_CATEGORY_NAME);
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                Object v = hashtable.get(string);
                if (!(v instanceof Integer)) continue;
                vector2.addElement(string);
            }
            if (vector2 != null && vector2.size() > 1) {
                vector.addElement(vector2);
            }
            vector2 = new Vector(fontNames.length + 2);
            vector2.addElement(ALL_CATEGORY_NAME);
            int n8 = 0;
            while (n8 < fontNames.length) {
                vector2.addElement(fontNames[n8]);
                ++n8;
            }
            vector.addElement(vector2);
        }
        catch (Exception exception) {
            String string3 = "All fonts (" + fontNames.length + ")";
            categoryNames = new String[]{string3};
            tableCategories.put(string3, fontNames);
            defaultCategoryName = string3;
            System.err.println(exception);
            return 5;
        }
        categoryNames = new String[vector.size()];
        int n9 = 0;
        while (n9 < vector.size()) {
            string = (String)((Vector)vector.elementAt(n9)).elementAt(0);
            int n10 = ((Vector)vector.elementAt(n9)).size() - 1;
            String[] stringArray2 = new String[n10];
            int n11 = 1;
            while (n11 <= n10) {
                stringArray2[n11 - 1] = (String)((Vector)vector.elementAt(n9)).elementAt(n11);
                ++n11;
            }
            Toolbox.quickSort(stringArray2);
            if (string.equals(defaultCategoryName)) {
                defaultCategoryName = defaultCategoryName + " (" + n10 + ")";
            }
            FIGFileManager.categoryNames[n9] = string = string + " (" + n10 + ")";
            tableCategories.put(string, stringArray2);
            ++n9;
        }
        return 0;
    }

    public static String[] getAllFontNames() {
        if (!initialized) {
            FIGFileManager.init();
        }
        return fontNames;
    }

    public static String[] getAllControlNames() {
        if (!initialized) {
            FIGFileManager.init();
        }
        return controlNames;
    }

    public static String[] getAllCategoryNames() {
        if (!initialized) {
            FIGFileManager.init();
        }
        return categoryNames;
    }

    public static String getDefaultCategoryName() {
        if (!initialized) {
            FIGFileManager.init();
        }
        return defaultCategoryName;
    }

    public static String getDefaultFontName() {
        if (!initialized) {
            FIGFileManager.init();
        }
        return defaultFontName;
    }

    public static int getCategorySize(String string) {
        String[] stringArray;
        if (!initialized) {
            FIGFileManager.init();
        }
        if ((stringArray = (String[])tableCategories.get(string)) == null) {
            throw new RuntimeException("No such category: " + string);
        }
        return stringArray.length;
    }

    public static String[] getCategoryFonts(String string) {
        String[] stringArray;
        if (!initialized) {
            FIGFileManager.init();
        }
        if ((stringArray = (String[])tableCategories.get(string)) == null) {
            throw new RuntimeException("No such category: " + string);
        }
        return stringArray;
    }

    public static URL getURLForFont(String string) {
        return FIGFileManager.getURLForFont(new File(BASE_DIR + string + ".flf"));
    }

    public static URL getURLForFont(File file) {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        try {
            return new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Unknown Error when trying to load font: " + malformedURLException);
        }
    }

    public static void main(String[] stringArray) {
        FIGFileManager.init();
        String[] stringArray2 = FIGFileManager.getAllCategoryNames();
        int n = 0;
        while (n < stringArray2.length) {
            System.err.println("# " + stringArray2[n]);
            String[] stringArray3 = FIGFileManager.getCategoryFonts(stringArray2[n]);
            int n2 = 0;
            while (n2 < stringArray3.length) {
                System.err.println("   " + stringArray3[n2]);
                ++n2;
            }
            ++n;
        }
    }

    static {
        initialized = false;
    }
}

