/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.gui.GChoiceTextField;
import de.jave.image.ValueRaster;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.jave.AsciiGradients;
import de.jave.jave.CharacterPlate;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class Image2AsciiAlgorithmGradient
extends Image2AsciiAlgorithm
implements TextListener,
ItemListener {
    protected Panel adjustmentPanel;
    protected GChoiceTextField tfGradient;
    protected TextField tfStegano;
    protected Checkbox cbStegano;

    public String getAlgorithmName() {
        return "Gradient";
    }

    public int getVerticalPixelsPerChar() {
        return 1;
    }

    public int getHorizontalPixelsPerChar() {
        return 1;
    }

    public boolean requiresBWImage() {
        return false;
    }

    public Component getAdjustmentComponent() {
        if (this.adjustmentPanel == null) {
            this.adjustmentPanel = new Panel();
            this.adjustmentPanel.setLayout(new BorderLayout());
            if (!AsciiGradients.isInitialized()) {
                AsciiGradients.init();
            }
            this.tfGradient = AsciiGradients.createComponent();
            this.cbStegano = new Checkbox("Steganography, Text:", false);
            this.cbStegano.addItemListener(this);
            this.tfStegano = new TextField("", 15);
            this.tfStegano.addTextListener(this);
            Panel panel = new Panel();
            panel.add(this.cbStegano);
            panel.add(this.tfStegano);
            this.adjustmentPanel.add((Component)this.tfGradient, "Center");
            this.adjustmentPanel.add((Component)panel, "South");
            this.tfGradient.addTextListener(this);
        }
        return this.adjustmentPanel;
    }

    public void textValueChanged(TextEvent textEvent) {
        this.adjustmentChanged();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.adjustmentChanged();
    }

    public CharacterPlate convert(ValueRaster valueRaster) {
        String string = AsciiGradients.getDefaultGradient();
        if (this.tfGradient != null) {
            string = this.tfGradient.getText();
        } else if (this.specialCharacters != null) {
            string = this.specialCharacters;
        }
        if (string.length() == 0) {
            string = " ";
        }
        int n = string.length();
        int n2 = valueRaster.getWidth();
        int n3 = valueRaster.getHeight();
        CharacterPlate characterPlate = new CharacterPlate(n2, n3);
        boolean bl = false;
        if (this.cbStegano != null) {
            bl = this.cbStegano.getState();
        }
        String string2 = "";
        if (this.tfStegano != null) {
            string2 = this.tfStegano.getText();
        }
        int n4 = 0;
        while (n4 < n3) {
            Thread.yield();
            if (this.shallStop) {
                return null;
            }
            int n5 = 0;
            while (n5 < n2) {
                int n6;
                double d = (double)valueRaster.getValueAt(n5, n4) / 255.0;
                int n7 = (int)((1.0 - d) * (double)n);
                if (n7 >= n) {
                    n7 = n - 1;
                }
                if (bl && (n6 = (n4 * n2 + n5) / 8) < string2.length()) {
                    boolean bl2;
                    int n8 = (n4 * n2 + n5) % 8;
                    boolean bl3 = (string2.charAt(n6) & 1 << n8) > 0;
                    boolean bl4 = bl2 = (n7 & 1) > 0;
                    if (bl2 != bl3) {
                        n7 = (n5 + n4) % 2 == 0 ? --n7 : ++n7;
                    }
                    if (n7 < 0) {
                        n7 += 2;
                    } else if (n7 >= n) {
                        n7 -= 2;
                    }
                }
                characterPlate.setForce(n5, n4, string.charAt(n7));
                ++n5;
            }
            this.progress(0.3 + 0.7 * (double)n4 / (double)n3);
            ++n4;
        }
        return characterPlate;
    }
}

