/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GImageCanvas;
import de.jave.jave.AsciiToThumbnailConverter;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Document;
import de.jave.jave.DocumentListener;
import de.jave.jave.GifExportOptionsPanel;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import net.jmge.gif.Gif89Encoder;

public class Ascii2GIFDialog
extends Dialog
implements ActionListener,
ItemListener,
DocumentListener,
WindowListener {
    protected Document document;
    protected Jave parent;
    protected GImageCanvas image;
    protected Button bSave;
    protected Button bRefresh;
    protected Button bClose;
    protected String documentName;
    protected ScrollPane scrollPane;
    protected Label lSize;
    protected int colorScheme;
    protected GifExportOptionsPanel gifOptionsPanel;

    public Ascii2GIFDialog(Jave jave, Document document, int n) {
        super(jave);
        this.document = document;
        this.parent = jave;
        this.documentName = document.getTitle();
        this.colorScheme = n;
        document.addDocumentListener(this);
        this.setTitle("Ascii2GIF - " + this.documentName);
        this.addWindowListener(this);
        this.setLayout(new BorderLayout(2, 2));
        this.image = new GImageCanvas();
        this.bRefresh = new Button("Refresh");
        this.bSave = new Button("Save...");
        this.bClose = new Button("Close");
        this.bSave.addActionListener(this);
        this.bRefresh.addActionListener(this);
        this.bClose.addActionListener(this);
        this.lSize = new Label("width x height pixels");
        Panel panel = new Panel();
        panel.add(this.bRefresh);
        panel.add(this.bSave);
        panel.add(this.bClose);
        this.gifOptionsPanel = new GifExportOptionsPanel(false);
        this.gifOptionsPanel.addActionListener(this);
        this.scrollPane = new ScrollPane();
        this.scrollPane.setSize(200, 150);
        this.scrollPane.add(this.image);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)panel, "South");
        this.add((Component)this.gifOptionsPanel, "North");
        this.convert();
    }

    protected void convert() {
        try {
            int n = this.gifOptionsPanel.getFontScale();
            Font font = this.gifOptionsPanel.getResultFont();
            boolean bl = this.gifOptionsPanel.getPixelView();
            CharacterPlate characterPlate = this.document.getContent();
            Image image = AsciiToThumbnailConverter.convert(characterPlate, n, font, JaveGlobalRessources.COLOR_PLATE_BACKGROUND[this.colorScheme], JaveGlobalRessources.COLOR_TEXT[this.colorScheme], bl);
            this.image.setImage(image);
            this.image.repaint();
            this.scrollPane.validate();
            this.lSize.setText(image.getWidth(this) + " x " + image.getHeight(this) + " pixels");
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public void documentClosing() {
        this.close();
    }

    public void documentHiding() {
    }

    public void documentShowing() {
    }

    public void documentChanged() {
        this.convert();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bSave) {
            this.doSaveAs();
        } else if (object == this.bClose) {
            this.close();
        } else {
            this.convert();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.convert();
    }

    public void close() {
        this.dispose();
    }

    protected void doSaveAs() {
        FileDialog fileDialog = new FileDialog((Frame)this.parent, "Save GIF File", 1);
        fileDialog.setFile(this.documentName + ".gif");
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null) {
            return;
        }
        if (!string.toLowerCase().endsWith(".gif")) {
            string = string + ".gif";
        }
        File file = new File(string2, string);
        try {
            Gif89Encoder gif89Encoder = new Gif89Encoder(this.image.getImage());
            gif89Encoder.setComments("Created using JavE 5.0 - http://www.jave.de");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            gif89Encoder.encode(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

