/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GDialog;
import de.jave.gui.GTextArea;
import de.jave.gui.VFlowLayout;
import de.jave.jave.Jave;
import de.jave.jave.JaveConfigurationFileLoader;
import de.jave.jave.JaveConfigurationLoadable;
import de.jave.jave.JaveGlobalRessources;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;

public class CharacterSets
implements JaveConfigurationLoadable {
    protected static String[] charsetNames = null;
    protected static String[] charsetCharacters = null;
    public static final int NONE = 0;
    public static final int PURE_ASCII = 1;
    protected static final int DEFAULT_CHARSET_INDEX = 1;
    protected static int currentCharsetIndex = 1;
    protected static final String DEFAULT_CHARSET = "!\"#$%&'()*+,-./0123456789:;<=>?@\nABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`\nabcdefghijklmnopqrstuvwxyz{|}~";
    protected static int userDefinedIndex;
    protected static boolean initialized;

    protected CharacterSets() {
    }

    public String getConfigurationFileName() {
        return "./config/charsets.txt";
    }

    public static void init() {
        CharacterSets.init(null);
    }

    public static void init(Frame frame) {
        JaveConfigurationFileLoader.initConfigFile(frame, new CharacterSets());
        initialized = true;
    }

    public static final int getDefaultCharsetIndex() {
        return 1;
    }

    public static final void setCurrentCharsetIndex(int n, Jave jave) {
        currentCharsetIndex = n;
        if (n == userDefinedIndex) {
            GTextArea gTextArea = new GTextArea(charsetCharacters[userDefinedIndex], 5, 60);
            gTextArea.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
            Panel panel = new Panel();
            panel.setLayout(new VFlowLayout());
            panel.add(gTextArea);
            panel.add(new Label("(The Character [space] is always included)"));
            GDialog gDialog = new GDialog((Frame)jave, "User Defined Character Set", "Legal characters:", panel);
            gDialog.show();
            CharacterSets.charsetCharacters[CharacterSets.userDefinedIndex] = " " + gTextArea.getText();
        }
    }

    public static final boolean isLegal(char c) {
        if (currentCharsetIndex == 0) {
            return true;
        }
        if (currentCharsetIndex == 1) {
            return c >= ' ' && c <= '~';
        }
        return charsetCharacters[currentCharsetIndex].indexOf(c) != -1;
    }

    public static String[] getCharsetNames() {
        return charsetNames;
    }

    public void setDefaultConfiguration() {
        charsetNames = new String[3];
        charsetCharacters = new String[3];
        CharacterSets.charsetNames[0] = "Any Characters";
        CharacterSets.charsetNames[1] = "Pure ASCII";
        CharacterSets.charsetNames[2] = "User Defined";
        CharacterSets.charsetCharacters[0] = "";
        CharacterSets.charsetCharacters[1] = "";
        CharacterSets.charsetCharacters[2] = DEFAULT_CHARSET;
        userDefinedIndex = 2;
    }

    public void loadConfiguration(File file) throws Exception {
        charsetNames = null;
        charsetCharacters = null;
        Vector<String> vector = new Vector<String>();
        vector.addElement("");
        vector.addElement("");
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("Any Characters");
        vector2.addElement("Pure ASCII");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        boolean bl = true;
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
            if (bl) {
                if (string.length() > 30) {
                    string = string.substring(0, 30);
                }
                vector2.addElement(string);
                bl = false;
                continue;
            }
            vector.addElement(" " + string);
            bl = true;
        }
        bufferedReader.close();
        vector2.addElement("User Defined");
        vector.addElement(DEFAULT_CHARSET);
        int n = vector2.size();
        charsetNames = new String[n];
        charsetCharacters = new String[n];
        int n2 = 0;
        while (n2 < n) {
            CharacterSets.charsetNames[n2] = (String)vector2.elementAt(n2);
            CharacterSets.charsetCharacters[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        userDefinedIndex = n - 1;
    }

    static {
        initialized = false;
    }
}

