/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GBorderedPanel;
import de.jave.gui.GuiTools;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Document;
import de.jave.jave.Jave;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public abstract class DialogTool
extends Dialog
implements ActionListener,
WindowListener {
    protected Plate plate;
    protected Button bClose;
    protected Button bCancel;
    protected PixelPlate markPlate;
    protected CharacterPlate characterPlate;
    protected Jave jave;
    protected int plateWidth;
    protected int plateHeight;
    protected Document document;
    protected boolean debug;

    public DialogTool(Jave jave, Plate plate) {
        super((Frame)jave, true);
        this.setTitle(this.getToolTitle());
        this.addWindowListener(this);
        this.plate = plate;
        this.jave = jave;
        this.characterPlate = new CharacterPlate(this.getPreferredPlateSize());
        this.plateWidth = this.characterPlate.getWidth();
        this.plateHeight = this.characterPlate.getHeight();
        this.document = this.jave.pasteAsNewDocument(this.characterPlate, this.getToolTitle());
        this.document.setModified(false);
        this.jave.setColorScheme(this.getPreferredColorScheme());
        this.debug = false;
        this.bCancel = new Button("Cancel");
        this.bCancel.addActionListener(this);
        this.bClose = new Button("Close");
        this.bClose.addActionListener(this);
        Panel panel = new Panel();
        panel.add(this.bClose);
        panel.add(this.bCancel);
        this.setLayout(new BorderLayout());
        GBorderedPanel gBorderedPanel = new GBorderedPanel();
        gBorderedPanel.add(this.getOptionsComponent());
        this.add((Component)gBorderedPanel, "Center");
        this.add((Component)panel, "South");
        this.pack();
        GuiTools.centerOnScreen(this);
    }

    protected void toolStarted() {
    }

    public void show() {
        this.jave.hideToolOptionsDialog();
        this.toolStarted();
        super.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bClose) {
            this.saveCurrentState(this.getToolActionName());
            this.jave.showToolOptionsDialog();
            this.dispose();
            return;
        }
        if (object == this.bCancel) {
            this.cancel();
        }
    }

    protected void cancel() {
        this.document.setModified(false);
        this.jave.doClose();
        this.jave.showToolOptionsDialog();
        this.dispose();
    }

    protected void repaintPlate() {
        this.plate.repaint();
    }

    protected void saveCurrentState(String string) {
        this.plate.saveCurrentState(string);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.cancel();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    protected abstract Dimension getPreferredPlateSize();

    protected abstract String getToolTitle();

    protected abstract int getPreferredColorScheme();

    protected abstract String getToolActionName();

    protected abstract Component getOptionsComponent();
}

