/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.Document;
import de.jave.jave.JaveGlobalRessources;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class DocumentManager {
    protected String currentDirectory;
    protected Vector documents = new Vector(20);
    protected int currentDocumentIndex = -1;

    public DocumentManager() {
        this.currentDirectory = JaveGlobalRessources.getInifile().getString("editor", "filepath", null);
    }

    public synchronized void setCurrentDocument(int n) {
        this.currentDocumentIndex = n;
    }

    public int getIndexOf(Document document) {
        return this.documents.indexOf(document);
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(String string) {
        this.currentDirectory = string;
        JaveGlobalRessources.getInifile().put("editor", "filepath", string);
    }

    public String getFrameTitle() {
        if (this.currentDocumentIndex < 0) {
            return null;
        }
        return this.getCurrentDocument().getFrameTitle();
    }

    public int getSize() {
        return this.documents.size();
    }

    public synchronized Document createNew() {
        Document document = Document.createNew();
        this.documents.addElement(document);
        this.currentDocumentIndex = this.documents.size() - 1;
        return document;
    }

    public synchronized Document createNew(int n, int n2) {
        Document document = Document.createNew(n, n2);
        this.documents.addElement(document);
        this.currentDocumentIndex = this.documents.size() - 1;
        return document;
    }

    public synchronized Document load(String string, String string2) throws IOException {
        Document document = null;
        File file = new File(string + string2);
        document = Document.load(string + string2);
        JaveGlobalRessources.getRecentFileList().add(file);
        this.setCurrentDirectory(string);
        this.documents.addElement(document);
        this.currentDocumentIndex = this.documents.size() - 1;
        return document;
    }

    public boolean isAlreadyOpen(String string, String string2) {
        String string3 = string + string2;
        int n = 0;
        while (n < this.documents.size()) {
            Document document = this.getDocument(n);
            if (document.getFileName().equals(string3)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized void closeCurrentDocument() {
        this.closeDocument(this.currentDocumentIndex);
    }

    public synchronized void closeDocument(int n) {
        Document document = (Document)this.documents.elementAt(n);
        document.documentClosing();
        this.documents.removeElementAt(n);
        if (n <= this.currentDocumentIndex) {
            --this.currentDocumentIndex;
            if (this.currentDocumentIndex < 0 && this.getSize() > 0) {
                this.currentDocumentIndex = 0;
            }
        }
    }

    public int getCurrentDocumentIndex() {
        return this.currentDocumentIndex;
    }

    public Document getCurrentDocument() {
        if (this.currentDocumentIndex < 0) {
            return null;
        }
        return this.getDocument(this.currentDocumentIndex);
    }

    public String[] getMenuTitles() {
        String[] stringArray = new String[this.documents.size()];
        int n = 0;
        while (n < this.documents.size()) {
            stringArray[n] = n + 1 + " " + this.getDocument(n).getTitle();
            ++n;
        }
        return stringArray;
    }

    public Document getDocument(int n) {
        return (Document)this.documents.elementAt(n);
    }

    public synchronized String[] getDocumentStatusList() {
        String[] stringArray = new String[this.documents.size() * 2];
        int n = 0;
        while (n < this.documents.size()) {
            stringArray[n * 2] = this.getDocument(n).getFileName();
            stringArray[n * 2 + 1] = this.getDocument(n).getLogFileName();
            ++n;
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DocumentManager(" + this.getSize() + "," + this.currentDirectory + "){\n");
        int n = 0;
        while (n < this.getSize()) {
            stringBuffer.append("  " + this.documents.elementAt(n) + "\n");
            ++n;
        }
        stringBuffer.append("};\n");
        return stringBuffer.toString();
    }

    public void print() {
        System.out.println(this.toString());
    }
}

