/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.figlet.FIGDriver;
import de.jave.figlet.FIGFileManager;
import de.jave.figlet.FIGThread;
import de.jave.gui.GBorderedPanel;
import de.jave.gui.GDialog;
import de.jave.gui.GLabel;
import de.jave.gui.GTextArea;
import de.jave.jave.FIGletTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.StringTokenizer;

public class FigletDialog
extends Dialog
implements WindowListener,
TextListener,
ItemListener,
ActionListener {
    protected static final String TITLE = "FIGlet Editor";
    protected static final String INITIAL_TEXT = "Figlet";
    protected Jave parent;
    protected TextArea taInput;
    protected TextArea taOutput;
    protected Checkbox cbFIGML;
    protected Choice chCategory;
    protected Choice chFont;
    protected FIGThread figThread;
    protected FIGDriver figDriver;
    protected Button bInsert;
    protected Button bClose;
    protected Button bFontInfo;
    protected String figletFontName;
    protected boolean figml;
    protected int mode;
    protected static final int MODE_NORMAL = 0;
    protected static final int MODE_TEST = 1;

    public FigletDialog(Jave jave) {
        this(jave, TITLE, 0);
    }

    public FigletDialog(Jave jave, String string, int n) {
        super(jave, string, false);
        Object object;
        Panel panel;
        this.parent = jave;
        this.mode = n;
        this.setLayout(new BorderLayout());
        this.addWindowListener(this);
        if (n == 0) {
            panel = new Panel();
            panel.add(new Label("Font Category:", 2));
            this.chCategory = new Choice();
            object = FIGFileManager.getAllCategoryNames();
            if (object == null || ((String[])object).length == 0) {
                this.setLayout(new BorderLayout());
                this.add((Component)new GLabel("No FIGlet fonts available!\n - Tool disabled.\n\nDownload and install FIGlet fonts\nfrom the JavE homepage."), "Center");
                this.bClose = new Button("Close");
                this.bClose.addActionListener(this);
                this.add((Component)this.bClose, "South");
                this.pack();
                return;
            }
            int n2 = 0;
            while (n2 < ((String[])object).length) {
                this.chCategory.add(object[n2]);
                ++n2;
            }
            this.chCategory.select(FIGFileManager.getDefaultCategoryName());
            panel.add(this.chCategory);
            panel.add(new Label("Font:", 2));
            this.chFont = new Choice();
            this.updateFontChoice();
            this.chFont.select(FIGFileManager.getDefaultFontName());
            panel.add(this.chFont);
            this.chFont.addItemListener(this);
            this.chCategory.addItemListener(this);
            this.figletFontName = FIGFileManager.getDefaultFontName();
            this.chFont.select(this.figletFontName);
            this.bFontInfo = new Button("Font Information");
            this.bFontInfo.addActionListener(this);
            panel.add(this.bFontInfo);
            this.cbFIGML = new Checkbox("FIGML", false);
            this.cbFIGML.addItemListener(this);
            this.figml = this.cbFIGML.getState();
            panel.add(this.cbFIGML);
            this.add((Component)panel, "North");
        }
        this.taOutput = new GTextArea(15, 80);
        this.taOutput.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.taOutput.setEditable(false);
        this.taInput = new GTextArea(INITIAL_TEXT, 5, 80, 0);
        this.taInput.addTextListener(this);
        this.taInput.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        panel = new GBorderedPanel("Preview:", -1);
        panel.setLayout(new GridLayout());
        panel.add(this.taOutput);
        object = new GBorderedPanel("Text:", -1);
        ((Container)object).setLayout(new GridLayout());
        ((Container)object).add(this.taInput);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(0, 1, 4, 4));
        panel2.add(panel);
        panel2.add((Component)object);
        this.add((Component)panel2, "Center");
        Panel panel3 = new Panel();
        if (n == 0) {
            this.bInsert = new Button("Insert");
            this.bInsert.addActionListener(this);
            panel3.add(this.bInsert);
        }
        this.bClose = new Button("Close");
        this.bClose.addActionListener(this);
        panel3.add(this.bClose);
        this.add((Component)panel3, "South");
        this.figDriver = new FIGDriver();
        this.figThread = new FIGThread(this.figDriver, this.taOutput, null, null);
        this.figThread.start();
        this.figletize();
        this.pack();
    }

    protected void loadFontFile(String string, File file) {
        this.figDriver.forceFontReload(string, file);
        this.figletize();
    }

    public void setText(String string) {
        this.taInput.setText(string);
    }

    protected void updateFontChoice() {
        this.chFont.setEnabled(false);
        this.chFont.removeAll();
        String[] stringArray = FIGFileManager.getCategoryFonts(this.chCategory.getSelectedItem());
        int n = 0;
        while (n < stringArray.length) {
            this.chFont.add(stringArray[n]);
            ++n;
        }
        this.chFont.select(0);
        this.chFont.setEnabled(true);
    }

    public void show() {
        super.show();
        if (this.taInput != null) {
            this.taInput.selectAll();
            this.taInput.requestFocus();
        }
    }

    private void figletize() {
        String string = this.taInput.getText();
        if (!this.figml) {
            string = this.toFIGML(string);
        }
        this.figThread.addJob(string);
    }

    private String toFIGML(String string) {
        StringBuffer stringBuffer = new StringBuffer("<figlet ascii 80>");
        if (this.mode == 0) {
            stringBuffer.append("<" + this.figletFontName + ".flf>");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r\f", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\n")) {
                stringBuffer.append("<br>");
                continue;
            }
            stringBuffer.append(string2);
        }
        stringBuffer.append("</fig>");
        return stringBuffer.toString();
    }

    protected int figmlOn() {
        String[] stringArray = new String[]{"Test anyway", "Cancel"};
        GDialog gDialog = new GDialog((Frame)this.parent, "FIGML", "Attention: FIGML", "FIGML (FIGlet Markup Language) is a format similar to HTML.\n\nUp to now it is no standard and there is no specification available.\n\nFIGML-support in JavE is included for testing purposes only\n\nSome valid FIGML-Tags are:\n\t<br>, <hr>, <hr*> where * is any character or string,\n\t<valign=right|left|center>, <halign=top|bottom|center>, ...", stringArray, 2);
        gDialog.show();
        int n = gDialog.getAnswer();
        if (n == -1 || n == 1) {
            return -1;
        }
        String string = this.taInput.getText();
        this.taInput.setText(this.toFIGML(string));
        return 0;
    }

    protected void figmlOff() {
        String string = this.taInput.getText();
        int n = string.indexOf("<br>");
        while (n != -1) {
            string = string.substring(0, n) + '\n' + string.substring(n + 1);
            n = string.indexOf("<br>", n);
        }
        n = string.indexOf("<BR>");
        while (n != -1) {
            string = string.substring(0, n) + '\n' + string.substring(n + 1);
            n = string.indexOf("<BR>", n);
        }
        n = string.indexOf(60);
        if (n != -1) {
            int n2 = string.indexOf(62, n + 1);
            while (n != -1 && n2 != -1) {
                if ((n = (string = string.substring(0, n) + string.substring(n2 + 1)).indexOf(60)) == -1) continue;
                n2 = string.indexOf(62, n + 1);
            }
        }
        this.taInput.setText(string);
    }

    public void textValueChanged(TextEvent textEvent) {
        this.figletize();
    }

    protected void showFontInfo() {
        FIGletTool.showFontInfo(this.figDriver, this.figletFontName, this.parent);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.chCategory) {
            this.updateFontChoice();
            this.figletFontName = this.chFont.getSelectedItem();
            this.figletize();
        } else if (object == this.chFont) {
            this.figletFontName = this.chFont.getSelectedItem();
            this.figletize();
        } else if (object == this.cbFIGML) {
            this.figml = this.cbFIGML.getState();
            if (this.figml) {
                int n = this.figmlOn();
                if (n == -1) {
                    this.cbFIGML.setState(false);
                    this.figml = false;
                }
            } else {
                this.figmlOff();
            }
            this.figletize();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bInsert) {
            String string = this.taOutput.getText();
            this.parent.pasteAsNewSelection(string);
            this.parent.toFront();
        } else if (object == this.bFontInfo) {
            this.showFontInfo();
        } else if (object == this.bClose) {
            this.close();
        }
    }

    protected void close() {
        this.setVisible(false);
        if (this.mode == 0) {
            this.parent.dialogClosed(this);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.taInput.requestFocus();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

