/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GBorderedPanel;
import de.jave.gui.GChoice;
import de.jave.gui.GGridLayout;
import de.jave.gui.GUpDownArrangement;
import de.jave.gui.Gap;
import de.jave.jave.DialogTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import gebhard.uielements.DoubleTextField;
import gebhard.uielements.IntegerTextField;
import gebhard.uielements.NumberEvent;
import gebhard.uielements.NumberListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class FractalTool
extends DialogTool
implements ItemListener,
NumberListener,
TextListener {
    protected static final String[] RESOLUTION_STR = new String[]{"Lowest", "Low (Dots)", "Normal 2by2 (J7L_\"'`()8)", "Higher 3by2", "High"};
    protected static final int DEFAULT_RESOLUTION = 4;
    protected static final double DEFAULT_REAL_JULIA = 0.4;
    protected static final double DEFAULT_IMAG_JULIA = 0.4;
    protected static final double DEFAULT_SPAN_MANDEL = 2.0;
    protected static final double DEFAULT_X_MANDEL = -0.3;
    protected static final double DEFAULT_Y_MANDEL = 0.0;
    protected DoubleTextField dfReal;
    protected DoubleTextField dfImaginary;
    protected TextField dfX;
    protected TextField dfY;
    protected TextField dfXSpan;
    protected IntegerTextField ifDepth;
    protected Checkbox cbNegative;
    protected Button bIn;
    protected Button bOut;
    protected Button bLeft;
    protected Button bRight;
    protected Button bUp;
    protected Button bDown;
    protected Button bReset;
    protected GChoice chResolution;
    protected GChoice chDespecle;

    public FractalTool(Jave jave, Plate plate) {
        super(jave, plate);
        this.convert();
    }

    protected int getPreferredColorScheme() {
        return 0;
    }

    protected Dimension getPreferredPlateSize() {
        return JaveGlobalRessources.getDefaultDocumentDimension();
    }

    protected String getToolTitle() {
        return "Fractal Tool";
    }

    public String getToolActionName() {
        return "fractal";
    }

    public Component getOptionsComponent() {
        GBorderedPanel gBorderedPanel = new GBorderedPanel("Mandelbrot Set");
        gBorderedPanel.setLayout(new GridLayout(0, 2, 2, 2));
        gBorderedPanel.add(new Label("X:"));
        this.dfX = new TextField(String.valueOf(-0.3), 10);
        this.dfX.addTextListener(this);
        gBorderedPanel.add(this.dfX);
        gBorderedPanel.add(new Label("Y:"));
        this.dfY = new TextField(String.valueOf(0.0), 10);
        this.dfY.addTextListener(this);
        gBorderedPanel.add(this.dfY);
        gBorderedPanel.add(new Label("X span:"));
        this.dfXSpan = new TextField(String.valueOf(2.0), 10);
        this.dfXSpan.addTextListener(this);
        gBorderedPanel.add(this.dfXSpan);
        this.bIn = new Button("In");
        this.bIn.addActionListener(this);
        this.bOut = new Button("Out");
        this.bOut.addActionListener(this);
        this.bLeft = new Button("Left");
        this.bLeft.addActionListener(this);
        this.bRight = new Button("Right");
        this.bRight.addActionListener(this);
        this.bUp = new Button("Up");
        this.bUp.addActionListener(this);
        this.bDown = new Button("Down");
        this.bDown.addActionListener(this);
        this.bReset = new Button("Reset");
        this.bReset.addActionListener(this);
        GBorderedPanel gBorderedPanel2 = new GBorderedPanel("Navigation");
        gBorderedPanel2.setLayout(new GridLayout(0, 4, 2, 2));
        gBorderedPanel2.add(this.bIn);
        gBorderedPanel2.add(this.bOut);
        gBorderedPanel2.add(new Gap());
        gBorderedPanel2.add(new Gap());
        gBorderedPanel2.add(this.bLeft);
        gBorderedPanel2.add(this.bRight);
        gBorderedPanel2.add(this.bUp);
        gBorderedPanel2.add(this.bDown);
        gBorderedPanel2.add(this.bReset);
        this.ifDepth = new IntegerTextField(1000, 2, 50000);
        this.ifDepth.addNumberListener(this);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel.add(new GUpDownArrangement("Depth:", this.ifDepth));
        this.chResolution = new GChoice("Resolution:", RESOLUTION_STR);
        this.chResolution.select(4);
        this.chResolution.addItemListener(this);
        panel.add(this.chResolution);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        this.cbNegative = new Checkbox("negative", false);
        this.cbNegative.addItemListener(this);
        panel2.add(this.cbNegative);
        this.chDespecle = new GChoice("Despecle:", new String[]{"none", "0", "1", "2", "3", "4", "5", "6", "7"});
        this.chDespecle.addItemListener(this);
        panel2.add(this.chDespecle);
        GBorderedPanel gBorderedPanel3 = new GBorderedPanel("Rendering");
        gBorderedPanel3.setLayout(new GGridLayout(0, 1));
        gBorderedPanel3.add(panel);
        gBorderedPanel3.add(panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new GGridLayout(1, 0));
        panel3.add(gBorderedPanel);
        panel3.add(gBorderedPanel2);
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        panel4.add((Component)panel3, "Center");
        panel4.add((Component)gBorderedPanel3, "South");
        return panel4;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        double d;
        double d2;
        double d3;
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.bReset) {
            this.dfX.setText(String.valueOf(-0.3));
            this.dfY.setText(String.valueOf(0.0));
            this.dfXSpan.setText(String.valueOf(2.0));
            if (this.dfImaginary != null) {
                this.dfImaginary.setValue(0.4);
            }
            if (this.dfReal != null) {
                this.dfReal.setValue(0.4);
            }
            this.convert();
            return;
        }
        if (object == this.bIn) {
            try {
                double d4 = Double.valueOf(this.dfXSpan.getText());
                this.dfXSpan.setText(String.valueOf(d4 *= 0.75));
                this.convert();
            }
            catch (NumberFormatException numberFormatException) {
                this.dfXSpan.setForeground(Color.red);
            }
            return;
        }
        if (object == this.bOut) {
            try {
                double d5 = Double.valueOf(this.dfXSpan.getText());
                this.dfXSpan.setText(String.valueOf(d5 *= 1.3333333333333333));
                this.convert();
            }
            catch (NumberFormatException numberFormatException) {
                this.dfXSpan.setForeground(Color.red);
            }
            return;
        }
        if (object == this.bLeft) {
            d3 = 0.0;
            d2 = 0.0;
            try {
                d3 = Double.valueOf(this.dfXSpan.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.dfXSpan.setForeground(Color.red);
                return;
            }
            try {
                d2 = Double.valueOf(this.dfX.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.dfX.setForeground(Color.red);
                return;
            }
            this.dfX.setText(String.valueOf(d2 -= d3 / 5.0));
            this.convert();
        }
        if (object == this.bRight) {
            d3 = 0.0;
            d2 = 0.0;
            try {
                d3 = Double.valueOf(this.dfXSpan.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.dfXSpan.setForeground(Color.red);
                return;
            }
            try {
                d2 = Double.valueOf(this.dfX.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.dfX.setForeground(Color.red);
                return;
            }
            this.dfX.setText(String.valueOf(d2 += d3 / 5.0));
            this.convert();
        }
        if (object == this.bUp) {
            d3 = 0.0;
            d2 = 0.0;
            try {
                d3 = Double.valueOf(this.dfXSpan.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.dfXSpan.setForeground(Color.red);
                return;
            }
            try {
                d2 = Double.valueOf(this.dfY.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.dfY.setForeground(Color.red);
                return;
            }
            d = d3 / (double)this.plateWidth * (double)this.plateHeight * 1.5;
            this.dfY.setText(String.valueOf(d2 -= d / 5.0));
            this.convert();
        }
        if (object == this.bDown) {
            d3 = 0.0;
            d2 = 0.0;
            try {
                d3 = Double.valueOf(this.dfXSpan.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.dfXSpan.setForeground(Color.red);
                return;
            }
            try {
                d2 = Double.valueOf(this.dfY.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.dfY.setForeground(Color.red);
                return;
            }
            d = d3 / (double)this.plateWidth * (double)this.plateHeight * 1.5;
            this.dfY.setText(String.valueOf(d2 += d / 5.0));
            this.convert();
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.convert();
    }

    protected void convert() {
        if (this.ifDepth == null || this.chResolution == null) {
            return;
        }
        int n = this.ifDepth.getValue();
        boolean bl = this.cbNegative.getState();
        int n2 = this.chResolution.getSelectedIndex();
        int n3 = this.chDespecle.getSelectedIndex();
        if (this.markPlate == null) {
            this.markPlate = new PixelPlate(0, 0, this.plateWidth, this.plateHeight);
        }
        this.markPlate.clear();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        try {
            d = Double.valueOf(this.dfX.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.dfX.setForeground(Color.red);
            return;
        }
        this.dfX.setForeground(Color.black);
        try {
            d2 = Double.valueOf(this.dfY.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.dfY.setForeground(Color.red);
            return;
        }
        this.dfY.setForeground(Color.black);
        try {
            d3 = Double.valueOf(this.dfXSpan.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.dfXSpan.setForeground(Color.red);
            return;
        }
        this.dfXSpan.setForeground(Color.black);
        FractalTool.drawMandelbrot(this.markPlate, 0, 0, this.plateWidth, this.plateHeight, d, d2, d3, n, bl, n2, n3);
        this.characterPlate.clear();
        this.markPlate.convert();
        this.markPlate.pasteResultInto(this.characterPlate);
        this.repaintPlate();
    }

    public static final void drawMandelbrot(PixelPlate pixelPlate, int n, int n2, int n3, int n4, double d, double d2, double d3, int n5, boolean bl, int n6, int n7) {
        double d4 = d3 / (double)n3 * (double)n4 * 2.0;
        double d5 = d - d3 / 2.0;
        double d6 = d2 - d4 / 2.0;
        int n8 = n3;
        int n9 = n4;
        switch (n6) {
            case 0: {
                pixelPlate.setMode(1);
                pixelPlate.setCharacter('8');
                break;
            }
            case 1: {
                pixelPlate.setMode(2);
                n8 *= 1;
                n9 *= 2;
                break;
            }
            case 2: {
                pixelPlate.setMode(4);
                n8 *= 2;
                n9 *= 2;
                break;
            }
            case 3: {
                pixelPlate.setMode(13);
                n8 *= 2;
                n9 *= 3;
                break;
            }
            case 4: {
                pixelPlate.setMode(5);
                n8 *= 3;
                n9 *= 4;
            }
        }
        n5 += 3 - n5 % 3;
        double d7 = d3 / (double)n8;
        double d8 = d4 / (double)n9;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 0;
            while (n11 < n8) {
                if (FractalTool.getMandelbrot(2.0 * (d5 + (double)n11 * d7), 2.0 * (d6 + (double)n10 * d8), n5) == 1 != bl) {
                    pixelPlate.set(n11, n10);
                }
                ++n11;
            }
            ++n10;
        }
        pixelPlate.removeNoise(n7 - 1);
    }

    public void numberChanged(NumberEvent numberEvent) {
        this.convert();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.convert();
    }

    protected static final int getJulia(double d, double d2, double d3, double d4, int n) {
        double d5 = 0.0;
        double d6 = 0.0;
        int n2 = 0;
        while (n2 <= n) {
            d5 = d * d - d2 * d2 + d3;
            d6 = 2.0 * d * d2 + d4;
            d = d5;
            d2 = d6;
            ++n2;
        }
        double d7 = d5 * d5 + d6 * d6;
        if (d7 >= (double)(n - 1)) {
            return 0;
        }
        return 1;
    }

    protected static final int getMandelbrot(double d, double d2, int n) {
        double d3 = d;
        double d4 = d2;
        int n2 = 1;
        while (n2 < n && d * d + d2 * d2 < 4.0) {
            double d5 = 2.0 * d * d2 + d4;
            d = d * d - d2 * d2 + d3;
            d2 = d5;
            ++n2;
        }
        return n2 % 3 == 0 ? 1 : 0;
    }
}

