/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GDialog;
import de.jave.gui.GErrorDialog;
import de.jave.gui.GImageLibrary;
import de.jave.gui.GuiTools;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.MediaTracker;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;

public class JaveStartSplashFrame
extends Frame
implements Runnable {
    protected static final String INFO_TEXT = "Now starting:\n    ,-----------------.\n    |   \\-/           |\n    |  J|a|v|E  V5.0  |\n    |   /-\\           |\n    `-----------------'";
    protected TextField tfStatus;

    public JaveStartSplashFrame() {
        super("Starting JavE 5.0");
        TextArea textArea = new TextArea(INFO_TEXT, 7, 40, 3);
        textArea.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        textArea.setEditable(false);
        this.tfStatus = new TextField("Starting JavE...");
        this.tfStatus.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)textArea, "Center");
        this.add((Component)this.tfStatus, "South");
        this.pack();
        GuiTools.centerOnScreen(this);
    }

    public void run() {
        Window window = null;
        try {
            this.tfStatus.setText("Initializing");
            Thread.currentThread();
            Thread.yield();
            JaveGlobalRessources.init(this);
            GImageLibrary.setMediaTracker(JaveGlobalRessources.getMediaTracker(), 0);
            this.tfStatus.setText("Creating GUI");
            Thread.currentThread();
            Thread.yield();
            window = new Jave();
            this.tfStatus.setText("Loading Configuration Files");
            Thread.currentThread();
            Thread.yield();
            ((Jave)window).startupInitConfigFiles(this);
            this.tfStatus.setText("Adding Tooltips");
            Thread.currentThread();
            Thread.yield();
            ((Jave)window).startupTooltips();
            this.tfStatus.setText("Halfway Finished");
            Thread.currentThread();
            Thread.yield();
            ((Jave)window).startupFinish1();
            this.tfStatus.setText("Crash Recovery?");
            Thread.currentThread();
            Thread.yield();
            ((Jave)window).startupRecovery(this);
            this.tfStatus.setText("Creating Menubar");
            Thread.currentThread();
            Thread.yield();
            ((Jave)window).startupMenuBar();
            this.tfStatus.setText("Loading images");
            Thread.currentThread();
            Thread.yield();
            MediaTracker mediaTracker = JaveGlobalRessources.getMediaTracker();
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.tfStatus.setText("Cleanup");
            Thread.currentThread();
            Thread.yield();
            ((Jave)window).startupFinish2();
            this.tfStatus.setText("Creating Tool Options Dialog");
            Thread.currentThread();
            Thread.yield();
            ((Jave)window).startupOptionsDialog();
            this.tfStatus.setText("That's it :-)");
            Thread.currentThread();
            Thread.yield();
            ((Jave)window).startupFinish3();
        }
        catch (Exception exception) {
            new GErrorDialog((Frame)this, "JavE", "An error has occured while trying to start JavE.", exception).show();
            if (window != null) {
                window.dispose();
            }
            new GDialog((Frame)this, "JavE", "  Aborting :-(     ", 3).show();
            this.dispose();
            System.exit(0);
        }
        this.dispose();
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }
}

