/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.Jave;
import de.jave.jave.Plate;
import de.jave.jave.Tool;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class PanTool
extends Tool {
    protected int panDX = 0;
    protected int panDY = 0;
    protected Point location1;

    public PanTool(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Pan";
    }

    public String getIconName() {
        return "pan";
    }

    public void takeToHand() {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void putAside(boolean bl) {
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        this.location1 = point2;
        this.panDX = 0;
        this.panDY = 0;
        this.showStatus("[0,0]");
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        this.panDX = 0;
        this.panDY = 0;
        this.showStatus("");
        this.plate.saveCurrentState("pan");
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null || this.location1 == null) {
            this.showStatus("");
            return;
        }
        int n = point2.x - this.location1.x;
        int n2 = point2.y - this.location1.y;
        StringBuffer stringBuffer = new StringBuffer("[");
        if (n > 0) {
            stringBuffer.append('+');
        }
        stringBuffer.append(n);
        stringBuffer.append(',');
        if (n2 > 0) {
            stringBuffer.append('+');
        }
        stringBuffer.append(n2);
        stringBuffer.append(']');
        this.showStatus(stringBuffer.toString());
        this.plate.pan(n - this.panDX, n2 - this.panDY);
        this.panDX = n;
        this.panDY = n2;
    }
}

