/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Pattern;
import de.jave.util.Toolbox;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;

public class PatternList {
    public static final String PATTERN_FILE_NAME = JaveGlobalRessources.codeBase + "/pattern/pattern.jcf";
    protected Vector patterns;

    public int getPatternCount() {
        if (this.patterns == null) {
            return -1;
        }
        return this.patterns.size();
    }

    public Pattern getPattern(int n) {
        if (this.patterns == null) {
            return null;
        }
        return (Pattern)this.patterns.elementAt(n);
    }

    public void delete(int n) {
        this.patterns.removeElementAt(n);
    }

    public void load() {
        this.patterns = new Vector();
        try {
            File file = new File(PATTERN_FILE_NAME);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            String string2 = null;
            String string3 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().length() == 0) continue;
                string2 = bufferedReader.readLine();
                if (string2 == null) {
                    throw new Exception("Unexpected End of Pattern File '" + PATTERN_FILE_NAME + "' !");
                }
                string3 = bufferedReader.readLine();
                if (string3 == null) {
                    throw new Exception("Unexpected End of Pattern File '" + PATTERN_FILE_NAME + "' !");
                }
                Pattern pattern = new Pattern(string, string3, string2);
                this.patterns.addElement(pattern);
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println("Error loading Pattern-File! " + exception);
        }
        Toolbox.quickSort(this.patterns);
    }

    public void add(Pattern pattern) {
        this.patterns.addElement(pattern);
    }

    public void save() {
        try {
            File file = new File(PATTERN_FILE_NAME);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            int n = 0;
            while (n < this.patterns.size()) {
                Pattern pattern = (Pattern)this.patterns.elementAt(n);
                bufferedWriter.write(pattern.getName());
                bufferedWriter.newLine();
                bufferedWriter.write(pattern.getAuthor());
                bufferedWriter.newLine();
                bufferedWriter.write(pattern.getCode());
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                ++n;
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.err.println("Error saving Pattern-File! " + exception);
        }
    }
}

