/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GBorderedPanel;
import de.jave.gui.GChoiceTextField;
import de.jave.gui.Gap;
import de.jave.jave.AsciiGradients;
import de.jave.jave.CharacterPlate;
import de.jave.jave.DialogTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveAsciiPacker;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.Polygon2d;
import de.jave.util.Toolbox;
import gebhard.uielements.NumberEvent;
import gebhard.uielements.NumberListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class Render3DTool
extends DialogTool
implements ItemListener,
NumberListener,
TextListener,
KeyListener {
    protected static final String TITLE = "3D Rendering Tool";
    protected static final double D = 3.0;
    protected Button bLeft;
    protected Button bRight;
    protected Button bIn;
    protected Button bOut;
    protected Button bReset;
    protected Button bAnimation;
    protected Checkbox cbNegative;
    protected Choice chDemo;
    protected Choice chStyle;
    protected GChoiceTextField tfGradient;
    protected static final String[] STYLES = new String[]{"Solid", "Wireframe", "High Resolution", "Shaded"};
    protected static final int WIREFRAME_VISIBLE = 0;
    protected static final int WIREFRAME = 1;
    protected static final int HIRES = 2;
    protected static final int SHADED = 3;
    protected static final int SOLID = 4;
    protected static final int SOLID_DEPTH = 5;
    protected TextArea taScript;
    protected int alpha = 0;
    protected double zoom = 7.0;
    protected static final double DEFAULT_ZOOM = 7.0;
    protected static final int DEFAULT_ALPHA = 0;
    protected String currentDirectory;
    protected static final String CUBE = "#Simple Cube demo - by Markus Gebhard 2001\n#This script has to contain two parts:\n# 1) List of vertices (3 float values, coordinates)\n# 2) List of polygons (3,4,... integer values, vertex indices)\n#Lines that do not fit this scheme are being ignored w/o warning!\n#\n#list of vertices:\n# x    y    z   \n 1.0  1.0  1.0\n-1.0  1.0  1.0\n 1.0 -1.0  1.0\n 1.0  1.0 -1.0\n 1.0 -1.0 -1.0\n-1.0 -1.0  1.0\n-1.0  1.0 -1.0\n-1.0 -1.0 -1.0\n\n#list of polygons:\n 0 1 5 2 \n 0 1 6 3 \n 0 3 4 2 \n 2 5 7 4 \n 1 6 7 5 \n 3 6 7 4 \n";
    protected static final String PYRAMID = "#Simple Pryramid demo - by Markus Gebhard 2001\n#This script has to contain two parts:\n# 1) List of vertices (3 float values, coordinates)\n# 2) List of polygons (3,4,... integer values, vertex indices)\n#Lines that do not fit this scheme are being ignored w/o warning!\n#\n#list of vertices:\n# x    y    z   \n 1.0 -1.0  1.0\n 1.0 -1.0 -1.0\n-1.0 -1.0  1.0\n-1.0 -1.0 -1.0\n 0.0  1.0  0.0\n\n#list of  polygons:\n 0 2 4 \n 0 1 4 \n 1 3 4 \n 2 3 4 \n 0 1 3 2 \n";
    protected static final String JAVE = "#Jave Logo - by Markus Gebhard 2001\n# list of vertices:\n# x    y    z   \n\n#(descriptions in german!)\n#Vordere a-Koordinaten\n -.3   .1   -.2\n -.3   .3   -.2\n -.2   .4   -.2\n  .2   .4   -.2\n  .3   .3   -.2\n  .3  -.4   -.2\n -.2  -.4   -.2\n -.3  -.3   -.2\n -.3   0    -.2\n -.2   .1   -.2\n  .1   .1   -.2\n  .1  -.1   -.2\n -.1  -.1   -.2\n -.1  -.2   -.2\n  .1  -.2   -.2\n  .1   .2   -.2\n -.2   .2   -.2\n \n#Hintere a-Koordinaten\n -.3   .1   .2\n -.3   .3   .2\n -.2   .4   .2\n  .2   .4   .2\n  .3   .3   .2\n  .3  -.4   .2\n -.2  -.4   .2\n -.3  -.3   .2\n -.3   0    .2\n -.2   .1   .2\n  .1   .1   .2\n  .1  -.1   .2\n -.1  -.1   .2\n -.1  -.2   .2\n  .1  -.2   .2\n  .1   .2   .2\n -.2   .2   .2\n\n\n#Diagonaler Strich links oben\n -.8 .7 0\n -.7 .8 0\n -.4 .5 0\n -.5 .4 0\n -.8 .7 .3\n -.7 .8 .3\n -.4 .5 .3\n -.5 .4 .3\n\n#Diagonaler Strich rechts oben\n  .8 .7 0\n  .7 .8 0\n  .4 .5 0\n  .5 .4 0\n  .8 .7 .3\n  .7 .8 .3\n  .4 .5 .3\n  .5 .4 .3\n\n#Diagonaler Strich links unten\n -.8 -.7 0\n -.7 -.8 0\n -.4 -.5 0\n -.5 -.4 0\n -.8 -.7 .3\n -.7 -.8 .3\n -.4 -.5 .3\n -.5 -.4 .3\n\n#Diagonaler Strich rechts unten\n  .8 -.7 0\n  .7 -.8 0\n  .4 -.5 0\n  .5 -.4 0\n  .8 -.7 .3\n  .7 -.8 .3\n  .4 -.5 .3\n  .5 -.4 .3\n\n#Waagrechter Strich oben\n  .3 .72 0\n  .3 .58 0\n -.3 .58 0\n -.3 .72 0\n  .3 .72 .3\n  .3 .58 .3\n -.3 .58 .3\n -.3 .72 .3\n\n#Waagrechter Strich unten\n  .3 -.72 0\n  .3 -.58 0\n -.3 -.58 0\n -.3 -.72 0\n  .3 -.72 .3\n  .3 -.58 .3\n -.3 -.58 .3\n -.3 -.72 .3\n\n#Senkrechter Strich rechts\n .72  .3  0\n .58  .3  0\n .58 -.3  0\n .72 -.3  0\n .72  .3  .3\n .58  .3  .3\n .58 -.3  .3\n .72 -.3  .3\n#Senkrechter Strich links\n -.72  .3  0\n -.58  .3  0\n -.58 -.3  0\n -.72 -.3  0\n -.72  .3  .3\n -.58  .3  .3\n -.58 -.3  .3\n -.72 -.3  .3\n\n##a Vorderseite\n 0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16\n##a R\u00fcckseite \n17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33\n\n#Diagonaler Strich links oben\n 34 35 36 37\n 38 39 40 41\n 38 34 35 39\n 39 35 36 40\n 40 36 37 41\n 41 37 34 38\n\n#Diagonaler Strich rechts oben (+8)\n 42 43 44 45\n 46 47 48 49\n 46 42 43 47\n 47 43 44 48\n 48 44 45 49\n 49 45 42 46\n\n#Diagonaler Strich links unten (+8)\n 50 51 52 53\n 54 55 56 57\n 54 50 51 55\n 55 51 52 56\n 56 52 53 57\n 57 53 50 54\n\n#Diagonaler Strich rechts unten (+8)\n 58 59 60 61\n 62 63 64 65\n 62 58 59 63\n 63 59 60 64\n 64 60 61 65\n 65 61 58 62\n\n#Waagrechter Strich oben (+8)\n 66 67 68 69\n 70 71 72 73\n 70 66 67 71\n 71 67 68 72\n 72 68 69 73\n 73 69 66 70\n\n#Waagrechter Strich unten (+8)\n 74 75 76 77\n 78 79 80 81\n 78 74 75 79\n 79 75 76 80\n 80 76 77 81\n 81 77 74 78\n\n#Senkrechter Strich rechts (+8)\n 82 83 84 85\n 86 87 88 89\n 86 82 83 87\n 87 83 84 88\n 88 84 85 89\n 89 85 82 86\n\n#Senkrechter Strich links (+8)\n 90 91 92 93\n 94 95 96 97\n 94 90 91 95\n 95 91 92 96\n 96 92 93 97\n 97 93 90 94\n\n#Seitenteile fuer das a zur Verbindung Vorder-/R\u00fcckseite\n 0 17 18  1\n 1 18 19  2\n 2 19 20  3\n 3 20 21  4\n 4 21 22  5\n 5 22 23  6\n 6 23 24  7\n 7 24 25  8\n 8 25 26  9\n 9 26 27 10\n10 27 28 11\n11 28 29 12\n12 29 30 13\n13 30 31 14\n14 31 32 15\n15 32 33 16\n16 33 17  0";
    protected static final String[] DEMOS = new String[]{"Pyramid", "#Simple Pryramid demo - by Markus Gebhard 2001\n#This script has to contain two parts:\n# 1) List of vertices (3 float values, coordinates)\n# 2) List of polygons (3,4,... integer values, vertex indices)\n#Lines that do not fit this scheme are being ignored w/o warning!\n#\n#list of vertices:\n# x    y    z   \n 1.0 -1.0  1.0\n 1.0 -1.0 -1.0\n-1.0 -1.0  1.0\n-1.0 -1.0 -1.0\n 0.0  1.0  0.0\n\n#list of  polygons:\n 0 2 4 \n 0 1 4 \n 1 3 4 \n 2 3 4 \n 0 1 3 2 \n", "Cube", "#Simple Cube demo - by Markus Gebhard 2001\n#This script has to contain two parts:\n# 1) List of vertices (3 float values, coordinates)\n# 2) List of polygons (3,4,... integer values, vertex indices)\n#Lines that do not fit this scheme are being ignored w/o warning!\n#\n#list of vertices:\n# x    y    z   \n 1.0  1.0  1.0\n-1.0  1.0  1.0\n 1.0 -1.0  1.0\n 1.0  1.0 -1.0\n 1.0 -1.0 -1.0\n-1.0 -1.0  1.0\n-1.0  1.0 -1.0\n-1.0 -1.0 -1.0\n\n#list of polygons:\n 0 1 5 2 \n 0 1 6 3 \n 0 3 4 2 \n 2 5 7 4 \n 1 6 7 5 \n 3 6 7 4 \n", "JavE Logo", "#Jave Logo - by Markus Gebhard 2001\n# list of vertices:\n# x    y    z   \n\n#(descriptions in german!)\n#Vordere a-Koordinaten\n -.3   .1   -.2\n -.3   .3   -.2\n -.2   .4   -.2\n  .2   .4   -.2\n  .3   .3   -.2\n  .3  -.4   -.2\n -.2  -.4   -.2\n -.3  -.3   -.2\n -.3   0    -.2\n -.2   .1   -.2\n  .1   .1   -.2\n  .1  -.1   -.2\n -.1  -.1   -.2\n -.1  -.2   -.2\n  .1  -.2   -.2\n  .1   .2   -.2\n -.2   .2   -.2\n \n#Hintere a-Koordinaten\n -.3   .1   .2\n -.3   .3   .2\n -.2   .4   .2\n  .2   .4   .2\n  .3   .3   .2\n  .3  -.4   .2\n -.2  -.4   .2\n -.3  -.3   .2\n -.3   0    .2\n -.2   .1   .2\n  .1   .1   .2\n  .1  -.1   .2\n -.1  -.1   .2\n -.1  -.2   .2\n  .1  -.2   .2\n  .1   .2   .2\n -.2   .2   .2\n\n\n#Diagonaler Strich links oben\n -.8 .7 0\n -.7 .8 0\n -.4 .5 0\n -.5 .4 0\n -.8 .7 .3\n -.7 .8 .3\n -.4 .5 .3\n -.5 .4 .3\n\n#Diagonaler Strich rechts oben\n  .8 .7 0\n  .7 .8 0\n  .4 .5 0\n  .5 .4 0\n  .8 .7 .3\n  .7 .8 .3\n  .4 .5 .3\n  .5 .4 .3\n\n#Diagonaler Strich links unten\n -.8 -.7 0\n -.7 -.8 0\n -.4 -.5 0\n -.5 -.4 0\n -.8 -.7 .3\n -.7 -.8 .3\n -.4 -.5 .3\n -.5 -.4 .3\n\n#Diagonaler Strich rechts unten\n  .8 -.7 0\n  .7 -.8 0\n  .4 -.5 0\n  .5 -.4 0\n  .8 -.7 .3\n  .7 -.8 .3\n  .4 -.5 .3\n  .5 -.4 .3\n\n#Waagrechter Strich oben\n  .3 .72 0\n  .3 .58 0\n -.3 .58 0\n -.3 .72 0\n  .3 .72 .3\n  .3 .58 .3\n -.3 .58 .3\n -.3 .72 .3\n\n#Waagrechter Strich unten\n  .3 -.72 0\n  .3 -.58 0\n -.3 -.58 0\n -.3 -.72 0\n  .3 -.72 .3\n  .3 -.58 .3\n -.3 -.58 .3\n -.3 -.72 .3\n\n#Senkrechter Strich rechts\n .72  .3  0\n .58  .3  0\n .58 -.3  0\n .72 -.3  0\n .72  .3  .3\n .58  .3  .3\n .58 -.3  .3\n .72 -.3  .3\n#Senkrechter Strich links\n -.72  .3  0\n -.58  .3  0\n -.58 -.3  0\n -.72 -.3  0\n -.72  .3  .3\n -.58  .3  .3\n -.58 -.3  .3\n -.72 -.3  .3\n\n##a Vorderseite\n 0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16\n##a R\u00fcckseite \n17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33\n\n#Diagonaler Strich links oben\n 34 35 36 37\n 38 39 40 41\n 38 34 35 39\n 39 35 36 40\n 40 36 37 41\n 41 37 34 38\n\n#Diagonaler Strich rechts oben (+8)\n 42 43 44 45\n 46 47 48 49\n 46 42 43 47\n 47 43 44 48\n 48 44 45 49\n 49 45 42 46\n\n#Diagonaler Strich links unten (+8)\n 50 51 52 53\n 54 55 56 57\n 54 50 51 55\n 55 51 52 56\n 56 52 53 57\n 57 53 50 54\n\n#Diagonaler Strich rechts unten (+8)\n 58 59 60 61\n 62 63 64 65\n 62 58 59 63\n 63 59 60 64\n 64 60 61 65\n 65 61 58 62\n\n#Waagrechter Strich oben (+8)\n 66 67 68 69\n 70 71 72 73\n 70 66 67 71\n 71 67 68 72\n 72 68 69 73\n 73 69 66 70\n\n#Waagrechter Strich unten (+8)\n 74 75 76 77\n 78 79 80 81\n 78 74 75 79\n 79 75 76 80\n 80 76 77 81\n 81 77 74 78\n\n#Senkrechter Strich rechts (+8)\n 82 83 84 85\n 86 87 88 89\n 86 82 83 87\n 87 83 84 88\n 88 84 85 89\n 89 85 82 86\n\n#Senkrechter Strich links (+8)\n 90 91 92 93\n 94 95 96 97\n 94 90 91 95\n 95 91 92 96\n 96 92 93 97\n 97 93 90 94\n\n#Seitenteile fuer das a zur Verbindung Vorder-/R\u00fcckseite\n 0 17 18  1\n 1 18 19  2\n 2 19 20  3\n 3 20 21  4\n 4 21 22  5\n 5 22 23  6\n 6 23 24  7\n 7 24 25  8\n 8 25 26  9\n 9 26 27 10\n10 27 28 11\n11 28 29 12\n12 29 30 13\n13 30 31 14\n14 31 32 15\n15 32 33 16\n16 33 17  0"};

    public Render3DTool(Jave jave, Plate plate) {
        super(jave, plate);
        this.render();
        this.addKeyListener(this);
    }

    protected Dimension getPreferredPlateSize() {
        return JaveGlobalRessources.getDefaultDocumentDimension();
    }

    protected int getPreferredColorScheme() {
        return 1;
    }

    protected String getToolTitle() {
        return TITLE;
    }

    public String getToolActionName() {
        return "render 3D";
    }

    public Component getOptionsComponent() {
        this.taScript = new TextArea(DEMOS[1], 9, 40);
        this.taScript.addTextListener(this);
        this.taScript.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.bAnimation = new Button("Save Animation");
        this.bAnimation.addActionListener(this);
        GBorderedPanel gBorderedPanel = new GBorderedPanel("Navigation");
        this.bLeft = new Button("Rotate left");
        this.bLeft.addActionListener(this);
        gBorderedPanel.add(this.bLeft);
        this.bRight = new Button("Rotate right");
        this.bRight.addActionListener(this);
        gBorderedPanel.add(this.bRight);
        this.bOut = new Button("Zoom Out");
        this.bOut.addActionListener(this);
        gBorderedPanel.add(this.bOut);
        this.bIn = new Button("Zoom In");
        this.bIn.addActionListener(this);
        gBorderedPanel.add(this.bIn);
        this.bReset = new Button("Reset");
        this.bReset.addActionListener(this);
        gBorderedPanel.add(this.bReset);
        gBorderedPanel.add(new Gap());
        gBorderedPanel.add(this.bAnimation);
        this.chDemo = new Choice();
        int n = 0;
        while (n < DEMOS.length) {
            this.chDemo.add(DEMOS[n]);
            n += 2;
        }
        this.chDemo.addItemListener(this);
        this.chStyle = new Choice();
        int n2 = 0;
        while (n2 < STYLES.length) {
            this.chStyle.add(STYLES[n2]);
            ++n2;
        }
        this.chStyle.addItemListener(this);
        this.tfGradient = AsciiGradients.createComponent();
        this.tfGradient.addTextListener(this);
        Panel panel = new Panel();
        panel.add(new Label("Demos:", 2));
        panel.add(this.chDemo);
        panel.add(new Label("Style:", 2));
        panel.add(this.chStyle);
        panel.add(this.tfGradient);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(2, 2));
        panel2.add((Component)gBorderedPanel, "North");
        panel2.add((Component)panel, "South");
        panel2.add((Component)this.taScript, "Center");
        panel2.addKeyListener(this);
        panel.addKeyListener(this);
        gBorderedPanel.addKeyListener(this);
        this.bLeft.addKeyListener(this);
        this.bRight.addKeyListener(this);
        this.bOut.addKeyListener(this);
        this.bIn.addKeyListener(this);
        this.tfGradient.setEnabled(this.chStyle.getSelectedIndex() == 3);
        return panel2;
    }

    protected void doRotateLeft() {
        this.alpha -= 5;
        this.render();
    }

    protected void doRotateRight() {
        this.alpha += 5;
        this.render();
    }

    protected void doZoomIn() {
        this.zoom *= 1.2;
        this.render();
    }

    protected void doZoomOut() {
        this.zoom *= 0.8333333333333334;
        this.render();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 37) {
            this.doRotateLeft();
            keyEvent.consume();
            return;
        }
        if (n == 39) {
            this.doRotateRight();
            keyEvent.consume();
            return;
        }
        if (n == 38) {
            this.doZoomIn();
            keyEvent.consume();
            return;
        }
        if (n == 40) {
            this.doZoomOut();
            keyEvent.consume();
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.bReset) {
            this.alpha = 0;
            this.zoom = 7.0;
            this.render();
            return;
        }
        if (object == this.bLeft) {
            this.doRotateLeft();
            return;
        }
        if (object == this.bRight) {
            this.doRotateRight();
            return;
        }
        if (object == this.bIn) {
            this.doZoomIn();
            return;
        }
        if (object == this.bOut) {
            this.doZoomOut();
            return;
        }
        if (object == this.bAnimation) {
            this.animate();
            return;
        }
    }

    protected void render() {
        if (this.markPlate == null) {
            this.markPlate = new PixelPlate(0, 0, this.plateWidth, this.plateHeight);
        }
        double d = this.plateWidth / 2;
        double d2 = this.plateHeight / 2;
        int n = this.chStyle.getSelectedIndex();
        String string = this.tfGradient.getText();
        if (string.length() == 0) {
            string = " ";
        }
        Render3DTool.render(this.markPlate, this.taScript.getText(), n, string, this.alpha, 3.0, this.zoom, d, d2);
        this.characterPlate.clear();
        this.markPlate.convert();
        this.markPlate.pasteResultInto(this.characterPlate);
        this.repaintPlate();
    }

    public static final void render(PixelPlate pixelPlate, String string, int n, String string2, double d, double d2, double d3, double d4, double d5) {
        double d6;
        switch (n) {
            case 2: {
                pixelPlate.setMode(0);
                break;
            }
            case 0: 
            case 1: {
                pixelPlate.setMode(2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                pixelPlate.setMode(1);
            }
        }
        pixelPlate.clear();
        double d7 = d3 * 1.98;
        double d8 = d3;
        int n2 = pixelPlate.getVirtualWidth();
        int n3 = pixelPlate.getVirtualHeight();
        double d9 = n2 / pixelPlate.getWidth();
        double d10 = n3 / pixelPlate.getHeight();
        double[][] dArray = new double[n3][n2];
        int n4 = 0;
        while (n4 < n2) {
            dArray[0][n4] = Double.MAX_VALUE;
            ++n4;
        }
        int n5 = 1;
        while (n5 < n3) {
            System.arraycopy(dArray[0], 0, dArray[n5], 0, n2);
            ++n5;
        }
        int[][] nArray = new int[n3][n2];
        boolean bl = false;
        Vector<double[]> vector = new Vector<double[]>();
        Vector<Integer> vector2 = new Vector<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            StringTokenizer stringTokenizer2;
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.length() == 0 || string3.charAt(0) == '#' || string3.startsWith("AlWuzEre")) continue;
            if (!bl && string3.indexOf(46) == -1 && string3.indexOf(45) == -1) {
                bl = true;
            }
            if (!bl) {
                try {
                    stringTokenizer2 = new StringTokenizer(string3, " \t", false);
                    d6 = Double.valueOf(stringTokenizer2.nextToken());
                    double d11 = Double.valueOf(stringTokenizer2.nextToken());
                    double d12 = Double.valueOf(stringTokenizer2.nextToken());
                    object = Render3DTool.transform(d6, d11, d12, d, d2, d7, d8, d4, d5);
                    vector.addElement((double[])object);
                }
                catch (Exception exception) {
                    System.err.println("Warning: Line '" + string3 + "' seems to be invalid. - ignored");
                }
                continue;
            }
            try {
                int n7;
                double d13;
                double d14;
                ++n6;
                stringTokenizer2 = new StringTokenizer(string3, " \t", false);
                int n8 = stringTokenizer2.countTokens();
                int[] nArray2 = new int[n8];
                int n9 = 0;
                while (n9 < n8) {
                    nArray2[n9] = Integer.parseInt(stringTokenizer2.nextToken());
                    ++n9;
                }
                if (n == 1) {
                    int n10 = 0;
                    while (n10 < n8) {
                        double[] dArray2 = (double[])vector.elementAt(nArray2[n10]);
                        double[] dArray3 = (double[])vector.elementAt(nArray2[(n10 + 1) % n8]);
                        pixelPlate.drawLine(dArray2[0] + d4, dArray2[1] + d5, dArray3[0] + d4, dArray3[1] + d5);
                        ++n10;
                    }
                    continue;
                }
                double[] dArray4 = new double[n8];
                double[] dArray5 = new double[n8];
                int n11 = 0;
                while (n11 < n8) {
                    object = (double[])vector.elementAt(nArray2[n11]);
                    dArray4[n11] = object[0] * d9;
                    dArray5[n11] = object[1] * d10;
                    ++n11;
                }
                object = new Polygon2d(dArray4, dArray5);
                double[] dArray6 = (double[])vector.elementAt(nArray2[0]);
                double[] dArray7 = (double[])vector.elementAt(nArray2[1]);
                double[] dArray8 = (double[])vector.elementAt(nArray2[2]);
                double d15 = dArray6[3] - dArray7[3];
                double d16 = dArray6[4] - dArray7[4];
                double d17 = dArray6[2] - dArray7[2];
                double d18 = dArray8[3] - dArray7[3];
                double d19 = dArray8[4] - dArray7[4];
                double d20 = dArray8[2] - dArray7[2];
                double d21 = d16 * d20 - d17 * d19;
                double d22 = d17 * d18 - d15 * d20;
                double d23 = d15 * d19 - d16 * d18;
                double d24 = Math.sqrt(d21 * d21 + d22 * d22 + d23 * d23);
                d21 /= d24;
                d22 /= d24;
                d23 /= d24;
                d15 = dArray6[5] - dArray7[5];
                d16 = dArray6[6] - dArray7[6];
                d17 = dArray6[7] - dArray7[7];
                d18 = dArray8[5] - dArray7[5];
                d19 = dArray8[6] - dArray7[6];
                d20 = dArray8[7] - dArray7[7];
                double d25 = d16 * d20 - d17 * d19;
                double d26 = d17 * d18 - d15 * d20;
                double d27 = d15 * d19 - d16 * d18;
                d24 = Math.sqrt(d25 * d25 + d26 * d26 + d27 * d27);
                d25 /= d24;
                d26 /= d24;
                d27 /= d24;
                double d28 = 1.0;
                double d29 = -1.0;
                double d30 = 2.0;
                if ((d14 = 57.29577951308232 * Math.acos(d13 = (d28 /= (d24 = Math.sqrt(d28 * d28 + d29 * d29 + d30 * d30))) * d25 + (d29 /= d24) * d26 + (d30 /= d24) * d27)) > 90.0) {
                    d14 = 180.0 - d14;
                }
                if ((n7 = (int)(d14 / 90.0 * (double)string2.length())) >= string2.length()) {
                    n7 = string2.length() - 1;
                }
                vector2.addElement(new Integer(n7));
                double d31 = dArray6[3] - 0.0;
                double d32 = dArray6[4] - 0.0;
                double d33 = dArray6[2] + d2;
                int n12 = (int)(((Polygon2d)object).minY + d5 * d10) - 1;
                int n13 = (int)(((Polygon2d)object).maxY + d5 * d10) + 1;
                int n14 = (int)(((Polygon2d)object).minX + d4 * d9) - 1;
                int n15 = (int)(((Polygon2d)object).maxX + d4 * d9) + 1;
                if (n12 < 0) {
                    n12 = 0;
                }
                if (n14 < 0) {
                    n14 = 0;
                }
                if (n15 >= n2) {
                    n15 = n2 - 1;
                }
                if (n13 >= n3) {
                    n13 = n3 - 1;
                }
                int n16 = n12;
                while (n16 <= n13) {
                    int n17 = n14;
                    while (n17 <= n15) {
                        double d34;
                        double d35;
                        double d36;
                        if (((Polygon2d)object).contains((double)n17 - d4 * d9, (double)n16 - d5 * d10) && (d36 = Render3DTool.getDepth(d35 = (double)n17 / d9 - d4, d34 = (double)n16 / d10 - d5, d2, d21, d22, d23, d31, d32, d33)) < dArray[n16][n17]) {
                            dArray[n16][n17] = d36;
                            nArray[n16][n17] = n6;
                        }
                        ++n17;
                    }
                    ++n16;
                }
            }
            catch (Exception exception) {
                System.err.println("Warning: Line '" + string3 + "' seems to be invalid. - ignored");
            }
        }
        if (n == 0 || n == 2) {
            int n18 = 0;
            while (n18 < n3) {
                int n19 = 0;
                while (n19 < n2) {
                    if (nArray[n18][n19] > 0) {
                        if (n19 + 1 < n2 && nArray[n18][n19 + 1] != nArray[n18][n19]) {
                            pixelPlate.set(n19, n18);
                        } else if (n18 + 1 < n3 && nArray[n18 + 1][n19] != nArray[n18][n19]) {
                            pixelPlate.set(n19, n18);
                        } else if (n19 + 1 < n2 && nArray[n18][n19 + 1] == 0) {
                            pixelPlate.set(n19, n18);
                        } else if (n18 + 1 < n3 && nArray[n18 + 1][n19] == 0) {
                            pixelPlate.set(n19, n18);
                        } else if (n19 > 0 && nArray[n18][n19 - 1] == 0) {
                            pixelPlate.set(n19, n18);
                        } else if (n18 > 0 && nArray[n18 - 1][n19] == 0) {
                            pixelPlate.set(n19, n18);
                        }
                    }
                    ++n19;
                }
                ++n18;
            }
        } else if (n == 4) {
            int n20 = 0;
            while (n20 < n3) {
                int n21 = 0;
                while (n21 < n2) {
                    pixelPlate.set(n21, n20, " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ#*+-:?!()[]{}@".charAt(nArray[n20][n21]));
                    ++n21;
                }
                ++n20;
            }
        } else if (n == 3) {
            int n22 = 0;
            while (n22 < n3) {
                int n23 = 0;
                while (n23 < n2) {
                    if (nArray[n22][n23] > 0) {
                        int n24 = (Integer)vector2.elementAt(nArray[n22][n23] - 1);
                        pixelPlate.set(n23, n22, string2.charAt(string2.length() - n24 - 1));
                    }
                    ++n23;
                }
                ++n22;
            }
        } else {
            double d37 = 0.0;
            d6 = 0.0;
            int n25 = 0;
            while (n25 < n3) {
                int n26 = 0;
                while (n26 < n2) {
                    if (dArray[n25][n26] < d37) {
                        d37 = dArray[n25][n26];
                    }
                    if (dArray[n25][n26] > d6 && dArray[n25][n26] < Double.MAX_VALUE) {
                        d6 = dArray[n25][n26];
                    }
                    ++n26;
                }
                ++n25;
            }
            int n27 = 0;
            while (n27 < n3) {
                int n28 = 0;
                while (n28 < n2) {
                    if (!(dArray[n27][n28] > d6)) {
                        int n29 = (int)((dArray[n27][n28] - d37) / (d6 - d37) * (double)string2.length());
                        if (n29 < 0) {
                            n29 = 0;
                        } else if (n29 >= string2.length()) {
                            n29 = string2.length() - 1;
                        }
                        pixelPlate.set(n28, n27, string2.charAt(n29));
                    }
                    ++n28;
                }
                ++n27;
            }
        }
    }

    public static final double getDepth(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d - 0.0;
        double d11 = d2 - 0.0;
        double d12 = d3;
        double d13 = (d7 * d4 + d8 * d5 + d9 * d6) / (d10 * d4 + d11 * d5 + d12 * d6);
        return d13;
    }

    public static final double[] transform(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d4 / 180.0 * Math.PI;
        double d11 = d * Math.cos(d10) + d3 * Math.sin(d10);
        double d12 = d2;
        double d13 = d3 * Math.cos(d10) - d * Math.sin(d10);
        double d14 = d11;
        double d15 = d12;
        double d16 = d13;
        double d17 = (d11 *= d6) / (d13 / d5 + 1.0);
        double d18 = (d12 *= -d7) / (d13 / d5 + 1.0);
        return new double[]{d17, d18, d13, d11, d12, d14, d15, d16};
    }

    public void numberChanged(NumberEvent numberEvent) {
        this.render();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.render();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.chDemo) {
            this.taScript.setText(DEMOS[this.chDemo.getSelectedIndex() * 2 + 1]);
            this.render();
            return;
        }
        if (object == this.chStyle) {
            this.tfGradient.setEnabled(this.chStyle.getSelectedIndex() == 3);
            this.render();
            return;
        }
    }

    protected void animate() {
        FileDialog fileDialog = new FileDialog((Frame)this.jave, "SavE Animation as Jave Movie File", 1);
        if (this.currentDirectory != null) {
            fileDialog.setDirectory(this.currentDirectory);
        }
        fileDialog.setFile("*.jmov");
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null) {
            return;
        }
        double d = this.plateWidth / 2;
        double d2 = this.plateHeight / 2;
        int n = this.chStyle.getSelectedIndex();
        String string3 = this.tfGradient.getText();
        if (string3.length() == 0) {
            string3 = " ";
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2 + string));
            bufferedWriter.write("*:JavE 5.0 (3D Rendering Tool)");
            bufferedWriter.newLine();
            bufferedWriter.write("D:" + Toolbox.getDateString());
            bufferedWriter.newLine();
            bufferedWriter.write("C:#000000 #FFFFFF");
            bufferedWriter.newLine();
            PixelPlate pixelPlate = new PixelPlate(0, 0, this.plateWidth, this.plateHeight);
            pixelPlate.setMode(2);
            int n2 = 0;
            while (n2 < 360) {
                pixelPlate.clear();
                Render3DTool.render(pixelPlate, this.taScript.getText(), n, string3, this.alpha + n2, 3.0, this.zoom, d, d2);
                CharacterPlate characterPlate = pixelPlate.getResult();
                characterPlate.replace('\u0000', ' ');
                bufferedWriter.write("J:");
                bufferedWriter.write(JaveAsciiPacker.encode(characterPlate));
                bufferedWriter.newLine();
                n2 += 3;
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
            System.err.println("Error saving File: " + exception);
            return;
        }
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n <= 360) {
            double d = (double)n / 180.0 * Math.PI;
            double d2 = Math.sin(d);
            double d3 = Math.cos(d);
            System.err.print(Toolbox.round(d2, 3) + " " + Toolbox.round(d3, 3) + " -1.0" + "\n");
            System.err.print(Toolbox.round(d2, 3) + " " + Toolbox.round(d3, 3) + " 1.0" + "\n");
            n += 15;
        }
        int n2 = 0;
        while (n2 < 360) {
            int n3 = 2 * (n2 / 15);
            int n4 = n3 + 1;
            int n5 = n4 + 2;
            int n6 = n4 + 1;
            System.err.print(n3 + " " + n4 + " " + n5 + " " + n6 + "\n");
            n2 += 15;
        }
    }
}

