/*
 * Decompiled with CFR 0.152.
 */
package de.jave.undo;

import de.jave.undo.DefaultUndoState;
import de.jave.undo.LogFile;
import de.jave.undo.UndoItem;
import de.jave.undo.UndoState;

public class UndoManager {
    protected UndoItem currentItem;
    protected UndoItem firstItem;
    protected boolean truncated;
    protected int maxSize;
    protected LogFile logFile;

    public UndoManager(Object object) {
        this(new DefaultUndoState(object));
    }

    public UndoManager(UndoState undoState) {
        this.firstItem = this.currentItem = new UndoItem(undoState);
        this.truncated = false;
        this.logFile = null;
    }

    public void setLogFile(LogFile logFile) {
        this.logFile = logFile;
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public String getLogFileName() {
        if (this.logFile == null) {
            return null;
        }
        return this.logFile.getAbsolutePath();
    }

    public boolean isLogging() {
        return this.logFile != null;
    }

    public synchronized void saveCurrentState(Object object) {
        this.saveCurrentState(new DefaultUndoState(object));
    }

    public synchronized void saveCurrentState(UndoState undoState) {
        UndoItem undoItem;
        this.currentItem.next = undoItem = new UndoItem(undoState);
        undoItem.prev = this.currentItem;
        this.currentItem = undoItem;
        this.ensureMaxSize();
        if (this.logFile != null) {
            this.logFile.append(undoState);
        }
    }

    public synchronized boolean canUndo() {
        return this.currentItem.prev != null;
    }

    public synchronized boolean isModified() {
        return this.truncated || this.currentItem.prev == null;
    }

    public synchronized UndoState undo() {
        this.currentItem = this.currentItem.prev;
        UndoState undoState = this.currentItem.getUndoState();
        return undoState;
    }

    public synchronized UndoState getNextState() {
        if (this.currentItem.next == null) {
            return null;
        }
        return this.currentItem.next.getUndoState();
    }

    public synchronized boolean canRedo() {
        return this.currentItem.next != null;
    }

    public synchronized UndoState redo() {
        this.currentItem = this.currentItem.next;
        UndoState undoState = this.currentItem.getUndoState();
        return undoState;
    }

    public synchronized String getUndoActionName() {
        String string = this.currentItem.getUndoActionName();
        if (string != null) {
            return string;
        }
        return "";
    }

    public synchronized String getRedoActionName() {
        UndoItem undoItem = this.currentItem.next;
        if (undoItem == null) {
            return "";
        }
        String string = undoItem.getUndoActionName();
        if (string != null) {
            return string;
        }
        return "";
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
        this.ensureMaxSize();
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void ensureMaxSize() {
        if (this.maxSize <= 0) {
            return;
        }
        var1_1 = this.firstItem;
        var2_2 = 0;
        while (var1_1 != null) {
            var2_2 += var1_1.getEstimatedMemorySize();
            var1_1 = var1_1.next;
        }
        if (var2_2 > this.maxSize) ** GOTO lbl15
        return;
lbl-1000:
        // 1 sources

        {
            this.truncated = true;
            var2_2 -= this.firstItem.getEstimatedMemorySize();
            this.firstItem = this.firstItem.next;
            this.firstItem.prev = null;
lbl15:
            // 2 sources

            ** while (var2_2 > this.maxSize && this.currentItem != this.firstItem.next)
        }
lbl16:
        // 1 sources

    }

    public void print() {
        System.out.println("-------------");
        if (this.currentItem == null) {
            System.out.println("LEER");
            return;
        }
        if (this.truncated) {
            System.out.println("*truncated*");
        }
        UndoItem undoItem = this.firstItem;
        int n = 0;
        while (undoItem != null) {
            if (undoItem == this.currentItem) {
                System.out.print("* ");
            } else {
                System.out.print("  ");
            }
            undoItem.print();
            n += undoItem.getEstimatedMemorySize();
            undoItem = undoItem.next;
        }
        if (n > 0) {
            System.err.println(" => " + n + " Bytes");
        }
    }

    public static void main(String[] stringArray) {
        String string = "";
        UndoManager undoManager = new UndoManager(string);
        undoManager.print();
        string = string + "A";
        undoManager.saveCurrentState(string);
        string = string + "B";
        undoManager.saveCurrentState(string);
        string = string + "C";
        undoManager.saveCurrentState(string);
        string = undoManager.undo().toString();
        string = undoManager.undo().toString();
        string = string + "D";
        undoManager.saveCurrentState(string);
    }
}

