/*
 * Decompiled with CFR 0.152.
 */
package net.jmge.gif;

import java.io.IOException;
import java.io.OutputStream;

class GifPixelsEncoder {
    private static final int EOF = -1;
    private int imgW;
    private int imgH;
    private byte[] pixAry;
    private boolean wantInterlaced;
    private int initCodeSize;
    private int countDown;
    private int xCur;
    private int yCur;
    private int curPass;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    GifPixelsEncoder(int n, int n2, byte[] byArray, boolean bl, int n3) {
        this.imgW = n;
        this.imgH = n2;
        this.pixAry = byArray;
        this.wantInterlaced = bl;
        this.initCodeSize = Math.max(2, n3);
    }

    void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.initCodeSize);
        this.countDown = this.imgW * this.imgH;
        this.curPass = 0;
        this.yCur = 0;
        this.xCur = 0;
        this.compress(this.initCodeSize + 1, outputStream);
        outputStream.write(0);
    }

    private void bumpPosition() {
        ++this.xCur;
        if (this.xCur == this.imgW) {
            this.xCur = 0;
            if (!this.wantInterlaced) {
                ++this.yCur;
            } else {
                switch (this.curPass) {
                    case 0: {
                        this.yCur += 8;
                        if (this.yCur < this.imgH) break;
                        ++this.curPass;
                        this.yCur = 4;
                        break;
                    }
                    case 1: {
                        this.yCur += 8;
                        if (this.yCur < this.imgH) break;
                        ++this.curPass;
                        this.yCur = 2;
                        break;
                    }
                    case 2: {
                        this.yCur += 4;
                        if (this.yCur < this.imgH) break;
                        ++this.curPass;
                        this.yCur = 1;
                        break;
                    }
                    case 3: {
                        this.yCur += 2;
                    }
                }
            }
        }
    }

    private int nextPixel() {
        if (this.countDown == 0) {
            return -1;
        }
        --this.countDown;
        byte by = this.pixAry[this.yCur * this.imgW + this.xCur];
        this.bumpPosition();
        return by & 0xFF;
    }

    final int MAXCODE(int n) {
        return (1 << n) - 1;
    }

    void compress(int n, OutputStream outputStream) throws IOException {
        int n2;
        this.g_init_bits = n;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << n - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int n3 = this.nextPixel();
        int n4 = 0;
        int n5 = this.hsize;
        while (n5 < 65536) {
            ++n4;
            n5 *= 2;
        }
        n4 = 8 - n4;
        int n6 = this.hsize;
        this.cl_hash(n6);
        this.output(this.ClearCode, outputStream);
        block1: while ((n2 = this.nextPixel()) != -1) {
            int n7 = n2 << n4 ^ n3;
            n5 = (n2 << this.maxbits) + n3;
            if (this.htab[n7] == n5) {
                n3 = this.codetab[n7];
                continue;
            }
            if (this.htab[n7] >= 0) {
                int n8 = n6 - n7;
                if (n7 == 0) {
                    n8 = 1;
                }
                do {
                    if ((n7 -= n8) < 0) {
                        n7 += n6;
                    }
                    if (this.htab[n7] != n5) continue;
                    n3 = this.codetab[n7];
                    continue block1;
                } while (this.htab[n7] >= 0);
            }
            this.output(n3, outputStream);
            n3 = n2;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[n7] = n5;
                continue;
            }
            this.cl_block(outputStream);
        }
        this.output(n3, outputStream);
        this.output(this.EOFCode, outputStream);
    }

    void output(int n, OutputStream outputStream) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= n << this.cur_bits) : n;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (n == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outputStream);
        }
    }

    void cl_block(OutputStream outputStream) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outputStream);
    }

    void cl_hash(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.htab[n2] = -1;
            ++n2;
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte by, OutputStream outputStream) throws IOException {
        this.accum[this.a_count++] = by;
        if (this.a_count >= 254) {
            this.flush_char(outputStream);
        }
    }

    void flush_char(OutputStream outputStream) throws IOException {
        if (this.a_count > 0) {
            outputStream.write(this.a_count);
            outputStream.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }
}

