#!/usr/bin/env ruby

require 'cgi'
require 'open3'
require 'nkf'

load 'log.conf'

log = ""
html = ""
LIST_MAX = 10

Open3.popen3("/bin/grep 'que' #{QLC_LOG_FILE}"){|stdin, stdout, stderr|
  log = stdout.read
}

html << <<-_HTML
<table summary="" id="querylog">
<tr><th></th><th></th><th>IPɥ쥹</th></tr>
_HTML
tr_class = true
list = 0
log.to_a.reverse.each{|s|
  tmp = s.split(/ /)
  if /jcp/ =~ tmp[6] and /query=([^;&" ]+)/ =~ tmp[10]
    ip, date, query = tmp[0], tmp[3] + "]", NKF.nkf("-Se", CGI.unescape($1))
  elsif /jcp/ =~ tmp[6] and /szquely=([^;&" ]+)/ =~ tmp[10]
    ip, date, query = tmp[0], tmp[3] + "]", CGI.unescape($1.to_s)
  else
    next
  end
  a_start = ""
  a_end = ""
  if QLC_SUZURAN_URL != ""
    url = QLC_SUZURAN_URL
    if !(/^http/ =~ url)
      url = "http://" + url
    end
    a_start = "<a href=\"#{url}?szquely=#{CGI.escape(query)}\">"
    a_end   = "</a>"
  end
  html << <<-_HTML
    <tr class="tr#{tr_class}"><td class="query">#{a_start + query + a_end}</td><td class="date">#{date}</td><td class="ip">#{ip}</td></tr>
  _HTML
  tr_class = !tr_class
  list += 1
  if list >= LIST_MAX
    break
  end
}
html << <<-_HTML
</table>
_HTML

cgi = CGI.new
cgi.out({"type" => "text/html", "charset" => "euc-jp", "expires" => Time.now }){html}
