package jp.sourceforge.sxdbutils.mapping;

import java.util.Map;

import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;

/**
 * 中間マッピング名にプロパティ名、カラム名がそのまま使用される {@link NameMapping}実装です。
 * 
 * @author chinpei
 * 
 */
public class ColumnNameMapping implements NameMapping {

	public String toIntermediateNameFromAttrName(String bindObjectName) {
		return bindObjectName;
	}

	public Map createIntermediateMap() {
		return new CaseInsensitiveHashMap();
	}

	public String toIntermediateNameFromColumnName(String columnName) {
		return columnName;
	}
	public String toColumnNameFromAttrName(String bindObjectName) {
		return bindObjectName;
	}

}
