package jp.sourceforge.sxdbutils.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectionUtil {
	private static final Object[] NULL_OBJECT_ARRAY = new Object[0];

	private ReflectionUtil() {
	}

	public static Object invoke(Object obj, Method method) {
		return invoke(obj, method, NULL_OBJECT_ARRAY);
	}

	public static Object invoke(Object obj, Method method, Object arg1) {
		return invoke(obj, method, new Object[] { arg1 });
	}

	public static Object invoke(Object obj, Method method, Object arg1,
			Object arg2) {
		return invoke(obj, method, new Object[] { arg1, arg2 });
	}

	public static Object invoke(Object obj, Method method, Object arg1,
			Object arg2, Object arg3) {
		return invoke(obj, method, new Object[] { arg1, arg2, arg3 });
	}

	public static Object invoke(Object obj, Method method, Object[] args) {
		try {
			return method.invoke(obj, args);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	public static Object invokeQuietly(Object obj, Method method, Object arg1) {
		try {
			return invoke(obj, method, new Object[] { arg1 });
		} catch (Exception e) {
			return null;
		}
	}

	public static Object invokeQuietly(Object obj, Method method, Object arg1,
			Object arg2) {
		try {
			return invokeQuietly(obj, method, new Object[] { arg1, arg2 });
		} catch (Exception e) {
			return null;
		}

	}

	public static Object invokeQuietly(Object obj, Method method, Object arg1,
			Object arg2, Object arg3) {
		try {
			return invokeQuietly(obj, method, new Object[] { arg1, arg2, arg3 });
		} catch (Exception e) {
			return null;
		}

	}

	public static Object invokeQuietly(Object obj, Method method, Object[] args) {
		try {
			return method.invoke(obj, args);
		} catch (Exception e) {
			return null;
		}
	}

	public static Object newInstance(Class type) {
		try {
			return type.newInstance();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	public static Object newInstance(Class type, Object[] args) {
		if (args.length == 0)
			return newInstance(type);
		try {

			Class[] argTypes = new Class[args.length];
			for (int i = 0; i < args.length; i++) {
				Object object = args[i];
				if (object == null)
					argTypes[i] = null;
				else
					argTypes[i] = object.getClass();

			}

			Constructor[] constructors = type.getConstructors();

			for (int i = 0; i < constructors.length; i++) {
				Constructor constructor = constructors[i];
				Class[] parameterTypes = constructor.getParameterTypes();
				if (parameterTypes.length != argTypes.length)
					continue;
				int matchCount = 0;
				for (int j = 0; j < parameterTypes.length; j++) {
					Class parameterType = parameterTypes[j];
					if (isCompatibleType(args[j], parameterType))
						matchCount++;
				}
				if (matchCount == 0)
					continue;
				if (matchCount == parameterTypes.length)
					return constructor.newInstance(args);
			}
			return null;

		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	public static boolean isCompatibleType(Object value, Class type) {
		if (value == null || type.isInstance(value)) {
			return true;

		} else if (type.equals(Integer.TYPE) && Integer.class.isInstance(value)) {
			return true;

		} else if (type.equals(Long.TYPE) && Long.class.isInstance(value)) {
			return true;

		} else if (type.equals(Double.TYPE) && Double.class.isInstance(value)) {
			return true;

		} else if (type.equals(Float.TYPE) && Float.class.isInstance(value)) {
			return true;

		} else if (type.equals(Short.TYPE) && Short.class.isInstance(value)) {
			return true;

		} else if (type.equals(Byte.TYPE) && Byte.class.isInstance(value)) {
			return true;

		} else if (type.equals(Character.TYPE)
				&& Character.class.isInstance(value)) {
			return true;

		} else if (type.equals(Boolean.TYPE) && Boolean.class.isInstance(value)) {
			return true;

		} else {
			return false;
		}

	}

	public static PropertyDescriptor[] propertyDescriptors(Class beanClass) {
		try {
			BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
			return beanInfo.getPropertyDescriptors();
		} catch (IntrospectionException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * フィールドタイプが(public static final String)であるかの判定
	 * 
	 * @param field
	 * @return
	 */
	public static boolean isPublicStaticFinalString(Field field) {
		return field.getType().equals(String.class)
				&& isPublicStaticFinal(field);
	}

	/**
	 * フィールドタイプが(public static final boolean)であるかの判定
	 * 
	 * @param field
	 * @return
	 */
	public static boolean isPublicStaticFinalBoolean(Field field) {
		return field.getType().equals(Boolean.TYPE)
				&& isPublicStaticFinal(field);
	}

	/**
	 * フィールドタイプが(public static final boolean)であるかの判定
	 * 
	 * @param field
	 * @return
	 */
	public static boolean isPublicStaticFinalInt(Field field) {
		return field.getType().equals(Integer.TYPE)
				&& isPublicStaticFinal(field);
	}

	/**
	 * フィールドタイプが(public static final)であるかの判定
	 * 
	 * @param field
	 * @return
	 */
	public static boolean isPublicStaticFinal(Field field) {
		int modifiers = field.getModifiers();
		return Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers)
				&& Modifier.isPublic(modifiers);
	}

	/**
	 * Stringを取得する
	 * 
	 * @param field
	 * @return
	 */
	public static String getString(Field field) {

		try {
			return (String) field.get(null);
		} catch (IllegalArgumentException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}

	}

	/**
	 * boolean
	 * 
	 * @param field
	 * @return
	 */
	public static boolean getBoolean(Field field) {
		try {
			return field.getBoolean(null);
		} catch (IllegalArgumentException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * intを取得する
	 * 
	 * @param field
	 * @return
	 */
	public static int getInt(Field field) {
		try {
			return field.getInt(null);
		} catch (IllegalArgumentException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * longを取得する
	 * 
	 * @param field
	 * @return
	 */
	public static long getLong(Field field) {
		try {
			return field.getLong(null);
		} catch (IllegalArgumentException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Objectを取得する
	 * 
	 * @param field
	 * @return
	 */
	public static Object getObject(Object object, Field field) {
		try {
			return field.get(object);
		} catch (IllegalArgumentException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}
	/**
	 * Objectをセットする。
	 * @param field
	 * @param object
	 * @param value
	 */
	public static void setObject(Field field, Object object, Object value){
		try {
			field.set(object, value);
		} catch (IllegalArgumentException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		}
	}
	
	
	/**
	 * サフィックスを除去した、フィールド名を取得する。
	 * 
	 * @param field
	 * @param suffix
	 * @return
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 */
	public static String removalSuffixFieldName(Field field, String suffix){
		String fieldName = field.getName();
		return fieldName.substring(0, fieldName.lastIndexOf(suffix));
	}
}
