/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.types.BigDecimalType;
import jp.sourceforge.sxdbutils.types.BooleanCharType;
import jp.sourceforge.sxdbutils.types.BooleanNumericType;
import jp.sourceforge.sxdbutils.types.BooleanType;
import jp.sourceforge.sxdbutils.types.ByteArrayType;
import jp.sourceforge.sxdbutils.types.ByteType;
import jp.sourceforge.sxdbutils.types.CharNumericType;
import jp.sourceforge.sxdbutils.types.CharType;
import jp.sourceforge.sxdbutils.types.DateTimestampType;
import jp.sourceforge.sxdbutils.types.DoubleType;
import jp.sourceforge.sxdbutils.types.FloatType;
import jp.sourceforge.sxdbutils.types.IntegerType;
import jp.sourceforge.sxdbutils.types.LongTimestampType;
import jp.sourceforge.sxdbutils.types.LongType;
import jp.sourceforge.sxdbutils.types.ObjectType;
import jp.sourceforge.sxdbutils.types.ShortType;
import jp.sourceforge.sxdbutils.types.SqlDateType;
import jp.sourceforge.sxdbutils.types.StringClobType;
import jp.sourceforge.sxdbutils.types.StringNumericType;
import jp.sourceforge.sxdbutils.types.StringType;
import jp.sourceforge.sxdbutils.types.TimestampType;

public class TypeMappings {
    public static final ValueType BIGDECIMAL_TYPE = new BigDecimalType();
    public static final ValueType BOOLEAN_PRIMITIVE_TYPE = new BooleanType(true);
    public static final ValueType BOOLEAN_OBJECT_TYPE = new BooleanType(false);
    public static final ValueType BOOLEAN_CHAR_PRIMITIVE_TYPE = new BooleanCharType(true);
    public static final ValueType BOOLEAN_CHAR_OBJECT_TYPE = new BooleanCharType(false);
    public static final ValueType BOOLEAN_NUMERIC_PRIMITIVE_TYPE = new BooleanNumericType(true);
    public static final ValueType BOOLEAN_NUMERIC_OBJECT_TYPE = new BooleanNumericType(false);
    public static final ValueType BYTEARRAY_TYPE = new ByteArrayType();
    public static final ValueType BYTE_PRIMITIVE_TYPE = new ByteType(true);
    public static final ValueType BYTE_OBJECT_TYPE = new ByteType(false);
    public static final ValueType CHAR_PRIMITIVE_TYPE = new CharType(true);
    public static final ValueType CHAR_OBJECT_TYPE = new CharType(false);
    public static final ValueType DATE_TIMESTAMP_TYPE = new DateTimestampType();
    public static final ValueType LONG_TIMESTAMP_PRIMITIVE_TYPE = new LongTimestampType(true);
    public static final ValueType LONG_TIMESTAMP_OBJECT_TYPE = new LongTimestampType(false);
    public static final ValueType DOUBLE_PRIMITIVE_TYPE = new DoubleType(true);
    public static final ValueType DOUBLE_OBJECT_TYPE = new DoubleType(false);
    public static final ValueType FLOAT_PRIMITIVE_TYPE = new FloatType(true);
    public static final ValueType FLOAT_OBJECT_TYPE = new FloatType(false);
    public static final ValueType INT_PRIMITIVE_TYPE = new IntegerType(true);
    public static final ValueType INT_OBJECT_TYPE = new IntegerType(false);
    public static final ValueType LONG_PRIMITIVE_TYPE = new LongType(true);
    public static final ValueType LONG_OBJECT_TYPE = new LongType(false);
    public static final ValueType OBJECT_TYPE = new ObjectType();
    public static final ValueType SHORT_PRIMITIVE_TYPE = new ShortType(true);
    public static final ValueType SHORT_OBJECT_TYPE = new ShortType(false);
    public static final ValueType SQLDATE_OBJECT_TYPE = new SqlDateType();
    public static final ValueType TIMESTAMP_OBJECT_TYPE = new TimestampType();
    public static final ValueType STRING_CLOB_TYPE = new StringClobType();
    public static final ValueType STRING_TYPE = new StringType();
    public static final ValueType CHAR_NUMERIC_PRIMITIVE_TYPE = new CharNumericType(true);
    public static final ValueType CHAR_NUMERIC_OBJECT_TYPE = new CharNumericType(false);
    public static final ValueType STRING_NUMERIC_OBJECT_TYPE = new StringNumericType();
    public static Map valueTypes = new HashMap();
    public static Map defaultValueTypes = new HashMap();
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    private TypeMappings() {
    }

    static void registerValueType(Class clazz, int sqlType, ValueType type) {
        TypeMappings.registerValueType(new Key(clazz, sqlType), type);
    }

    static void registerAllNumericValueType(Class clazz, ValueType type) {
        TypeMappings.registerValueType(clazz, 3, type);
        TypeMappings.registerValueType(clazz, 2, type);
        TypeMappings.registerValueType(clazz, 4, type);
        TypeMappings.registerValueType(clazz, -5, type);
        TypeMappings.registerValueType(clazz, 7, type);
        TypeMappings.registerValueType(clazz, 8, type);
        TypeMappings.registerValueType(clazz, 6, type);
        TypeMappings.registerValueType(clazz, 5, type);
        TypeMappings.registerValueType(clazz, -6, type);
    }

    static void registerAllStringValueType(Class clazz, ValueType type) {
        TypeMappings.registerValueType(clazz, 12, type);
        TypeMappings.registerValueType(clazz, -1, type);
        TypeMappings.registerValueType(clazz, 1, type);
    }

    static void registerAllBinaryValueType(Class clazz, ValueType type) {
        TypeMappings.registerValueType(clazz, -2, type);
        TypeMappings.registerValueType(clazz, 2004, type);
        TypeMappings.registerValueType(clazz, -3, type);
        TypeMappings.registerValueType(clazz, -4, type);
    }

    static void registerAllDateValueType(Class clazz, ValueType type) {
        TypeMappings.registerValueType(clazz, 93, type);
        TypeMappings.registerValueType(clazz, 91, type);
        TypeMappings.registerValueType(clazz, 92, type);
    }

    static void registerValueType(Key key, ValueType type) {
        valueTypes.put(key, type);
    }

    static void registerDefaultValueType(Class clazz, ValueType type) {
        defaultValueTypes.put(clazz, type);
    }

    public static ValueType getValueType(Class clazz, int sqlType) {
        ValueType result = (ValueType)valueTypes.get(new Key(clazz, sqlType));
        return result == null ? OBJECT_TYPE : result;
    }

    public static ValueType getValueType(int sqlType) {
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                return STRING_TYPE;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return BIGDECIMAL_TYPE;
            }
            case 2005: {
                return STRING_CLOB_TYPE;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return BYTEARRAY_TYPE;
            }
            case 91: 
            case 92: 
            case 93: {
                return DATE_TIMESTAMP_TYPE;
            }
        }
        return OBJECT_TYPE;
    }

    public static ValueType getValueType(Class type) {
        ValueType result = (ValueType)defaultValueTypes.get(type);
        return result == null ? OBJECT_TYPE : result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TypeMappings.registerAllNumericValueType(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeMappings.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, BIGDECIMAL_TYPE);
        TypeMappings.registerValueType(Boolean.TYPE, 16, BOOLEAN_PRIMITIVE_TYPE);
        TypeMappings.registerValueType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeMappings.class$("java.lang.Boolean")) : class$java$lang$Boolean, 16, BOOLEAN_OBJECT_TYPE);
        TypeMappings.registerValueType(Boolean.TYPE, 1, BOOLEAN_CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerValueType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeMappings.class$("java.lang.Boolean")) : class$java$lang$Boolean, 1, BOOLEAN_CHAR_OBJECT_TYPE);
        TypeMappings.registerValueType(Boolean.TYPE, 12, BOOLEAN_CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerValueType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeMappings.class$("java.lang.Boolean")) : class$java$lang$Boolean, 12, BOOLEAN_CHAR_OBJECT_TYPE);
        TypeMappings.registerAllNumericValueType(Boolean.TYPE, BOOLEAN_NUMERIC_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeMappings.class$("java.lang.Boolean")) : class$java$lang$Boolean, BOOLEAN_NUMERIC_PRIMITIVE_TYPE);
        TypeMappings.registerAllBinaryValueType(array$B == null ? (array$B = TypeMappings.class$("[B")) : array$B, BYTEARRAY_TYPE);
        TypeMappings.registerAllNumericValueType(Byte.TYPE, BYTE_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(class$java$lang$Byte == null ? (class$java$lang$Byte = TypeMappings.class$("java.lang.Byte")) : class$java$lang$Byte, BYTE_OBJECT_TYPE);
        TypeMappings.registerAllStringValueType(Character.TYPE, CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Character.TYPE, CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerAllStringValueType(class$java$lang$Character == null ? (class$java$lang$Character = TypeMappings.class$("java.lang.Character")) : class$java$lang$Character, CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(class$java$lang$Character == null ? (class$java$lang$Character = TypeMappings.class$("java.lang.Character")) : class$java$lang$Character, CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Character.TYPE, CHAR_NUMERIC_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(class$java$lang$Character == null ? (class$java$lang$Character = TypeMappings.class$("java.lang.Character")) : class$java$lang$Character, CHAR_NUMERIC_OBJECT_TYPE);
        TypeMappings.registerAllDateValueType(class$java$util$Date == null ? (class$java$util$Date = TypeMappings.class$("java.util.Date")) : class$java$util$Date, DATE_TIMESTAMP_TYPE);
        TypeMappings.registerAllDateValueType(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = TypeMappings.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, TIMESTAMP_OBJECT_TYPE);
        TypeMappings.registerAllDateValueType(Long.TYPE, LONG_TIMESTAMP_PRIMITIVE_TYPE);
        TypeMappings.registerAllDateValueType(class$java$lang$Long == null ? (class$java$lang$Long = TypeMappings.class$("java.lang.Long")) : class$java$lang$Long, LONG_TIMESTAMP_OBJECT_TYPE);
        TypeMappings.registerValueType(class$java$sql$Date == null ? (class$java$sql$Date = TypeMappings.class$("java.sql.Date")) : class$java$sql$Date, 91, SQLDATE_OBJECT_TYPE);
        TypeMappings.registerAllNumericValueType(Double.TYPE, DOUBLE_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(class$java$lang$Double == null ? (class$java$lang$Double = TypeMappings.class$("java.lang.Double")) : class$java$lang$Double, DOUBLE_OBJECT_TYPE);
        TypeMappings.registerAllNumericValueType(Float.TYPE, FLOAT_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(class$java$lang$Float == null ? (class$java$lang$Float = TypeMappings.class$("java.lang.Float")) : class$java$lang$Float, FLOAT_OBJECT_TYPE);
        TypeMappings.registerAllNumericValueType(Integer.TYPE, INT_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(class$java$lang$Integer == null ? (class$java$lang$Integer = TypeMappings.class$("java.lang.Integer")) : class$java$lang$Integer, INT_OBJECT_TYPE);
        TypeMappings.registerAllNumericValueType(Long.TYPE, LONG_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(class$java$lang$Long == null ? (class$java$lang$Long = TypeMappings.class$("java.lang.Long")) : class$java$lang$Long, LONG_OBJECT_TYPE);
        TypeMappings.registerAllNumericValueType(Short.TYPE, SHORT_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(class$java$lang$Short == null ? (class$java$lang$Short = TypeMappings.class$("java.lang.Short")) : class$java$lang$Short, SHORT_OBJECT_TYPE);
        TypeMappings.registerAllStringValueType(class$java$lang$String == null ? (class$java$lang$String = TypeMappings.class$("java.lang.String")) : class$java$lang$String, STRING_TYPE);
        TypeMappings.registerAllNumericValueType(class$java$lang$String == null ? (class$java$lang$String = TypeMappings.class$("java.lang.String")) : class$java$lang$String, STRING_TYPE);
        TypeMappings.registerValueType(class$java$lang$String == null ? (class$java$lang$String = TypeMappings.class$("java.lang.String")) : class$java$lang$String, 2005, STRING_CLOB_TYPE);
        TypeMappings.registerAllNumericValueType(class$java$lang$String == null ? (class$java$lang$String = TypeMappings.class$("java.lang.String")) : class$java$lang$String, STRING_NUMERIC_OBJECT_TYPE);
        TypeMappings.registerAllDateValueType(class$java$lang$String == null ? (class$java$lang$String = TypeMappings.class$("java.lang.String")) : class$java$lang$String, STRING_TYPE);
        TypeMappings.registerAllNumericValueType(class$java$lang$Object == null ? (class$java$lang$Object = TypeMappings.class$("java.lang.Object")) : class$java$lang$Object, OBJECT_TYPE);
        TypeMappings.registerAllStringValueType(class$java$lang$Object == null ? (class$java$lang$Object = TypeMappings.class$("java.lang.Object")) : class$java$lang$Object, OBJECT_TYPE);
        TypeMappings.registerAllBinaryValueType(class$java$lang$Object == null ? (class$java$lang$Object = TypeMappings.class$("java.lang.Object")) : class$java$lang$Object, OBJECT_TYPE);
        TypeMappings.registerAllDateValueType(class$java$lang$Object == null ? (class$java$lang$Object = TypeMappings.class$("java.lang.Object")) : class$java$lang$Object, OBJECT_TYPE);
        TypeMappings.registerValueType(class$java$lang$Object == null ? (class$java$lang$Object = TypeMappings.class$("java.lang.Object")) : class$java$lang$Object, 2005, STRING_CLOB_TYPE);
        TypeMappings.registerValueType(class$java$lang$Object == null ? (class$java$lang$Object = TypeMappings.class$("java.lang.Object")) : class$java$lang$Object, 16, STRING_CLOB_TYPE);
        TypeMappings.registerDefaultValueType(class$java$lang$String == null ? (class$java$lang$String = TypeMappings.class$("java.lang.String")) : class$java$lang$String, STRING_TYPE);
        TypeMappings.registerDefaultValueType(Character.TYPE, CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(class$java$lang$Character == null ? (class$java$lang$Character = TypeMappings.class$("java.lang.Character")) : class$java$lang$Character, CHAR_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Boolean.TYPE, BOOLEAN_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeMappings.class$("java.lang.Boolean")) : class$java$lang$Boolean, BOOLEAN_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Integer.TYPE, INT_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(class$java$lang$Integer == null ? (class$java$lang$Integer = TypeMappings.class$("java.lang.Integer")) : class$java$lang$Integer, INT_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Long.TYPE, LONG_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(class$java$lang$Long == null ? (class$java$lang$Long = TypeMappings.class$("java.lang.Long")) : class$java$lang$Long, LONG_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Short.TYPE, SHORT_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(class$java$lang$Short == null ? (class$java$lang$Short = TypeMappings.class$("java.lang.Short")) : class$java$lang$Short, SHORT_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Float.TYPE, FLOAT_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(class$java$lang$Float == null ? (class$java$lang$Float = TypeMappings.class$("java.lang.Float")) : class$java$lang$Float, FLOAT_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Byte.TYPE, BYTE_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(class$java$lang$Byte == null ? (class$java$lang$Byte = TypeMappings.class$("java.lang.Byte")) : class$java$lang$Byte, BYTE_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Double.TYPE, DOUBLE_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(class$java$lang$Double == null ? (class$java$lang$Double = TypeMappings.class$("java.lang.Double")) : class$java$lang$Double, DOUBLE_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeMappings.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, BIGDECIMAL_TYPE);
        TypeMappings.registerDefaultValueType(class$java$util$Date == null ? (class$java$util$Date = TypeMappings.class$("java.util.Date")) : class$java$util$Date, DATE_TIMESTAMP_TYPE);
    }

    static class Key {
        final Class clazz;
        final int sqlType;

        public Key(Class clazz, int sqlType) {
            this.clazz = clazz;
            this.sqlType = sqlType;
        }

        public int hashCode() {
            int result = 17;
            result = result * 31 + this.clazz.hashCode();
            result = result * 31 + this.sqlType;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.clazz.equals(other.clazz) && this.sqlType == other.sqlType;
            }
            return false;
        }
    }
}

