/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.processors.ValueRowProcessor;
import org.apache.commons.dbutils.ResultSetHandler;

public class KeyedHandler
implements ResultSetHandler {
    protected final SxRowProcessor keyProcessor;
    protected final SxRowProcessor valueProcessor;

    protected SxRowProcessor getKeyProcessor() {
        if (this.keyProcessor == null) {
            throw new IllegalStateException("\u30ad\u30fc\u3092\u51e6\u7406\u3059\u308bSxRowProcessor\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u5f15\u6570\u306a\u3057\u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u3092\u4f7f\u7528\u3059\u308b\u5834\u5408\u3001\u5fc5\u305agetKeyProcessor\u3068getValueProcessor\u30e1\u30bd\u30c3\u30c9\u3092\u30aa\u30fc\u30d0\u30fc\u30e9\u30a4\u30c9\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return this.keyProcessor;
    }

    protected SxRowProcessor getValueProcessor() {
        if (this.valueProcessor == null && this.keyProcessor == null) {
            throw new IllegalStateException("\u5024\u3092\u51e6\u7406\u3059\u308bSxRowProcessor\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u5f15\u6570\u306a\u3057\u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u3092\u4f7f\u7528\u3059\u308b\u5834\u5408\u3001\u5fc5\u305agetKeyProcessor\u3068getValueProcessor\u30e1\u30bd\u30c3\u30c9\u3092\u30aa\u30fc\u30d0\u30fc\u30e9\u30a4\u30c9\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return this.valueProcessor;
    }

    public KeyedHandler() {
        this.keyProcessor = null;
        this.valueProcessor = null;
    }

    public KeyedHandler(String keyColumnName, Class type, SxRowProcessor processor) {
        this(new ValueRowProcessor(keyColumnName, type), processor);
    }

    public KeyedHandler(String keyColumnName, SxRowProcessor processor) {
        this(new ValueRowProcessor(keyColumnName), processor);
    }

    public KeyedHandler(int keyColumnIndex, Class keyType, SxRowProcessor processor) {
        this(new ValueRowProcessor(keyColumnIndex, keyType), processor);
    }

    public KeyedHandler(int columnIndex, SxRowProcessor processor) {
        this(new ValueRowProcessor(columnIndex), processor);
    }

    public KeyedHandler(SxRowProcessor keyProcessor, SxRowProcessor processor) {
        this.keyProcessor = keyProcessor;
        this.valueProcessor = processor;
    }

    public Object handle(ResultSet rs) throws SQLException {
        Map result = this.createMap();
        SxRowProcessor kproc = this.getKeyProcessor();
        SxRowProcessor vproc = this.getValueProcessor();
        if (rs.next()) {
            kproc.init(rs.getMetaData());
            vproc.init(rs.getMetaData());
            do {
                result.put(kproc.process(rs), vproc.process(rs));
            } while (rs.next());
        }
        return result;
    }

    protected Map createMap() {
        return new LinkedHashMap();
    }
}

