package jp.sourceforge.sxdbutils.tiger.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

import jp.sourceforge.sxdbutils.query.QueryFactory;

public abstract class AbstractDeleteTemplate<E> implements DeleteTemplate<E> {

	protected abstract Connection getConnection() throws SQLException;

	protected final QueryFactory deleteFactory;
	protected EntityPersistenceHelper<E> persistenceHelper = new EntityPersistenceHelper<E>();

	public AbstractDeleteTemplate(QueryFactory deleteFactory) {
		this.deleteFactory = deleteFactory;
	}

	public int[] delete(Collection<E> entities) throws SQLException {
		return persistenceHelper.execute(getConnection(), deleteFactory, entities);
	}

	public int delete(E entity) throws SQLException {
		return persistenceHelper.execute(getConnection(), deleteFactory, entity);
	}

	public int[] deleteBatch(Collection<E> entities) throws SQLException {
		return persistenceHelper.executeBatch(getConnection(), deleteFactory,
				entities);
	}

}
