/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.csvio;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.talisman.csvio.CsvElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvLine
implements Iterable<String>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 7406197507497201455L;
    private List<CsvElement> elements = new ArrayList<CsvElement>();

    public CsvLine() {
    }

    public CsvLine(CsvLine line) {
        for (String value : line) {
            this.addValue(value);
        }
    }

    public CsvLine(String[] values) {
        int i = 0;
        while (i < values.length) {
            this.addValue(values[i]);
            ++i;
        }
    }

    public synchronized int size() {
        return this.elements.size();
    }

    public synchronized void addValue(String value) {
        this.elements.add(new CsvElement(value));
    }

    public synchronized void addValue(int index, String element) {
        this.elements.add(index, new CsvElement(element));
    }

    public synchronized String getValue(int index) {
        return this.elements.get(index).getValue();
    }

    public synchronized void removeValue(int index) {
        this.elements.remove(index);
    }

    public synchronized String[] getValues() {
        String[] strings = new String[this.elements.size()];
        int i = 0;
        while (i < strings.length) {
            strings[i] = this.elements.get(i).getValue();
            ++i;
        }
        return strings;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private List<CsvElement> newList;
            private Iterator<CsvElement> iterator;
            {
                this.newList = new ArrayList<CsvElement>(CsvLine.this.elements);
                this.iterator = this.newList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public String next() {
                return this.iterator.next().getValue();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    public Object clone() {
        return new CsvLine(this);
    }
}

