package jp.sourceforge.talisman.csvio;

/*
 * $Id: CsvLineWriterPracticalTest.java 4 2007-08-11 01:41:41Z tama3 $
 */

import static org.junit.Assert.assertEquals;

import java.io.StringWriter;

import org.junit.Before;
import org.junit.Test;

/**
 *
 * @author Haruaki Tamada
 * @version $Revision: 4 $ $Date: 2007-08-11 10:41:41 +0900 (Sat, 11 Aug 2007) $
 */
public class CsvLineWriterPracticalTest{
    private CsvLine[] lines;

    @Test
    public void testBasicWrite() throws Exception{
        StringWriter writer = new StringWriter();
        CsvLineWriter out = new CsvLineWriter(writer);

        out.write(lines[0]);
        out.write(lines[1]);
        out.write(lines[2]);

        out.close();
        String value = new String(writer.getBuffer());
        String[] values = value.split(System.getProperty("line.separator"));

        assertEquals(3, values.length);
        assertEquals("\"\"v0_1,\",v0_2\",\tv0_3,<v0_4,>v0_5", values[0]);
        assertEquals("v1_1,v1_2,v1_3,v1_4,v1_5", values[1]);
        assertEquals("v2_1,v2_2,v2_3,v2_4,v2_5", values[2]);
    }

    @Test
    public void testEscapeModeChanged() throws Exception{
        StringWriter writer = new StringWriter();
        CsvLineWriter out = new CsvLineWriter(writer);
        out.getSetting().setEscapeMode(EscapeMode.ESCAPE_CHARACTER);

        out.write(lines[0]);
        out.write(lines[1]);
        out.write(lines[2]);

        out.close();
        String value = new String(writer.getBuffer());
        String[] values = value.split(System.getProperty("line.separator"));

        assertEquals(3, values.length);
        assertEquals("\\\"v0_1,\",v0_2\",\tv0_3,<v0_4,>v0_5", values[0]);
        assertEquals("v1_1,v1_2,v1_3,v1_4,v1_5", values[1]);
        assertEquals("v2_1,v2_2,v2_3,v2_4,v2_5", values[2]);
    }

    @Test
    public void testSeparatorChanged() throws Exception{
        StringWriter writer = new StringWriter();
        CsvLineWriter out = new CsvLineWriter(writer);
        out.getSetting().setSeparator('\t');

        out.write(lines[0]);
        out.write(lines[1]);
        out.write(lines[2]);

        out.close();
        String value = new String(writer.getBuffer());
        String[] values = value.split(System.getProperty("line.separator"));

        assertEquals(3, values.length);
        assertEquals("\"\"v0_1\t,v0_2\t\"\tv0_3\"\t<v0_4\t>v0_5", values[0]);
        assertEquals("v1_1\tv1_2\tv1_3\tv1_4\tv1_5", values[1]);
        assertEquals("v2_1\tv2_2\tv2_3\tv2_4\tv2_5", values[2]);
    }

    @Test
    public void testQuotationMode() throws Exception{
        StringWriter writer = new StringWriter();
        CsvLineWriter out = new CsvLineWriter(writer);
        out.getSetting().setQuotationMode(QuotationMode.ALWAYS);

        out.write(lines[0]);
        out.write(lines[1]);
        out.write(lines[2]);

        out.close();
        String value = new String(writer.getBuffer());
        String[] values = value.split(System.getProperty("line.separator"));

        assertEquals(3, values.length);
        assertEquals("\"\"\"v0_1\",\",v0_2\",\"\tv0_3\",\"<v0_4\",\">v0_5\"", values[0]);
        assertEquals("\"v1_1\",\"v1_2\",\"v1_3\",\"v1_4\",\"v1_5\"", values[1]);
        assertEquals("\"v2_1\",\"v2_2\",\"v2_3\",\"v2_4\",\"v2_5\"", values[2]);
    }

    @Before
    public void buildCsvLines(){
        lines = new CsvLine[3];
        lines[0] = new CsvLine();
        lines[1] = new CsvLine();
        lines[2] = new CsvLine();

        lines[0].addValue("\"v0_1");
        lines[0].addValue(",v0_2");
        lines[0].addValue("\tv0_3");
        lines[0].addValue("<v0_4");
        lines[0].addValue(">v0_5");

        lines[1].addValue("v1_1");
        lines[1].addValue("v1_2");
        lines[1].addValue("v1_3");
        lines[1].addValue("v1_4");
        lines[1].addValue("v1_5");

        lines[2].addValue("v2_1");
        lines[2].addValue("v2_2");
        lines[2].addValue("v2_3");
        lines[2].addValue("v2_4");
        lines[2].addValue("v2_5");
    }
}
