/*************************************************************************************************/
/*!
   	@file		Graphdata.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"Undo.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

//=================================================================================================
cb_guid_define( IGraphLink_IID , 0x6800CF66 , 0x2DD74ef4 , 0xA5228F63 , 0x7293C80C );
class IGraphLink;
typedef icubic::iface_object< IGraphLink , IGraphLink_IID >		iGraphLink;
typedef icubic::iface_reference< IGraphLink , IGraphLink_IID >	rGraphLink;

//=================================================================================================
cb_guid_define( IGraphNode_IID , 0x9E847C99 , 0xA2414c30 , 0x95587974 , 0x8415331B );
class IGraphNode;
typedef icubic::iface_object< IGraphNode , IGraphNode_IID >		iGraphNode;
typedef icubic::iface_reference< IGraphNode , IGraphNode_IID >	rGraphNode;

//=================================================================================================
cb_guid_define( IGraph_IID , 0x7A715AF1 , 0xD75E405f , 0xBBABA557 , 0xB4C8229C );
class IGraph;
typedef icubic::iface_object< IGraph , IGraph_IID >		iGraph;
typedef icubic::iface_reference< IGraph , IGraph_IID >	rGraph;

/**************************************************************************************************
 "IGraphLink" interface 
***************************************************************************************************/
class IGraphLink
{
public:
//=================================================================================================
virtual
iGraphNode cb_call GetInput() = 0;
//=================================================================================================
virtual
iGraphNode cb_call GetOutput() = 0;
//=================================================================================================
virtual
bool cb_call SetInput
		(
		iGraphNode&		node , 
		int				pinoff , 
		IUndoList*		undo
		) = 0;
//=================================================================================================
virtual
bool cb_call SetOutput
		(
		iGraphNode&		node , 
		int				pinoff , 
		IUndoList*		undo
		) = 0;
//=================================================================================================
virtual
void cb_call Remove
		(
		IUndoList*		undo
		) = 0;
};
/**************************************************************************************************
 "IGraphNode" interface 
***************************************************************************************************/
class IGraphNode
{
public:
//=================================================================================================
virtual
int cb_call GetInputNum() = 0;
//=================================================================================================
virtual
int cb_call GetOutputNum() = 0;
//=================================================================================================
virtual
iGraphLink cb_call GetInput
		(
		int		pinoff
		) = 0;
//=================================================================================================
virtual
iGraphLink cb_call GetOutput
		(
		int		pinoff
		) = 0;
//=================================================================================================
virtual
iGraphLink cb_call AddLink
		(
		int				in_pinoff , 
		iGraphNode&		node , 
		int				out_pinoff , 
		IUndoList*		undo
		) = 0;
//=================================================================================================
virtual
void cb_call Remove
		(
		IUndoList*		undo
		) = 0;
};
/**************************************************************************************************
 "IGraph" interface 
***************************************************************************************************/
class IGraph
{
public:
//=================================================================================================
virtual
int cb_call GetNodeNum() = 0;
//=================================================================================================
virtual
iGraphNode cb_call GetNode
		(
		int		nodeoff
		) = 0;
//=================================================================================================
virtual
iGraphNode cb_call AddNode
		(
		IUndoList*		undo
		) = 0;
};

//=================================================================================================
cb_guid_define( GraphLink_IID , 0xBCFB0EA7 , 0x49C84327 , 0x8250C5B5 , 0xDA561BA2 );
class GraphLink;
typedef icubic::iface_object< GraphLink , GraphLink_IID >		iCGraphLink;
typedef icubic::iface_reference< GraphLink , GraphLink_IID >	rCGraphLink;

//=================================================================================================
cb_guid_define( GraphNode_IID , 0xFE708620 , 0x8BC04f92 , 0xA60ADF8E , 0x751CD889 );
class GraphNode;
typedef icubic::iface_object< GraphNode , GraphNode_IID >		iCGraphNode;
typedef icubic::iface_reference< GraphNode , GraphNode_IID >	rCGraphNode;

//=================================================================================================
cb_guid_define( Graph_IID , 0xEBBB0DD5 , 0x3D714c61 , 0xA882E843 , 0x6F6E2044 );
class Graph;
typedef icubic::iface_object< Graph , Graph_IID >		iCGraph;
typedef icubic::iface_reference< Graph , Graph_IID >	rCGraph;

/**************************************************************************************************
"GraphLink" class 
**************************************************************************************************/
class GraphLink : 
	virtual public object_base , 
	public IGraphLink
{
	query_begin();
	iface_hook( IGraphLink , IGraphLink_IID )
	iface_hook( GraphLink , GraphLink_IID )
	query_end( object_base );
	
protected:	
	//=============================================================================================
	class SetInputInner_cmd : public UndoCmd
	{
	public:
		iCGraphLink		m_this;
		iGraphNode		m_node;
		void cb_call Execute()
		{
			m_this->SetInputInner( m_node );
		}
	};
	//=============================================================================================
	class SetOutputInner_cmd : public UndoCmd
	{
	public:
		iCGraphLink		m_this;
		iGraphNode		m_node;
		void cb_call Execute()
		{
			m_this->SetOutputInner( m_node );
		}
	};
// variable member
private:
	rCGraph			m_graph;
	rCGraphNode		m_input;
	rCGraphNode		m_output;

// private functions
private:
//=================================================================================================
void cb_call SetInputInner
		(
		iGraphNode&		node
		)
{
	m_input	= node;
}
//=================================================================================================
void cb_call SetOutputInner
		(
		iGraphNode&		node
		)
{
	m_output= node;
}

// "IGraphLink" interface functions
public:
//=================================================================================================
iGraphNode cb_call GetInput()
{
	return (iGraphNode)m_input.lock();
}
//=================================================================================================
iGraphNode cb_call GetOutput()
{
	return (iGraphNode)m_output.lock();
}
//=================================================================================================
cb_inline
bool cb_call SetInput
		(
		iGraphNode&		node , 
		int				pinoff , 
		IUndoList*		undo
		);
//=================================================================================================
cb_inline
bool cb_call SetOutput
		(
		iGraphNode&		node , 
		int				pinoff , 
		IUndoList*		undo
		);
//=================================================================================================
cb_inline
void cb_call Remove
		(
		IUndoList*		undo
		);

// public functions
public:
//=================================================================================================
GraphLink()
{
}
//=================================================================================================
void Initialize
		(
		iCGraph&		graph
		)
{
	m_graph	= graph;
}
//=================================================================================================
iCGraph GetGraph()
{
	return m_graph.lock();
}
};
/**************************************************************************************************
"GraphNode" class 
**************************************************************************************************/
class GraphNode : 
	virtual public object_base , 
	public IGraphNode
{
	query_begin();
	iface_hook( IGraphNode , IGraphNode_IID )
	iface_hook( GraphNode , GraphNode_IID )
	query_end( object_base );
	
protected:	
	//=============================================================================================
	class AddInput_cmd : public UndoCmd
	{
	public:
		iCGraphNode		m_this;
		iCGraphLink		link;
		int				pinoff;
		void cb_call Execute()
		{
			m_this->AddInput( link , pinoff , 0 );
		}
	};
	//=============================================================================================
	class AddOutput_cmd : public UndoCmd
	{
	public:
		iCGraphNode		m_this;
		iCGraphLink		link;
		int				pinoff;
		void cb_call Execute()
		{
			m_this->AddOutput( link , pinoff , 0 );
		}
	};
	//=============================================================================================
	class RemoveInput_cmd : public UndoCmd
	{
	public:
		iCGraphNode		m_this;
		iCGraphLink		link;
		void cb_call Execute()
		{
			m_this->RemoveInput( link , 0 );
		}
	};
	//=============================================================================================
	class RemoveOutput_cmd : public UndoCmd
	{
	public:
		iCGraphNode		m_this;
		iCGraphLink		link;
		void cb_call Execute()
		{
			m_this->RemoveOutput( link , 0 );
		}
	};

// variable member
private:
	rCGraph						m_graph;
	Straightdata<iCGraphLink>	m_inputs;
	Straightdata<iCGraphLink>	m_outputs;
	
// private functions
private:

// "IGraphNode" interface functions
public:
//=================================================================================================
int cb_call GetInputNum()
{
	return m_inputs.GetDatanum();
}
//=================================================================================================
int cb_call GetOutputNum()
{
	return m_outputs.GetDatanum();
}
//=================================================================================================
iGraphLink cb_call GetInput
		(
		int		pinoff
		)
{
	return (iGraphLink)m_inputs[pinoff];
}
//=================================================================================================
iGraphLink cb_call GetOutput
		(
		int		pinoff
		)
{
	return (iGraphLink)m_outputs[pinoff];
}
//=================================================================================================
cb_inline
iGraphLink cb_call AddLink
		(
		int				in_pinoff , 
		iGraphNode&		node , 
		int				out_pinoff , 
		IUndoList*		undo
		);
//=================================================================================================
cb_inline
void cb_call Remove
		(
		IUndoList*		undo
		);

// public functions
public:
//=================================================================================================
GraphNode()
{
}
//=================================================================================================
void Initialize
		(
		iCGraph&		graph
		)
{
	m_graph	= graph;
}
//=================================================================================================
iCGraph GetGraph()
{
	return m_graph.lock();
}
//=================================================================================================
void AddInput
		(
		iCGraphLink&	link , 
		int				pinoff , 
		IUndoList*		undo
		)
{
	if( link == false )
		return;

	// undo
	if( undo != 0 )
	{
		{
			instance<AddInput_cmd>	cmd;
			cmd->m_this	= this_object();
			cmd->link	= link;
			cmd->pinoff	= pinoff;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<RemoveInput_cmd>	cmd;
			cmd->m_this	= this_object();
			cmd->link	= link;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	// exe
	m_inputs[ m_inputs.Insert( pinoff ) ]	= link;
}
//=================================================================================================
void AddOutput
		(
		iCGraphLink&	link , 
		int				pinoff , 
		IUndoList*		undo
		)
{
	if( link == false )
		return;

	// undo
	if( undo != 0 )
	{
		{
			instance<AddOutput_cmd>	cmd;
			cmd->m_this	= this_object();
			cmd->link	= link;
			cmd->pinoff	= pinoff;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<RemoveOutput_cmd>	cmd;
			cmd->m_this	= this_object();
			cmd->link	= link;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	// exe
	m_outputs[ m_outputs.Insert( pinoff ) ]	= link;
}
//=================================================================================================
int SearchInput
		(
		iCGraphLink&	link
		)
{
	int			pinoff , pinnum = m_inputs.GetDatanum();
	for( pinoff = 0 ; pinoff < pinnum ; pinoff++ )
	{
		if( link == m_inputs[ pinoff ] )
			return pinoff;
	}
	return -1;
}
//=================================================================================================
int SearchOutput
		(
		iCGraphLink&	link
		)
{
	int			pinoff , pinnum = m_outputs.GetDatanum();
	for( pinoff = 0 ; pinoff < pinnum ; pinoff++ )
	{
		if( link == m_outputs[ pinoff ] )
			return pinoff;
	}
	return -1;
}
//=================================================================================================
void RemoveInput
		(
		iCGraphLink&	link , 
		IUndoList*		undo
		)
{
	int		pinoff = SearchInput( link );
	if( pinoff < 0 )
		return;
		
	// undo
	if( undo != 0 )
	{
		{
			instance<RemoveInput_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->link	= link;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<AddInput_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->link	= link;
			cmd->pinoff	= pinoff;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	// exe
	m_inputs.Delete( pinoff );
}
//=================================================================================================
void RemoveOutput
		(
		iCGraphLink&	link , 
		IUndoList*		undo
		)
{
	int		pinoff = SearchOutput( link );
	if( pinoff < 0 )
		return;
		
	// undo
	if( undo != 0 )
	{
		{
			instance<RemoveOutput_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->link	= link;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<AddOutput_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->link	= link;
			cmd->pinoff	= pinoff;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	// exe
	m_outputs.Delete( pinoff );
}
};
/**************************************************************************************************
"Graph" class 
**************************************************************************************************/
class Graph : 
	virtual public object_base , 
	public IGraph
{
	query_begin();
	iface_hook( IGraph , IGraph_IID )
	iface_hook( Graph , Graph_IID )
	query_end( object_base );
	
	//=============================================================================================
	class AddNode_cmd : public UndoCmd
	{
	public:
		iCGraph			m_this;
		iCGraphNode		node;
		void cb_call Execute()
		{
			m_this->AddNode( node , 0 );
		}
	};
	//=============================================================================================
	class RemoveNode_cmd : public UndoCmd
	{
	public:
		iCGraph			m_this;
		iCGraphNode		node;
		void cb_call Execute()
		{
			m_this->RemoveNode( node , 0 );
		}
	};

// variable member
private:
	Straightdata<iCGraphNode>	m_nodes;
	
// private functions
private:

// "IGraph" interface functions
public:
//=================================================================================================
int cb_call GetNodeNum()
{
	return m_nodes.GetDatanum();
}
//=================================================================================================
iGraphNode cb_call GetNode
		(
		int		nodeoff
		)
{
	return m_nodes[ nodeoff ];
}
//=================================================================================================
iGraphNode cb_call AddNode
		(
		IUndoList*		undo
		)
{
	iCGraphNode	node = CreateNodeInstance();
	node->Initialize( (iCGraph)this_object() );
	AddNode( (iCGraphNode)node , undo );
	return (iGraphNode)node;
}

// protected functions
protected:
//=================================================================================================
virtual
iCGraphNode CreateNodeInstance() = 0;
//=================================================================================================
virtual
iCGraphLink CreateLinkInstance() = 0;

// public functions
public:
//=================================================================================================
Graph()
{
}
//=================================================================================================
void AddNode
		(
		iCGraphNode&	node , 
		IUndoList*		undo
		)
{
	cb_assert( node->GetGraph() == (iCGraph)this_object() , L"algorithm error." );
	
	// undo
	if( undo != 0 )
	{
		{
			instance<AddNode_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->node	= node;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<RemoveNode_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->node	= node;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}	
	}
	// exe
	m_nodes[ m_nodes.Add() ]	= node;
}
//=================================================================================================
void RemoveNode
		(
		iCGraphNode&	node , 
		IUndoList*		undo
		)
{
	int		off , num = m_nodes.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( m_nodes[off] == node )
			break;
	}
	if( off >= num )
		return;
	
	// undo
	if( undo != 0 )
	{
		{
			instance<RemoveNode_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->node	= node;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<AddNode_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->node	= node;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	// exe
	m_nodes.Delete( off );
}
//=================================================================================================
iCGraphLink CreateLink()
{
	iCGraphLink		link = CreateLinkInstance();
	link->Initialize( (iCGraph)this_object() );
	return (iCGraphLink)link;
}
};
/**************************************************************************************************
"GraphLink" class 
**************************************************************************************************/
//=================================================================================================
cb_inline
bool cb_call GraphLink::SetInput
		(
		iGraphNode&		node , 
		int				pinoff , 
		IUndoList*		undo
		)
{
	iCGraphNode		a_node	= (iCGraphNode)node;
	iCGraphNode		b_node	= m_input.lock();
	if( a_node == true && a_node->GetGraph() != m_graph.lock() )
		return false;
	
	// undo
	if( undo != 0 )
	{
		{
			instance<GraphLink::SetInputInner_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->m_node	= a_node;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
	{
			instance<GraphLink::SetInputInner_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->m_node	= b_node;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}		
	}
	// exe	
	if( b_node == true )
	{
		if( b_node == a_node )
		{
			int	off = b_node->SearchOutput( (iCGraphLink)this_object() );
			cb_assert( off != -1 , L"algorithm error." );
			if( off < pinoff )
				pinoff--;
		}
		b_node->RemoveOutput( (iCGraphLink)this_object() , undo );
	}
	a_node->AddOutput( (iCGraphLink)this_object() , pinoff , undo );
	m_input	= a_node;
	return true;
}
//=================================================================================================
cb_inline
bool cb_call GraphLink::SetOutput
		(
		iGraphNode&		node , 
		int				pinoff , 
		IUndoList*		undo
		)
{
	iCGraphNode		a_node	= (iCGraphNode)node;
	iCGraphNode		b_node	= m_output.lock();
	if( a_node == true && a_node->GetGraph() != m_graph.lock() )
		return false;

	// undo
	if( undo != 0 )
	{
		{
			instance<GraphLink::SetOutputInner_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->m_node	= a_node;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<GraphLink::SetOutputInner_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->m_node	= b_node;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	// exe		
	if( b_node == true )
	{
		if( b_node == a_node )
		{
			int	off = b_node->SearchInput( (iCGraphLink)this_object() );
			cb_assert( off != -1 , L"algorithm error." );
			if( off < pinoff )
				pinoff--;
		}
		b_node->RemoveInput( (iCGraphLink)this_object() , undo );
	}
	a_node->AddInput( (iCGraphLink)this_object() , pinoff , undo );
	m_output	= a_node;
	return true;
}
//=================================================================================================
cb_inline
void cb_call GraphLink::Remove
		(
		IUndoList*		undo
		)
{
	{
		iCGraphNode		node	= (iCGraphNode)m_input.lock();
		if( node == true )
			node->RemoveOutput( (iCGraphLink)this_object() , undo );
		
	}
	{
		iCGraphNode		node	= (iCGraphNode)m_output.lock();
		if( node == true )
			node->RemoveInput( (iCGraphLink)this_object() , undo );
	}
	// exe
	if( undo != 0 )
	{
		{
			instance<SetInputInner_cmd>		cmd;
			cmd->m_this	= this_object();
			cmd->m_node	= object();
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<SetOutputInner_cmd>	cmd;
			cmd->m_this	= this_object();
			cmd->m_node	= object();
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<SetInputInner_cmd>		cmd;
			cmd->m_this	= this_object();
			cmd->m_node	= m_input.lock();
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
		{
			instance<SetOutputInner_cmd>	cmd;
			cmd->m_this	= this_object();
			cmd->m_node	= m_output.lock();
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	m_input.release();
	m_output.release();
}
/**************************************************************************************************
"GraphNode" class 
**************************************************************************************************/
//=================================================================================================
cb_inline
iGraphLink cb_call GraphNode::AddLink
		(
		int				in_pinoff , 
		iGraphNode&		node , 
		int				out_pinoff , 
		IUndoList*		undo
		)
{
	iCGraphNode		o_node = (iCGraphNode )node;
	if( o_node == false )
		return iGraphLink();
	if( o_node->GetGraph() != m_graph.lock() )
		return iGraphLink();

	// exe
	iGraphLink	link = ((iCGraph)(m_graph.lock()))->CreateLink();
	link->SetInput( (iGraphNode)this_object() , in_pinoff , undo );
	link->SetOutput( node , out_pinoff , undo );
	return (iGraphLink)link;
}
//=================================================================================================
cb_inline
void cb_call GraphNode::Remove
		(
		IUndoList*		undo
		)
{
	while( m_inputs.GetDatanum() != 0 )
	{
		m_inputs[0]->Remove( undo );
	}
	while( m_outputs.GetDatanum() != 0 )
	{
		m_outputs[0]->Remove( undo );
	}
	iCGraph		graph = (iCGraph)m_graph.lock();
	if( graph == true )
		graph->RemoveNode( (iCGraphNode)this_object() , undo );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
