/*************************************************************************************************/
/*!
   	@file		ParserDoc.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"Graphdata.h"

#pragma pack( push , 8 )		//set align

namespace document
{
using namespace std;
using namespace icubic;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IParserItem" interface 
***************************************************************************************************/
cb_guid_define( IParserItem_IID , 0xF4B98C3F , 0x8167425f , 0x8B9CA40A , 0xA02F36D5 );
class IParserItem;
typedef icubic::iface_object< IParserItem , IParserItem_IID >		iParserItem;
typedef icubic::iface_reference< IParserItem , IParserItem_IID >	rParserItem;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IParserItem
{
public:
	enum ItemType
	{
		Node , 
		Link , 
	};
	const ItemType		m_itemtype;
	const unsigned int	m_item_id;
	IParserItem
			(
			ItemType	type
			) : m_itemtype(type) , m_item_id( ( const unsigned int )&m_item_id ){}
};
/**************************************************************************************************
 "IParserNode" interface 
***************************************************************************************************/
cb_guid_define( IParserNode_IID , 0xC9C4B9C8 , 0x291D43af , 0xAC5E16CD , 0x0E304200 );
class IParserNode;
typedef icubic::iface_object< IParserNode , IParserNode_IID >		iParserNode;
typedef icubic::iface_reference< IParserNode , IParserNode_IID >	rParserNode;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IParserNode : public IParserItem
{
public:
	struct Property
	{
		enum Type
		{
			Start	= 0 , 
			End , 
			None , 
			ClearText , 
			PushTag , 
			PopTag , 
			SetAttr , 
			SetAttrText , 
			SetText , 
			PushText , 
			PopText , 
			Desc , 
		};
		struct PushTagProp
		{
			wstring	m_tag;
		};
		struct SetAttrProp
		{
			wstring	m_name;
			wstring	m_value;
		};
		struct SetAttrTextProp
		{
			wstring	m_name;
		};
		struct DescProp
		{
			wstring	m_desc;
		};
		ivector2		m_pos;
		Type			m_type;
		PushTagProp		m_pushtag_prop;
		SetAttrProp		m_setattr_prop;
		SetAttrTextProp	m_setattrtext_prop;
		DescProp		m_desc_prop;

		Property() : m_type( None ){}
	};
	IParserNode() : IParserItem( IParserItem::Node ){}
public:
//=================================================================================================
virtual
Property cb_call GetProperty() = 0;
//=================================================================================================
virtual
void cb_call SetProperty
		(
		Property&		prop , 
		IUndoList*		undo
		) = 0;
//=================================================================================================
virtual
bool cb_call Save
		(
		IStreamWrite*	file , 
		int				itemnum , 
		iParserItem*	itemlist , 
		int				nodenum , 
		iParserNode*	nodelist
		) = 0;
//=================================================================================================
virtual
bool cb_call Load
		(
		IStreamRead*	file , 
		IGraph*			graph
		) = 0;
};
/**************************************************************************************************
 "IParserLink" interface 
***************************************************************************************************/
cb_guid_define( IParserLink_IID , 0x8A9368D7 , 0xEF9D4f81 , 0xBDF13A46 , 0xAC5B43AA );
class IParserLink;
typedef icubic::iface_object< IParserLink , IParserLink_IID >		iParserLink;
typedef icubic::iface_reference< IParserLink , IParserLink_IID >	rParserLink;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IParserLink : public IParserItem
{
public:
	struct Property
	{
		enum Type
		{
			None = 0 , 
			RegularExp , 
			Function , 
		};
		enum Align
		{
			Left = 0 , 
			Center , 
			Right , 
		};
		enum KnotType
		{
			Direct = 0 , 
			Twist , 
		};
		struct RegularProp
		{
			enum SeqType
			{
				SeekSeq , 
				AddBuf , 
				NoSeq , 
			};
			wstring		m_exp;
			SeqType		m_seqtype;

			RegularProp() : m_seqtype( SeekSeq ){}
		};
		struct FunctionProp
		{
			wstring	m_parser_name;
		};
		ivector2		m_pos;
		KnotType		m_knottype;
		int				m_bar_width;
		Align			m_align;
		Type			m_type;
		
		RegularProp		m_regular_prop;
		FunctionProp	m_function_prop;

		Property() : m_type( None ) , m_pos( 0 , 0 ) , m_knottype( Direct ) , m_bar_width( 0 ) , m_align( Left ){}
	};
	IParserLink() : IParserItem( IParserItem::Link ){}
public:
//=================================================================================================
virtual
Property cb_call GetProperty() = 0;
//=================================================================================================
virtual
void cb_call SetProperty
		(
		Property&		prop , 
		IUndoList*		undo
		) = 0;
//=================================================================================================
virtual
bool cb_call Save
		(
		IStreamWrite*	file
		) = 0;
//=================================================================================================
virtual
bool cb_call Load
		(
		IStreamRead*	file
		) = 0;
};
/**************************************************************************************************
"ParserNode" class 
**************************************************************************************************/
class ParserNode : 
	public GraphNode , 
	public IParserNode
{
	query_begin();
	iface_hook( IParserItem , IParserItem_IID )
	iface_hook( IParserNode , IParserNode_IID )
	query_end( GraphNode );
	
	//=============================================================================================
	class SetProperty_cmd : public UndoCmd
	{
	public:
		iParserNode		m_this;
		Property		m_prop;
		void cb_call Execute()
		{
			m_this->SetProperty( m_prop , 0 );
		}
	};
	
// variable member
private:
	Property	m_property;

// "IParserNode" interface functions
public:
//=================================================================================================
Property cb_call GetProperty()
{
	return m_property;
}
//=================================================================================================
void cb_call SetProperty
		(
		Property&		prop , 
		IUndoList*		undo 
		)
{
	// undo
	if( undo != 0 )
	{
		{
			instance<SetProperty_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->m_prop	= prop;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<SetProperty_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->m_prop	= m_property;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	// exe
	m_property	= prop;
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	file , 
		int				itemnum , 
		iParserItem*	itemlist , 
		int				nodenum , 
		iParserNode*	nodelist
		)
{
	{
		long	ver = 1;
		if( false == file->Write( &ver , sizeof(ver) , 1 , Little_EndianType ) )
			return false;
	}
	{
		long	v = m_property.m_pos.x;
		if( false == file->Write( &v , sizeof(v) , 1 , Little_EndianType ) )
			return false;
	}
	{
		long	v = m_property.m_pos.y;
		if( false == file->Write( &v , sizeof(v) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( false == file->Write( &m_property.m_type , sizeof(m_property.m_type) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( false == SaveString( file , m_property.m_pushtag_prop.m_tag ) )
			return false;
	}
	{
		if( false == SaveString( file , m_property.m_setattr_prop.m_name ) )
			return false;
		if( false == SaveString( file , m_property.m_setattr_prop.m_value ) )
			return false;
	}
	{
		if( false == SaveString( file , m_property.m_setattrtext_prop.m_name ) )
			return false;
	}
	{
		if( false == SaveString( file , m_property.m_desc_prop.m_desc ) )
			return false;
	}
	{
		// create link list
		class LinkData
		{
		public:
			iParserLink		m_link;
			long			m_output;
		};
		Array<LinkData>	linklist;
		{
			long	off , num = GetOutputNum();
			for( off = 0 ; off < num ; off++ )
			{
				iParserItem		link	= (iParserItem)GetOutput( off );
				if( 0 > search_ary( itemnum , itemlist , link ) )
					continue;
				iParserNode		node	= ( (iGraphLink)link )->GetOutput();
				int				nodeoff	= search_ary( nodenum , nodelist , node );
				if( nodeoff < 0 )
					continue;
				int	t = linklist.Add();
				linklist[t].m_link		= (iParserLink)link;
				linklist[t].m_output	= nodeoff;
			}
		}
		// save link
		{
			long	off , num = linklist.GetDatanum();
			if( false == file->Write( &num , sizeof(num) , 1 , Little_EndianType ) )
				return false;
			for( off = 0 ; off < num ; off++ )
			{
				if( false == file->Write( &linklist[off].m_output , sizeof(linklist[off].m_output) , 1 , Little_EndianType ) )
					return false;
				if( false == linklist[off].m_link->Save( file ) )
					return false;
			}
		}
	}
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	file , 
		IGraph*			graph
		)
{
	{
		long	ver;
		if( 1 != file->Read( &ver , sizeof(ver) , 1 , Little_EndianType ) )
			return false;
		if( ver != 1 )
			return false;
	}
	{
		long	v;
		if( 1 != file->Read( &v , sizeof(v) , 1 , Little_EndianType ) )
			return false;
		m_property.m_pos.x	= v;
	}
	{
		long	v;
		if( 1 != file->Read( &v , sizeof(v) , 1 , Little_EndianType ) )
			return false;
		m_property.m_pos.y	= v;
	}
	{
		if( 1 != file->Read( &m_property.m_type , sizeof(m_property.m_type) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( false == LoadString( file , &m_property.m_pushtag_prop.m_tag ) )
			return false;
	}
	{
		if( false == LoadString( file , &m_property.m_setattr_prop.m_name ) )
			return false;
		if( false == LoadString( file , &m_property.m_setattr_prop.m_value ) )
			return false;
	}
	{
		if( false == LoadString( file , &m_property.m_setattrtext_prop.m_name ) )
			return false;
	}
	{
		if( false == LoadString( file , &m_property.m_desc_prop.m_desc ) )
			return false;
	}
	{
		long	off , num;
		if( 1 != file->Read( &num , sizeof(num) , 1 , Little_EndianType ) )
			return false;
		for( off = 0 ; off < num ; off++ )
		{
			long	noff;
			if( 1 != file->Read( &noff , sizeof(noff) , 1 , Little_EndianType ) )
				return false;
			if( noff < 0 || noff >= graph->GetNodeNum() )
				return false;
			iGraphNode	tgt		= graph->GetNode(noff);
			iParserLink	link	= (iParserLink)AddLink( off , tgt , tgt->GetInputNum() , 0 );
			if( link == false )
				return false;
			if( false == link->Load( file ) )
				return false;
		}
	}
	return true;
}
// public functions
public:
//=================================================================================================
ParserNode()
{
}
};
/**************************************************************************************************
"ParserLink" class 
**************************************************************************************************/
class ParserLink : 
	public GraphLink , 
	public IParserLink
{
	query_begin();
	iface_hook( IParserItem , IParserItem_IID )
	iface_hook( IParserLink , IParserLink_IID )
	query_end( GraphLink );

	//=============================================================================================
	class SetProperty_cmd : public UndoCmd
	{
	public:
		iParserLink		m_this;
		Property		m_prop;
		void cb_call Execute()
		{
			m_this->SetProperty( m_prop , 0 );
		}
	};

// variable member
private:
	Property	m_property;

// "IParserLink" interface functions
public:
//=================================================================================================
Property cb_call GetProperty()
{
	return m_property;
}
//=================================================================================================
void cb_call SetProperty
		(
		Property&		prop , 
		IUndoList*		undo
		)
{
	// undo
	if( undo != 0 )
	{
		{
			instance<SetProperty_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->m_prop	= prop;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<SetProperty_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->m_prop	= m_property;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	// exe
	m_property	= prop;
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	file
		) 
{
	{
		long	ver = 1;
		if( false == file->Write( &ver , sizeof( ver ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		long	v = m_property.m_pos.x;
		if( false == file->Write( &v , sizeof( v ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		long	v = m_property.m_pos.y;
		if( false == file->Write( &v , sizeof( v ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( false == file->Write( &m_property.m_knottype , sizeof( m_property.m_knottype ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( false == file->Write( &m_property.m_bar_width , sizeof( m_property.m_bar_width ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( false == file->Write( &m_property.m_align , sizeof( m_property.m_align ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( false == file->Write( &m_property.m_type , sizeof( m_property.m_type ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( false == SaveString( file , m_property.m_regular_prop.m_exp ) )
			return false;
		if( false == file->Write( &m_property.m_regular_prop.m_seqtype , sizeof( m_property.m_regular_prop.m_seqtype ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( false == SaveString( file , m_property.m_function_prop.m_parser_name ) )
			return false;
	}
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	file
		)
{
	{
		long	ver;
		if( 1 != file->Read( &ver , sizeof( ver ) , 1 , Little_EndianType ) )
			return false;
		if( ver != 1 )
			return false;
	}
	{
		long	v;
		if( 1 != file->Read( &v , sizeof( v ) , 1 , Little_EndianType ) )
			return false;
		m_property.m_pos.x	= v;
	}
	{
		long	v;
		if( 1 != file->Read( &v , sizeof( v ) , 1 , Little_EndianType ) )
			return false;
		m_property.m_pos.y	= v;
	}
	{
		if( 1 != file->Read( &m_property.m_knottype , sizeof( m_property.m_knottype ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( 1 != file->Read( &m_property.m_bar_width , sizeof( m_property.m_bar_width ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( 1 != file->Read( &m_property.m_align , sizeof( m_property.m_align ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( 1 != file->Read( &m_property.m_type , sizeof( m_property.m_type ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( false == LoadString( file , &m_property.m_regular_prop.m_exp ) )
			return false;
		if( 1 != file->Read( &m_property.m_regular_prop.m_seqtype , sizeof( m_property.m_regular_prop.m_seqtype ) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( false == LoadString( file , &m_property.m_function_prop.m_parser_name ) )
			return false;
	}
	return true;
}
// public functions
public:
//=================================================================================================
ParserLink()
{
}
};
/**************************************************************************************************
 "IPasteItems" interface 
***************************************************************************************************/
cb_guid_define( IPasteItems_IID , 0xB3DB9423 , 0x2F554d2a , 0xAF73ED48 , 0x364B2295 );
class IPasteItems;
typedef icubic::iface_object< IPasteItems , IPasteItems_IID >		iPasteItems;
typedef icubic::iface_reference< IPasteItems , IPasteItems_IID >	rPasteItems;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPasteItems
{
public:
//=================================================================================================
virtual
void cb_call AddItem
		(
		iParserItem&	item
		) = 0;
};
/**************************************************************************************************
 "IParserDoc" interface 
***************************************************************************************************/
cb_guid_define( IParserDoc_IID , 0x5CFD0766 , 0xC38A44d5 , 0x813BCD15 , 0x0F60A288 );
class IParserDoc;
typedef icubic::iface_object< IParserDoc , IParserDoc_IID >		iParserDoc;
typedef icubic::iface_reference< IParserDoc , IParserDoc_IID >	rParserDoc;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IParserDoc
{
public:
//=================================================================================================
virtual
wstring cb_call GetName() = 0;
//=================================================================================================
virtual
void cb_call SetName
		(
		const wstring&	name , 
		IUndoList*		undo
		) = 0;
//=================================================================================================
virtual
bool cb_call GetStart() = 0;
//=================================================================================================
virtual
void cb_call SetStart
		(
		bool		start , 
		IUndoList*	undo
		) = 0;
//=================================================================================================
virtual
int cb_call SearchNode
		(
		iParserNode&	node
		) = 0;
//=================================================================================================
virtual
int SearchNodeType
		(
		IParserNode::Property::Type	type
		) = 0;
//=================================================================================================
virtual
iParserItem cb_call SearchParserItemId
		(
		unsigned int	item_id
		) = 0;
//=================================================================================================
virtual
bool cb_call Save
		(
		IStreamWrite*	file , 
		int				itemnum		= 0 , 
		iParserItem*	ltemlist	= 0
		) = 0;
//=================================================================================================
virtual
bool cb_call Load
		(
		IStreamRead*	file
		) = 0;
//=================================================================================================
virtual
bool cb_call Paste
		(
		iParserDoc&		doc , 
		bool			sys_node_cp , 
		IPasteItems*	items , 
		IUndoList*		undo
		) = 0;
};
/**************************************************************************************************
"ParserDoc" class 
**************************************************************************************************/
class ParserDoc : public Graph , public IParserDoc
{
	query_begin();
	iface_hook( IParserDoc , IParserDoc_IID )
	query_end( Graph );

	//=============================================================================================
	class SetName_cmd : public UndoCmd
	{
	public:
		iParserDoc		m_this;
		wstring			m_name;
		void cb_call Execute()
		{
			m_this->SetName( m_name , 0 );
		}
	};
	//=============================================================================================
	class SetStart_cmd : public UndoCmd
	{
	public:
		iParserDoc		m_this;
		bool			m_start;
		void cb_call Execute()
		{
			m_this->SetStart( m_start , 0 );
		}
	};
// variable member
private:
	wstring		m_name;
	bool		m_start;
	
// override functions
private:
//=================================================================================================
iCGraphNode CreateNodeInstance()
{
	return (iCGraphNode)instance<ParserNode>();
}
//=================================================================================================
iCGraphLink CreateLinkInstance()
{
	return (iCGraphLink)instance<ParserLink>();
}
// private functions
private:
//=================================================================================================
iParserNode SearchPropertyType
		(
		IParserNode::Property::Type		type
		)
{
	int		nodeoff , nodenum = GetNodeNum();
	for( nodeoff = 0 ; nodeoff < nodenum ; nodeoff++ )
	{
		iParserNode	node = (iParserNode)GetNode( nodeoff );
		if( node->GetProperty().m_type == type )
			return node;
	}
	return iParserNode();
}
// "IParserDoc" interface functions
public:
//=================================================================================================
wstring cb_call GetName()
{
	return m_name;
}
//=================================================================================================
void cb_call SetName
		(
		const wstring&	name , 
		IUndoList*		undo
		)
{
	if( undo != 0 )
	{
		{
			instance<SetName_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->m_name	= name;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<SetName_cmd>	cmd;
			cmd->m_this = this_object();
			cmd->m_name	= m_name;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	m_name	= name;
}
//=================================================================================================
bool cb_call GetStart()
{
	return m_start;
}
//=================================================================================================
void cb_call SetStart
		(
		bool		start , 
		IUndoList*	undo
		)
{
	if( undo != 0 )
	{
		{
			instance<SetStart_cmd>	cmd;
			cmd->m_this		= this_object();
			cmd->m_start	= start;
			undo->AddRedoCmd( (iUndoCmd)cmd );
		}
		{
			instance<SetStart_cmd>	cmd;
			cmd->m_this		= this_object();
			cmd->m_start	= m_start;
			undo->AddUndoCmd( (iUndoCmd)cmd );
		}
	}
	m_start	= start;
}
//=================================================================================================
int cb_call SearchNode
		(
		iParserNode&	node
		)
{
	int		off , num = GetNodeNum();
	for( off = 0 ; off < num ; off++ )
	{
		if( node == GetNode( off ) )
			return off;
	}
	return -1;
}
//=================================================================================================
int SearchNodeType
		(
		IParserNode::Property::Type	type
		)
{
	int		nodeoff , nodenum = GetNodeNum();
	for( nodeoff = 0 ; nodeoff < nodenum ; nodeoff++ )
	{
		if( type == ((iParserNode)GetNode( nodeoff ))->GetProperty().m_type )
			return nodeoff;
	}
	return -1;
}
//=================================================================================================
iParserItem cb_call SearchParserItemId
		(
		unsigned int	item_id
		)
{
	int		off ,num = GetNodeNum();
	for( off = 0 ; off < num ; off++ )
	{
		iParserItem		node	= (iParserItem)GetNode( off );
		if( node->m_item_id == item_id )
			return node;
		iGraphNode	gnode	= (iGraphNode)node;
		int		poff , pnum = gnode->GetOutputNum();
		for( poff = 0 ; poff < pnum ; poff++ )
		{
			iParserItem		pi = (iParserItem)gnode->GetOutput( poff );
			if( pi->m_item_id == item_id )
				return pi;
		}
	}
	return iParserItem();
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	file , 
		int				itemnum		= 0 , 
		iParserItem*	itemlist	= 0
		)
{
	{
		long	ver = 1;
		if( false == file->Write( &ver , sizeof(ver) , 1 , Little_EndianType ) )
			return false;
	}
	{
		if( false == SaveString( file , m_name ) )
			return false;
	}
	{
		if( false == file->Write( &m_start , sizeof(m_start) , 1 , Little_EndianType ) )
			return false;
	}
	// create itemlist;
	Array<iParserItem>	list;
	if( itemnum == 0 )
	{
		long	off , num = GetNodeNum();
		for( off = 0 ; off < num ;off++ )
		{
			iGraphNode	node = GetNode(off);
			list[ list.Add() ]	= node;
			long	loff , lnum	= node->GetOutputNum();
			for( loff = 0 ; loff < lnum ; loff++ )
				list[list.Add()]	= node->GetOutput(loff);
		}
		itemnum		= list.GetDatanum();
		itemlist	= list.GetPtr();
	}
	// create node list
	Array<iParserNode>	nodelist;
	{
		long	off , num = GetNodeNum();
		for( off = 0 ; off < num ; off++ )
		{
			iParserItem	node	= (iParserItem)GetNode(off);
			if( 0 <= search_ary( itemnum , itemlist , node ) )
				nodelist[ nodelist.Add() ]	= (iParserNode)node;
		}		
	}
	// save nodes
	{
		long	off , num = nodelist.GetDatanum();
		if( false == file->Write( &num , sizeof(num) , 1 , Little_EndianType ) )
			return false;
		for( off = 0 ; off < num ; off++ )
		{
			if( false == nodelist[ off ]->Save( file , itemnum , itemlist , nodelist.GetDatanum() , nodelist.GetPtr() ) )
				return false;
		}
	}
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	file
		)
{
	{
		long	ver;
		if( 1 != file->Read( &ver , sizeof(ver) , 1 , Little_EndianType ) )
			return false;
		if( ver != 1 )
			return false;
	}
	{
		if( false == LoadString( file , &m_name ) )
			return false;
	}
	{
		if( 1 != file->Read( &m_start , sizeof(m_start) , 1 , Little_EndianType ) )
			return false;
	}
	{
		long	off , num;
		if( 1 != file->Read( &num , sizeof(num) , 1 , Little_EndianType ) )
			return false;
			
		while( GetNodeNum() > 0 )
		{
			GetNode(0)->Remove(0);
		}
		for( off = 0 ; off < num ; off++ )
			AddNode( 0 );
		for( off = 0 ; off < num ; off++ )		
		{
			iParserNode	node = (iParserNode)GetNode( off );
			if( false == node->Load( file , (IGraph*)this ) )
				return false;
		}
	}
	return true;
}
//=================================================================================================
bool cb_call Paste
		(
		iParserDoc&		doc , 
		bool			sys_node_cp , 
		IPasteItems*	paste , 
		IUndoList*		undo
		)
{
	iGraph	graph	= (iParserDoc)doc;
	if( graph == false )
		return false;
	
	if( sys_node_cp == true )
		SetName( doc->GetName() , undo );
		
	class ConvNode
	{
	public:
		iGraphNode	m_src;
		iGraphNode	m_dest;
	};
	// create convlist
	Array<ConvNode>		convlist;
	{
		int		nodeoff , nodenum = graph->GetNodeNum();
		for( nodeoff = 0 ; nodeoff < nodenum ; nodeoff++ )
		{
			iParserNode	node	= (iParserNode)graph->GetNode( nodeoff );
			if( node == false )
				return false;
			IParserNode::Property	prop = node->GetProperty();
			if( prop.m_type == IParserNode::Property::Start
			||  prop.m_type == IParserNode::Property::End )
			{
				int	coff = convlist.Add();
				convlist[coff].m_src	= (iGraphNode)node;
				convlist[coff].m_dest	= SearchPropertyType( prop.m_type );
				if( convlist[coff].m_src == false || convlist[coff].m_dest == false )
					return false;
				if( sys_node_cp == true )
					( (iParserNode)convlist[coff].m_dest )->SetProperty( prop , undo );
			}
			else
			{
				int	coff = convlist.Add();
				convlist[coff].m_src	= (iGraphNode)node;
				convlist[coff].m_dest	= AddNode( undo );
				if( convlist[coff].m_src == false || convlist[coff].m_dest == false )
					return false;
				( (iParserNode)convlist[coff].m_dest )->SetProperty( prop , undo );
				if( paste != 0 )
					paste->AddItem( (iParserItem)convlist[coff].m_dest );
			}
		}
	}
	// link
	{
		int		coff , cnum = convlist.GetDatanum();
		for( coff = 0 ; coff < cnum ; coff++ )
		{
			int		linkoff , linknum = convlist[coff].m_src->GetOutputNum();
			for( linkoff = 0 ; linkoff < linknum ; linkoff++ )
			{
				iGraphLink		link	= convlist[coff].m_src->GetOutput( linkoff );
				if( link == false )
					return false;
				iGraphNode		tnode	= link->GetOutput();
				int		toff , tnum = convlist.GetDatanum();
				for( toff = 0 ; toff < tnum ; toff++ )
				{
					if( convlist[toff].m_src == tnode )
						break;
				}
				if( toff == tnum )
					return false;
				iParserLink	tlink = (iParserLink)convlist[coff].m_dest->AddLink
						( 
						convlist[coff].m_dest->GetOutputNum() , 
						convlist[toff].m_dest , 
						convlist[toff].m_dest->GetInputNum() , 
						undo 
						);
				if( tlink == false )
					return false;
				iParserLink		plink = (iParserLink)link;
				if( plink == false )
					return false;
				tlink->SetProperty( plink->GetProperty() , undo );
				if( paste != 0 )
					paste->AddItem( (iParserItem)tlink );
			}
		}
	}
	return true;
}
// public functions
public:
//=================================================================================================
ParserDoc() : m_start( false )
{
	{
		iParserNode	start	= AddNode( 0 );
		IParserNode::Property	prop;
		prop.m_type = IParserNode::Property::Start;
		prop.m_pos	= ivector2( 20 , 100 );
		start->SetProperty( prop , 0 );
	}
	{
		iParserNode	end		= AddNode( 0 );
		IParserNode::Property	prop;
		prop.m_type = IParserNode::Property::End;
		prop.m_pos	= ivector2( 300 , 100 );
		end->SetProperty( prop , 0 );
	}
}
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
cb_inline
wstring NodeTypeToName
		(
		IParserNode::Property::Type		type
		)
{
	if( type == IParserNode::Property::Start )
		return L"Start";
	else if( type == IParserNode::Property::End )
		return L"End";
	else if( type == IParserNode::Property::None )
		return L"None";
	else if( type == IParserNode::Property::ClearText )
		return L"ClearText";
	else if( type == IParserNode::Property::PushTag )
		return L"PushTag";
	else if( type == IParserNode::Property::PopTag )
		return L"PopTag";
	else if( type == IParserNode::Property::SetAttr )
		return L"SetAttr";
	else if( type == IParserNode::Property::SetAttrText )
		return L"SetAttrText";
	else if( type == IParserNode::Property::SetText )
		return L"SetText";
	else
		return L"unknown";
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
